/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.crf;

import com.johnsnowlabs.ml.crf.DatasetMetadata;
import com.johnsnowlabs.ml.crf.EdgeCalculator$;
import com.johnsnowlabs.ml.crf.Instance;
import com.johnsnowlabs.ml.crf.InstanceLabels;
import com.johnsnowlabs.ml.crf.SparseArray;
import com.johnsnowlabs.ml.crf.Transition;
import com.johnsnowlabs.ml.crf.VectorMath$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\u0002)Ba\u0001\u0010\u0001!\u0002\u0013Y\u0003bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0013\u0002\u0001\u000b\u0011B \t\u000f)\u0003!\u0019!C\u0001}!11\n\u0001Q\u0001\n}Bq\u0001\u0014\u0001C\u0002\u0013\u0005Q\n\u0003\u0004S\u0001\u0001\u0006IA\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001N\u0011\u0019!\u0006\u0001)A\u0005\u001d\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB.\u0001A\u0003%q\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003k\u0001\u0011%1\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003s\u0001\u0011%1\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\u0003\u0019\u0019\u00137)\u00197dk2\fGo\u001c:\u000b\u0005iY\u0012aA2sM*\u0011A$H\u0001\u0003[2T!AH\u0010\u0002\u0019)|\u0007N\\:o_^d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u0003%i\u0017\r\u001f'f]\u001e$\b.F\u0001,!\t!C&\u0003\u0002.K\t\u0019\u0011J\u001c;\u0002\u00155\f\u0007\u0010T3oORD\u0007%\u0001\u0005nKR\fG-\u0019;b+\u0005\t\u0004C\u0001\u001a4\u001b\u0005I\u0012B\u0001\u001b\u001a\u0005=!\u0015\r^1tKRlU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005I\u0002\u0001\"B\u0015\u0006\u0001\u0004Y\u0003\"B\u0018\u0006\u0001\u0004\t\u0014A\u00027bE\u0016d7/A\u0004mC\n,Gn\u001d\u0011\u0002\r1|w\r\u00155j+\u0005y\u0004c\u0001\u0013A\u0005&\u0011\u0011)\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0007\u001as!A\r#\n\u0005\u0015K\u0012A\u0003,fGR|'/T1uQ&\u0011q\t\u0013\u0002\u0007\u001b\u0006$(/\u001b=\u000b\u0005\u0015K\u0012a\u00027pOBC\u0017\u000eI\u0001\u0004a\"L\u0017\u0001\u00029iS\u0002\nQ!\u00197qQ\u0006,\u0012A\u0014\t\u0004I\u0001{\u0005CA\"Q\u0013\t\t\u0006J\u0001\u0004WK\u000e$xN]\u0001\u0007C2\u0004\b.\u0019\u0011\u0002\t\t,G/Y\u0001\u0006E\u0016$\u0018\rI\u0001\u0002GV\tq\u000bE\u0002%\u0001b\u0003\"\u0001J-\n\u0005i+#!\u0002$m_\u0006$\u0018AA2!\u0003%\u0019\u0017\r\\2vY\u0006$X\r\u0006\u0003_C\u001aD\u0007C\u0001\u0013`\u0013\t\u0001WE\u0001\u0003V]&$\b\"\u00022\u0013\u0001\u0004\u0019\u0017\u0001C:f]R,gnY3\u0011\u0005I\"\u0017BA3\u001a\u0005!Ien\u001d;b]\u000e,\u0007\"B4\u0013\u0001\u00049\u0016aB<fS\u001eDGo\u001d\u0005\u0006SJ\u0001\r\u0001W\u0001\u0006g\u000e\fG.Z\u0001\bG\u0006d7\r\u00155j)\u0011qF.\u001c8\t\u000b\t\u001c\u0002\u0019A2\t\u000b\u001d\u001c\u0002\u0019A,\t\u000b%\u001c\u0002\u0019\u0001-\u0002\u0013\r\fGnY!ma\"\fGC\u00010r\u0011\u0015\u0011G\u00031\u0001d\u0003!\u0019\u0017\r\\2CKR\fGC\u00010u\u0011\u0015\u0011W\u00031\u0001d\u0003]\tG\rZ(cg\u0016\u0014h/\u001a3FqB,7\r^1uS>t7\u000fF\u0003_obTx\u0010C\u0003h-\u0001\u0007q\nC\u0003z-\u0001\u00071-\u0001\u0005j]N$\u0018M\\2f\u0011\u0015Yh\u00031\u0001}\u00039Ign\u001d;b]\u000e,G*\u00192fYN\u0004\"AM?\n\u0005yL\"AD%ogR\fgnY3MC\n,Gn\u001d\u0005\u0006+Z\u0001\r\u0001W\u0001\u0015C\u0012$Wj\u001c3fY\u0016C\b/Z2uCRLwN\\:\u0015\u000fy\u000b)!a\u0002\u0002\n!)qm\u0006a\u0001\u001f\")!m\u0006a\u0001G\"1\u00111B\fA\u0002a\u000bQaY8ogR\u0004")
public class FbCalculator {
    private final int maxLength;
    private final DatasetMetadata metadata;
    private final int labels;
    private final float[][][] logPhi;
    private final float[][][] phi;
    private final float[][] alpha;
    private final float[][] beta;
    private final float[] c;

    public int maxLength() {
        return this.maxLength;
    }

    public DatasetMetadata metadata() {
        return this.metadata;
    }

    public int labels() {
        return this.labels;
    }

    public float[][][] logPhi() {
        return this.logPhi;
    }

    public float[][][] phi() {
        return this.phi;
    }

    public float[][] alpha() {
        return this.alpha;
    }

    public float[][] beta() {
        return this.beta;
    }

    public float[] c() {
        return this.c;
    }

    public void calculate(Instance sentence, float[] weights, float scale) {
        Predef$.MODULE$.require(sentence.items().length() <= this.maxLength());
        this.calcPhi(sentence, weights, scale);
        this.calcAlpha(sentence);
        this.calcBeta(sentence);
    }

    private void calcPhi(Instance sentence, float[] weights, float scale) {
        int length = sentence.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            EdgeCalculator$.MODULE$.fillLogEdges((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])((SparseArray)sentence.items().apply(i)).values()), weights, scale, this.metadata(), this.logPhi()[i]);
            VectorMath$.MODULE$.copy(this.logPhi()[i], this.phi()[i]);
            VectorMath$.MODULE$.exp(this.phi()[i]);
        });
    }

    private void calcAlpha(Instance sentence) {
        int length = sentence.items().length();
        Predef$.MODULE$.require(length <= this.phi().length);
        VectorMath$.MODULE$.fillMatrix(this.alpha(), 0.0f);
        VectorMath$.MODULE$.fillVector(this.c(), 1.0f);
        VectorMath$.MODULE$.copy(this.phi()[0][0], this.alpha()[0]);
        this.c()[0] = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.alpha()[0])).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        VectorMath$.MODULE$.multiply(this.alpha()[0], 1.0f / this.c()[0]);
        ObjectRef prev = ObjectRef.create((Object)this.alpha()[0]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)from -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)to -> {
                float[] fArray = this.alpha()[i];
                fArray[to] = fArray[to] + ((float[])prev$1.elem)[from] * this.phi()[i][from][to];
            }));
            $this.c()[i] = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.alpha()[i])).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            Predef$.MODULE$.require(this.c()[i] != 0.0f);
            VectorMath$.MODULE$.multiply(this.alpha()[i], 1.0f / this.c()[i]);
            prev$1.elem = this.alpha()[i];
        });
    }

    private void calcBeta(Instance sentence) {
        int length = sentence.items().length();
        Predef$.MODULE$.require(length <= this.phi().length);
        VectorMath$.MODULE$.fillMatrix(this.beta(), 0.0f);
        VectorMath$.MODULE$.fillVector(this.beta()[length - 1], 1.0f / this.c()[length - 1]);
        ObjectRef next = ObjectRef.create((Object)this.beta()[length - 1]);
        package$.MODULE$.Range().inclusive(length - 2, 0, -1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)from -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)to -> {
                float[] fArray = this.beta()[i];
                fArray[from$2] = fArray[from] + this.phi()[i + 1][from][to] * ((float[])next$1.elem)[to];
            }));
            VectorMath$.MODULE$.multiply(this.beta()[i], 1.0f / this.c()[i]);
            next$1.elem = this.beta()[i];
        });
    }

    public void addObservedExpectations(float[] weights, Instance instance, InstanceLabels instanceLabels, float c) {
        int length = instance.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int label = BoxesRunTime.unboxToInt((Object)instanceLabels.labels().apply(i));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((SparseArray)instance.items().apply(i)).values())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addObservedExpectations$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                FbCalculator.$anonfun$addObservedExpectations$3(this, label, weights, c, x$1);
                return BoxedUnit.UNIT;
            });
            int fromLabel = i > 0 ? BoxesRunTime.unboxToInt((Object)instanceLabels.labels().apply(i - 1)) : 0;
            Transition meta = new Transition(fromLabel, label);
            this.metadata().transFeature2Id().get((Object)meta).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fid -> {
                weights$2[fid] = weights[fid] + c;
            });
        });
    }

    public void addModelExpectations(float[] weights, Instance sentence, float f) {
        int length = sentence.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((SparseArray)sentence.items().apply(i)).values())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            FbCalculator.$anonfun$addModelExpectations$3(this, weights, f, i, x$2);
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.metadata().transFeature2Id().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$6(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            FbCalculator.$anonfun$addModelExpectations$7(this, weights, f, i, x$3);
            return BoxedUnit.UNIT;
        }));
        this.metadata().transFeature2Id().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$8(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$9(x$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            FbCalculator.$anonfun$addModelExpectations$10(this, weights, f, x$5);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addObservedExpectations$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addObservedExpectations$3(FbCalculator $this, int label$1, float[] weights$2, float c$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int attrId = tuple2._1$mcI$sp();
        float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        $this.metadata().attrFeatures2Id().get((Object)new Tuple2.mcII.sp(attrId, label$1)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fId -> {
            weights$2[fId] = weights$2[fId] + c$1 * value;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$3(FbCalculator $this, float[] weights$3, float const$1, int i$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int attrId = tuple2._1$mcI$sp();
        float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.metadata().attr2Features().apply(attrId))).foreach((Function1 & Serializable & scala.Serializable)feature -> {
            weights$3[feature.id()] = weights$3[feature.id()] + const$1 * $this.c()[i$3] * $this.alpha()[i$3][feature.label()] * $this.beta()[i$3][feature.label()] * value;
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$6(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$7(FbCalculator $this, float[] weights$3, float const$1, int i$4, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        int fid = tuple2._2$mcI$sp();
        int from = feature.stateFrom();
        int to = feature.stateTo();
        weights$3[fid] = weights$3[fid] + const$1 * $this.alpha()[i$4 - 1][from] * $this.phi()[i$4][from][to] * $this.beta()[i$4][to];
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$8(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$9(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        boolean bl = feature.stateFrom() == 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$10(FbCalculator $this, float[] weights$3, float const$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        int fid = tuple2._2$mcI$sp();
        int to = feature.stateTo();
        weights$3[fid] = weights$3[fid] + const$1 * $this.phi()[0][0][to] * $this.beta()[0][to];
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public FbCalculator(int maxLength, DatasetMetadata metadata) {
        this.maxLength = maxLength;
        this.metadata = metadata;
        this.labels = metadata.label2Id().size();
        this.logPhi = (float[][][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Matrix(this.labels(), this.labels()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        this.phi = (float[][][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Matrix(this.labels(), this.labels()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        this.alpha = (float[][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Vector(this.labels(), VectorMath$.MODULE$.Vector$default$2()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        this.beta = (float[][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Vector(this.labels(), VectorMath$.MODULE$.Vector$default$2()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        this.c = (float[])Array$.MODULE$.fill(maxLength, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f, ClassTag$.MODULE$.Float());
    }
}

