/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.services.pi.model.InvalidArgumentException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.johnsnowlabs.client.CredentialParams;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.client.aws.AWSTokenCredentials;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001\u0002\u000e\u001c\u0001\u0011B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t}\u0001\u0011\t\u0011)A\u0005c!Aq\b\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00032\u0011!\t\u0005A!A!\u0002\u0013\t\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\r\u0003A\u0011\u0001#\t\u000f5\u0003!\u0019!C\t\u001d\"1q\u000b\u0001Q\u0001\n=C\u0001B\b\u0001\t\u0006\u0004%\t\u0001\u0017\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006c\u0002!\tA\u001d\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00111\u0012\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t\t\f\u0001C!\u0003g;\u0011\"!.\u001c\u0003\u0003E\t!a.\u0007\u0011iY\u0012\u0011!E\u0001\u0003sCaaQ\f\u0005\u0002\u0005\u0005\u0007\"CAb/E\u0005I\u0011AAc\u0005)\tukU$bi\u0016<\u0018-\u001f\u0006\u00039u\t1!Y<t\u0015\tqr$\u0001\u0004dY&,g\u000e\u001e\u0006\u0003A\u0005\nAB[8i]Ntwn\u001e7bENT\u0011AI\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0015j\u0003C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011a\u0017M\\4\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019r\u0013BA\u0018(\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u0006Y\u0011mY2fgN\\U-_%e!\t\u00114H\u0004\u00024sA\u0011AgN\u0007\u0002k)\u0011agI\u0001\u0007yI|w\u000e\u001e \u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u]\nqb]3de\u0016$\u0018iY2fgN\\U-_\u0001\rg\u0016\u001c8/[8o)>\\WM\\\u0001\u000bC^\u001c\bK]8gS2,\u0017A\u0002:fO&|g.A\bde\u0016$WM\u001c;jC2\u001cH+\u001f9f\u0003\u0019a\u0014N\\5u}Q9Qi\u0012%J\u0015.c\u0005C\u0001$\u0001\u001b\u0005Y\u0002\"\u0002\u0019\b\u0001\u0004\t\u0004\"\u0002 \b\u0001\u0004\t\u0004\"B \b\u0001\u0004\t\u0004\"\u0002!\b\u0001\u0004\t\u0004\"B!\b\u0001\u0004\t\u0004b\u0002\"\b!\u0003\u0005\r!M\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u000bMdg\r\u000e6\u000b\u0003Q\u000b1a\u001c:h\u0013\t1\u0016K\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!+\u0005I\u0006C\u0001.b\u001b\u0005Y&B\u0001/^\u0003\t\u00198G\u0003\u0002_?\u0006A1/\u001a:wS\u000e,7O\u0003\u0002aC\u0005I\u0011-\\1{_:\fwo]\u0005\u0003En\u0013\u0001\"Q7bu>t7kM\u0001\u0012O\u0016$\u0018)\\1{_:\u001c6g\u00117jK:$HCA-f\u0011\u001517\u00021\u0001h\u0003-\u0019'/\u001a3f]RL\u0017\r\\:\u0011\u0007!L7.D\u00018\u0013\tQwG\u0001\u0004PaRLwN\u001c\t\u0003Y>l\u0011!\u001c\u0006\u0003]~\u000bA!Y;uQ&\u0011\u0001/\u001c\u0002\u000f\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\u000fM\fI!!\u0004\u0002\u0012A\u0019A/\u001f?\u000f\u0005U<hB\u0001\u001bw\u0013\u0005A\u0014B\u0001=8\u0003\u001d\u0001\u0018mY6bO\u0016L!A_>\u0003\t1K7\u000f\u001e\u0006\u0003q^\u00022!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005Q\u0001O]3ue\u0006Lg.\u001a3\u000b\u0007\u0005\rq$A\u0002oYBL1!a\u0002\u007f\u0005A\u0011Vm]8ve\u000e,W*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002\f1\u0001\r!M\u0001\u0007gN\u0002\u0016\r\u001e5\t\r\u0005=A\u00021\u00012\u0003\u00191w\u000e\u001c3fe\"1\u00111\u0003\u0007A\u0002E\naAY;dW\u0016$\u0018!C4fiN\u001bd)\u001b7f)\r\t\u0014\u0011\u0004\u0005\b\u00037i\u0001\u0019AA\u000f\u0003\u0015\u0001\u0018M\u001d;t!\u0011A\u0017qD\u0019\n\u0007\u0005\u0005rG\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0011\u0003Z8fgN\u001btJ\u00196fGR,\u00050[:u)\u0019\t9#!\f\u00020A\u0019\u0001.!\u000b\n\u0007\u0005-rGA\u0004C_>dW-\u00198\t\r\u0005Ma\u00021\u00012\u0011\u0019\t\tD\u0004a\u0001c\u0005Q1o\r$jY\u0016\u0004\u0016\r\u001e5\u0002\u0017\u001d,GoU\u001aPE*,7\r\u001e\u000b\t\u0003o\t\u0019%!\u0012\u0002HA!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>m\u000bQ!\\8eK2LA!!\u0011\u0002<\tqqJ\u00196fGRlU\r^1eCR\f\u0007BBA\n\u001f\u0001\u0007\u0011\u0007\u0003\u0004\u00022=\u0001\r!\r\u0005\b\u0003\u0013z\u0001\u0019AA&\u0003\u001d!X\u000e\u001d$jY\u0016\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#J\u0013AA5p\u0013\u0011\t)&a\u0014\u0003\t\u0019KG.Z\u0001\u0012O\u0016$8k\r#po:dw.\u00193TSj,GCCA.\u0003G\n)'a\u001a\u0002lA!\u0001.[A/!\rA\u0017qL\u0005\u0004\u0003C:$\u0001\u0002'p]\u001eDa!a\u0003\u0011\u0001\u0004\t\u0004BBA\b!\u0001\u0007\u0011\u0007\u0003\u0004\u0002jA\u0001\r!M\u0001\tM&dWMT1nK\"1\u00111\u0003\tA\u0002E\nAbY8qs\u001aKG.\u001a+p'N\"\u0002\"!\u001d\u0002x\u0005e\u00141\u0010\t\u0005\u0003s\t\u0019(\u0003\u0003\u0002v\u0005m\"a\u0004)vi>\u0013'.Z2u%\u0016\u001cX\u000f\u001c;\t\r\u0005M\u0011\u00031\u00012\u0011\u0019\t\t$\u0005a\u0001c!1\u0011QP\tA\u0002E\nab]8ve\u000e,g)\u001b7f!\u0006$\b.A\nd_BL\u0018J\u001c9viN#(/Z1n)>\u001c6\u0007\u0006\u0005\u0002r\u0005\r\u0015QQAD\u0011\u0019\t\u0019B\u0005a\u0001c!1\u0011\u0011\u0007\nA\u0002EBa!! \u0013\u0001\u0004\t\u0014A\u00073po:dw.\u00193GS2,7O\u0012:p[\u0012K'/Z2u_JLH\u0003CAG\u0003'\u000b9*a'\u0011\u0007!\fy)C\u0002\u0002\u0012^\u0012A!\u00168ji\"1\u0011QS\nA\u0002E\n!BY;dW\u0016$h*Y7f\u0011\u0019\tIj\u0005a\u0001c\u0005I1.Z=Qe\u00164\u0017\u000e\u001f\u0005\b\u0003;\u001b\u0002\u0019AA&\u00035!\u0017N]3di>\u0014\u0018\u0010U1uQ\u0006\tr/Y5u\r>\u00148i\\7qY\u0016$\u0018n\u001c8\u0015\t\u00055\u00151\u0015\u0005\b\u0003K#\u0002\u0019AAT\u0003!!(/\u00198tM\u0016\u0014\b\u0003BAU\u0003[k!!a+\u000b\u0007\u0005\u00156,\u0003\u0003\u00020\u0006-&\u0001\u0003+sC:\u001ch-\u001a:\u0002\u000b\rdwn]3\u0015\u0005\u00055\u0015AC!X'\u001e\u000bG/Z<bsB\u0011aiF\n\u0004/\u0005m\u0006c\u00015\u0002>&\u0019\u0011qX\u001c\u0003\r\u0005s\u0017PU3g)\t\t9,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u000fT3!MAeW\t\tY\r\u0005\u0003\u0002N\u0006]WBAAh\u0015\u0011\t\t.a5\u0002\u0013Ut7\r[3dW\u0016$'bAAko\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0017q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AWSGateway
implements AutoCloseable {
    private AmazonS3 client;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final String awsProfile;
    private final String region;
    private final String credentialsType;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$6() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$6();
    }

    public Logger logger() {
        return this.logger;
    }

    private AmazonS3 client$lzycompute() {
        block7: {
            AWSGateway aWSGateway = this;
            synchronized (aWSGateway) {
                CredentialParams credentialParams;
                block9: {
                    block8: {
                        if (this.bitmap$0) break block7;
                        String string = this.region;
                        String string2 = "";
                        if (!(string == null ? string2 != null : !string.equals(string2)) || this.region == null) {
                            throw new InvalidArgumentException("Region argument is mandatory to create Amazon S3 client.");
                        }
                        credentialParams = new CredentialParams(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.awsProfile, this.region);
                        String string3 = this.credentialsType;
                        String string4 = "public";
                        if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block8;
                        String string5 = this.credentialsType;
                        String string6 = "community";
                        if (string5 != null ? !string5.equals(string6) : string6 != null) break block9;
                    }
                    credentialParams = new CredentialParams("anonymous", "", "", "", this.region);
                }
                AWSTokenCredentials awsCredentials = new AWSTokenCredentials();
                Option<AWSCredentials> credentials = awsCredentials.buildCredentials(credentialParams);
                this.client = this.getAmazonS3Client(credentials);
                this.bitmap$0 = true;
            }
        }
        return this.client;
    }

    public AmazonS3 client() {
        return !this.bitmap$0 ? this.client$lzycompute() : this.client;
    }

    private AmazonS3 getAmazonS3Client(Option<AWSCredentials> credentials) {
        AmazonS3ClientBuilder amazonS3ClientBuilder;
        ClientConfiguration config = new ClientConfiguration();
        int timeout = ConfigLoader$.MODULE$.getConfigIntValue(ConfigHelper$.MODULE$.s3SocketTimeout());
        config.setSocketTimeout(timeout);
        if (credentials.isDefined()) {
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials.get())).withClientConfiguration(config);
        } else {
            String warning_message = "Unable to build AWS credential via AWSGateway chain, some parameter is missing or malformed. S3 integration may not work well.";
            this.logger().warn(warning_message);
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config);
        }
        AmazonS3ClientBuilder s3Client = amazonS3ClientBuilder;
        return (AmazonS3)((AwsSyncClientBuilder)s3Client.withRegion(this.region)).build();
    }

    public List<ResourceMetadata> getMetadata(String s3Path, String folder, String bucket) {
        String metaFile = this.getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s3Path, folder, "metadata.json"}));
        S3Object obj = this.client().getObject(bucket, metaFile);
        List<ResourceMetadata> metadata = ResourceMetadata$.MODULE$.readResources((InputStream)obj.getObjectContent());
        return metadata;
    }

    public String getS3File(Seq<String> parts) {
        return ((TraversableOnce)((TraversableLike)parts.map((Function1 & Serializable & scala.Serializable)part -> new StringOps(Predef$.MODULE$.augmentString(part)).stripSuffix("/"), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)AWSGateway.$anonfun$getS3File$2(part)))).mkString("/");
    }

    public boolean doesS3ObjectExist(String bucket, String s3FilePath) {
        boolean bl;
        try {
            this.client().getObjectMetadata(bucket, s3FilePath);
            bl = true;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                bl = false;
            }
            throw e;
        }
        return bl;
    }

    public ObjectMetadata getS3Object(String bucket, String s3FilePath, File tmpFile) {
        GetObjectRequest req = new GetObjectRequest(bucket, s3FilePath);
        return this.client().getObject(req, tmpFile);
    }

    public Option<Object> getS3DownloadSize(String s3Path, String folder, String fileName, String bucket) {
        None$ none$;
        try {
            String s3FilePath = this.getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s3Path, folder, fileName}));
            ObjectMetadata meta = this.client().getObjectMetadata(bucket, s3FilePath);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)meta.getContentLength()));
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                none$ = None$.MODULE$;
            }
            throw e;
        }
        return none$;
    }

    public PutObjectResult copyFileToS3(String bucket, String s3FilePath, String sourceFilePath) {
        File sourceFile = new File(new StringBuilder(7).append("file://").append(sourceFilePath).toString());
        return this.client().putObject(bucket, s3FilePath, sourceFile);
    }

    public PutObjectResult copyInputStreamToS3(String bucket, String s3FilePath, String sourceFilePath) {
        FileSystem fileSystem = FileSystem.get((Configuration)ResourceHelper$.MODULE$.spark().sparkContext().hadoopConfiguration());
        FSDataInputStream inputStream = fileSystem.open(new Path(sourceFilePath));
        return this.client().putObject(bucket, s3FilePath, (InputStream)inputStream, new ObjectMetadata());
    }

    public void downloadFilesFromDirectory(String bucketName, String keyPrefix, File directoryPath) {
        TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.client()).build();
        try {
            MultipleFileDownload multipleFileDownload = transferManager.downloadDirectory(bucketName, keyPrefix, directoryPath);
            Predef$.MODULE$.println((Object)multipleFileDownload.getDescription());
            this.waitForCompletion((Transfer)multipleFileDownload);
        }
        catch (AmazonServiceException e) {
            throw new AmazonServiceException(new StringBuilder(63).append("Amazon service error when downloading files from S3 directory: ").append(e.getMessage()).toString());
        }
        transferManager.shutdownNow();
    }

    private void waitForCompletion(Transfer transfer) {
        try {
            transfer.waitForCompletion();
        }
        catch (AmazonServiceException e) {
            throw new AmazonServiceException(new StringBuilder(22).append("Amazon service error: ").append(e.getMessage()).toString());
        }
        catch (AmazonClientException e) {
            throw new AmazonClientException(new StringBuilder(21).append("Amazon client error: ").append(e.getMessage()).toString());
        }
        catch (InterruptedException e) {
            throw new InterruptedException(new StringBuilder(22).append("Transfer interrupted: ").append(e.getMessage()).toString());
        }
    }

    @Override
    public void close() {
        this.client().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$getS3File$2(String part) {
        return new StringOps(Predef$.MODULE$.augmentString(part)).nonEmpty();
    }

    public AWSGateway(String accessKeyId, String secretAccessKey, String sessionToken, String awsProfile, String region, String credentialsType) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.awsProfile = awsProfile;
        this.region = region;
        this.credentialsType = credentialsType;
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
    }
}

