/*
 * Decompiled with CFR 0.152.
 */
package com.intellifylearning.gson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.intellify.api.caliper.impl.events.Event;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntellifyEventSerializer
extends JsonSerializer<Event> {
    private static final Logger logger = LoggerFactory.getLogger((String)"intellisense");
    private static final String CLASSNAME = "@class";
    private static final String INSTANCE = "@instance";

    public void serialize(Event value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        JsonSerializer serializer = provider.findValueSerializer(Event.class, null);
        serializer.unwrappingSerializer(null).serialize((Object)value, jgen, provider);
        String className = value.getClass().getCanonicalName();
        jgen.writeObjectField(CLASSNAME, (Object)className);
        jgen.writeEndObject();
    }
}

