/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.security;

import com.google.common.base.Preconditions;
import java.util.EnumMap;

public enum RoleType {
    ROLE_SUPER_ADMIN("SuperAdmin", "superAdminRole-42-2012", "admin", "LIaaS Admin", "admin/organize"),
    SYSROLE_SYSTEM_ADMIN("SystemAdmin", "urn:lti:sysrole:ims/lis/SysAdmin", "admin", "LIaaS Technical Admin", "admin/organize"),
    ROLE_PUBLISHER_ADMIN("PublisherAdmin", "urn:lti:role:ims/lis/ContentDeveloper", "admin", "LIaaS Analyst/Designer", "admin/organize"),
    ROLE_DESIGNER("Designer", "designerRole-42-2012", "manage", "Organization Analyst/Designer", "admin/organize"),
    SYSROLE_ADMIN("Admin", "urn:lti:sysrole:ims/lis/Administrator", "manage", "Organization Admin", "admin/organize"),
    ROLE_INSTRUCTOR("Instructor", "urn:lti:role:ims/lis/Instructor", "org", "EDU Instructor", "dashboard"),
    ROLE_PRODUCT_ADMIN("ProductAdmin", "urn:lti:role:ims/lis/ContentDeveloper/ContentDeveloper", "org", "Product Admin", "dashboard"),
    ROLE_EDU_INSTITUTION_ADMIN("EduInstitutionAdmin", "urn:lti:role:ims/lis/Administrator", "org", "Edu Institution Admin", "dashboard"),
    ROLE_EDU_DEPARTMENT_ADMIN("EduDepartmentAdmin", "urn:lti:role:ims/lis/Administrator/Administrator", "org", "Edu Department Admin", "dashboard"),
    ROLE_TEACHING_ASSISTANT("TeachingAssistant", "urn:lti:role:ims/lis/TeachingAssistant", "org", "EDU Teaching Assistant", "dashboard"),
    ROLE_LEARNER("Learner", "urn:lti:role:ims/lis/Learner", "org", "Edu Learner", "dashboard"),
    ROLE_ANONYMOUS("anonymous", "anonymous", "", "Anonymous User", "login"),
    INSTROLE_STUDENT("Student", "urn:lti:instrole:ims/lis/Student", "org", "Institution Student", "dashboard"),
    INSTROLE_INSTRUCTOR("InstInstructor", "urn:lti:instrole:ims/lis/Instructor", "org", "Institution EDU Instructor", "dashboard"),
    INSTROLE_LEARNER("InstLearner", "urn:lti:instrole:ims/lis/Learner", "org", "Institution Learner", "dashboard"),
    SYSROLE_STUDENT("Student", "urn:lti:sysrole:ims/lis/Student", "sys", "Student", "dashboard");

    private String name;
    private String uniqueKey;
    private String group;
    private String label;
    private String defaultPage;
    private static EnumMap<RoleType, String> roleEMap;
    private static EnumMap<RoleType, String> unqiueKeyEMap;
    private static EnumMap<RoleType, String> groupEMap;

    private RoleType(String name, String uniqueKey, String group, String label, String defaultPage) {
        this.name = name;
        this.uniqueKey = uniqueKey;
        this.group = group;
        this.label = label;
        this.defaultPage = defaultPage;
    }

    protected String getName() {
        return this.name;
    }

    protected String getUniqueKey() {
        return this.uniqueKey;
    }

    public String getLabel() {
        return this.label;
    }

    protected String getGroup() {
        return this.group;
    }

    protected String getDefaultPage() {
        return this.defaultPage;
    }

    public static RoleType getRoleType(String roleNameOrUniqueKey) {
        Preconditions.checkNotNull((Object)roleNameOrUniqueKey);
        for (RoleType roleType : roleEMap.keySet()) {
            if (!roleType.getName().equalsIgnoreCase(roleNameOrUniqueKey)) continue;
            return roleType;
        }
        for (RoleType roleType : unqiueKeyEMap.keySet()) {
            if (!roleType.getUniqueKey().equalsIgnoreCase(roleNameOrUniqueKey)) continue;
            return roleType;
        }
        return null;
    }

    public static String getName(RoleType roleType) {
        return roleEMap.get((Object)roleType);
    }

    public static String getUniqueKey(RoleType roleType) {
        return unqiueKeyEMap.get((Object)roleType);
    }

    public static String getGroup(RoleType roleType) {
        return groupEMap.get((Object)roleType);
    }

    public static String getLabel(RoleType roleType) {
        return roleType.getLabel();
    }

    public static String getDefaultPage(RoleType roleType) {
        return roleType.getDefaultPage();
    }

    static {
        if (null == roleEMap) {
            roleEMap = new EnumMap(RoleType.class);
        }
        roleEMap.clear();
        for (RoleType role : RoleType.values()) {
            roleEMap.put(role, role.getName());
        }
        if (null == unqiueKeyEMap) {
            unqiueKeyEMap = new EnumMap(RoleType.class);
        }
        unqiueKeyEMap.clear();
        for (RoleType role : RoleType.values()) {
            unqiueKeyEMap.put(role, role.getUniqueKey());
        }
        if (null == groupEMap) {
            groupEMap = new EnumMap(RoleType.class);
        }
        groupEMap.clear();
        for (RoleType role : RoleType.values()) {
            if (role.getGroup().isEmpty()) continue;
            groupEMap.put(role, role.getGroup());
        }
    }
}

