/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.security;

import com.intellify.api.Entity;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Role
extends Entity {
    private String roleUniqueKey;
    @Indexed
    @NotBlank
    private String role;
    private String roleDescription;
    private String group;
    private String defaultPage;

    public Role() {
    }

    public Role(String role) {
        this.role = role;
    }

    public Role(String role, String roleDescription) {
        this(role, roleDescription, "", "");
    }

    public Role(String role, String roleDescription, String group, String defaultPage) {
        this.role = role;
        this.roleDescription = roleDescription;
        this.group = group;
        this.defaultPage = defaultPage;
    }

    public String getRoleUniqueKey() {
        return this.roleUniqueKey;
    }

    public void setRoleUniqueKey(String roleUniqueKey) {
        this.roleUniqueKey = roleUniqueKey;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Role other = (Role)obj;
            if (this.getUuid().equalsIgnoreCase(other.getUuid()) && this.getRole().equalsIgnoreCase(other.getRole()) && this.getRoleUniqueKey().equalsIgnoreCase(other.getRoleUniqueKey())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Role [uuid=").append(this.getUuid()).append(", role=").append(this.role).append(", roleDescription=").append(this.roleDescription).append(", roleUniqueKey=").append(this.roleUniqueKey).append(", group=").append(this.group).append(", defaultPage=").append(this.defaultPage).append("]");
        return builder.toString();
    }
}

