/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.jobs;

import com.google.common.collect.Lists;
import com.intellify.api.jobs.QuartzJobTrigger;
import java.util.List;
import java.util.Map;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class QuartzJobDetail {
    private String key;
    private String description;
    private String jobClass;
    private boolean isDurable;
    private boolean isPersistDataAfterExecution;
    private boolean isConcurrentExectionDisallowed;
    private Map jobDataMap;
    private List<QuartzJobTrigger> quartzJobTriggers;

    public QuartzJobDetail(JobDetail jobdetail, List<? extends Trigger> triggers) {
        this.key = jobdetail.getKey().toString();
        this.description = jobdetail.getDescription();
        this.jobClass = jobdetail.getJobClass().getSimpleName();
        this.jobDataMap = jobdetail.getJobDataMap();
        this.isDurable = jobdetail.isDurable();
        this.isPersistDataAfterExecution = jobdetail.isPersistJobDataAfterExecution();
        this.isConcurrentExectionDisallowed = jobdetail.isConcurrentExectionDisallowed();
        this.quartzJobTriggers = Lists.newArrayList();
        for (Trigger trigger : triggers) {
            this.quartzJobTriggers.add(new QuartzJobTrigger(trigger));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobClass() {
        return this.jobClass;
    }

    public Map getJobDataMap() {
        return this.jobDataMap;
    }

    public List<QuartzJobTrigger> getQuartzJobTriggers() {
        return this.quartzJobTriggers;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public boolean isPersistDataAfterExecution() {
        return this.isPersistDataAfterExecution;
    }

    public boolean isConcurrentExectionDisallowed() {
        return this.isConcurrentExectionDisallowed;
    }
}

