/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.validators;

import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.entities.Session;
import com.intellify.api.caliper.impl.entities.lis.Person;
import com.intellify.api.caliper.impl.profiles.SessionProfile;
import com.intellify.api.caliper.impl.validators.EventValidator;
import com.intellify.api.caliper.impl.validators.ValidatorResult;
import com.intellify.api.caliper.impl.validators.ValidatorUtils;

public class SessionValidator {
    public static ValidatorResult validate(Session session, String key) {
        String context = "Session ";
        ValidatorResult result = new ValidatorResult();
        if (!session.getType().equals(Entity.Type.SESSION.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.TYPE_ERROR.violation());
        }
        if (!ValidatorUtils.isOfType(session.getActor(), Person.class)) {
            result.errorMessage().appendText(context + EventValidator.Conformance.ACTOR_NOT_PERSON.violation());
        }
        if (key.equals(SessionProfile.Actions.LOGGEDOUT.key()) || key.equals(SessionProfile.Actions.TIMEDOUT.key())) {
            if (!ValidatorUtils.checkStartedAtTime(session.getStartedAtTime())) {
                result.errorMessage().appendText(context + EventValidator.Conformance.STARTEDATTIME_IS_NULL.violation());
            }
        } else if (!ValidatorUtils.checkStartedAtTime(session.getStartedAtTime())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.STARTEDATTIME_IS_NULL.violation());
        }
        if (result.errorMessage().length() == 0) {
            result.setIsValid(true);
        }
        return result;
    }
}

