/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.validators;

import com.intellify.api.caliper.impl.entities.DigitalResource;
import com.intellify.api.caliper.impl.entities.Session;
import com.intellify.api.caliper.impl.entities.SoftwareApplication;
import com.intellify.api.caliper.impl.entities.lis.Person;
import com.intellify.api.caliper.impl.events.Event;
import com.intellify.api.caliper.impl.profiles.SessionProfile;
import com.intellify.api.caliper.impl.validators.EventValidator;
import com.intellify.api.caliper.impl.validators.SessionValidator;
import com.intellify.api.caliper.impl.validators.ValidatorResult;
import com.intellify.api.caliper.impl.validators.ValidatorUtils;

public class SessionEventValidator
implements EventValidator {
    private String key;

    public SessionEventValidator(String key) {
        this.key = key;
    }

    @Override
    public ValidatorResult validate(Event event) {
        String context = "SessionLoginEvent ";
        ValidatorResult result = new ValidatorResult();
        if (!event.getContext().equals(Event.Context.SESSION.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.CONTEXT_ERROR.violation());
        }
        if (!event.getType().equals(Event.Type.SESSION.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.TYPE_ERROR.violation());
        }
        if (this.key.equals(SessionProfile.Actions.TIMEDOUT.key())) {
            if (!ValidatorUtils.isOfType(event.getActor(), SoftwareApplication.class)) {
                result.errorMessage().appendText(context + EventValidator.Conformance.ACTOR_NOT_SOFTWAREAPP.violation());
            }
        } else if (!ValidatorUtils.isOfType(event.getActor(), Person.class)) {
            result.errorMessage().appendText(context + EventValidator.Conformance.ACTOR_NOT_PERSON.violation());
        }
        if (this.key.equals(SessionProfile.Actions.LOGGEDIN.key())) {
            if (!ValidatorUtils.isOfType(event.getTarget(), DigitalResource.class)) {
                result.errorMessage().appendText(context + EventValidator.Conformance.TARGET_NOT_DIGITALRESOURCE.violation());
            }
        } else {
            ValidatorResult sessionValidatorResult = SessionValidator.validate((Session)event.getTarget(), this.key);
            if (!sessionValidatorResult.isValid()) {
                result.errorMessage().appendText(sessionValidatorResult.errorMessage().toString());
            }
        }
        if (!ValidatorUtils.checkStartedAtTime(event.getStartedAtTime())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.STARTEDATTIME_IS_NULL.violation());
        }
        if (!this.key.equals(SessionProfile.Actions.LOGGEDIN.key())) {
            if (ValidatorUtils.checkEndedAtTime(event.getEndedAtTime())) {
                if (!ValidatorUtils.checkStartEndTimes(event.getStartedAtTime(), event.getEndedAtTime())) {
                    result.errorMessage().appendText(context + EventValidator.Conformance.TIME_ERROR.violation());
                }
            } else {
                result.errorMessage().appendText(context + EventValidator.Conformance.ENDEDATTIME_IS_NULL.violation());
            }
        }
        if (!ValidatorUtils.checkDuration(event.getDuration())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.DURATION_INVALID.violation());
        }
        if (result.errorMessage().length() == 0) {
            result.setIsValid(true);
        } else {
            result.errorMessage().endMessage("Caliper Session profile conformance:");
        }
        return result;
    }
}

