/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.validators;

import com.intellify.api.caliper.impl.entities.assignable.Attempt;
import com.intellify.api.caliper.impl.events.Event;
import com.intellify.api.caliper.impl.validators.AttemptValidator;
import com.intellify.api.caliper.impl.validators.EventValidator;
import com.intellify.api.caliper.impl.validators.ValidatorResult;
import com.intellify.api.caliper.impl.validators.ValidatorUtils;

public class OutcomeEventValidator
implements EventValidator {
    @Override
    public ValidatorResult validate(Event event) {
        ValidatorResult attemptValidatorResult;
        String context = "AssessmentEvent ";
        ValidatorResult result = new ValidatorResult();
        if (!event.getContext().equals(Event.Context.OUTCOME.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.CONTEXT_ERROR.violation());
        }
        if (!event.getType().equals(Event.Type.OUTCOME.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.TYPE_ERROR.violation());
        }
        if (!(attemptValidatorResult = AttemptValidator.validate((Attempt)event.getObject())).isValid()) {
            result.errorMessage().appendText(attemptValidatorResult.errorMessage().toString());
        }
        if (event.getTarget() != null) {
            result.errorMessage().appendText(context + EventValidator.Conformance.TARGET_NOT_NULL.violation());
        }
        if (ValidatorUtils.checkStartedAtTime(event.getStartedAtTime())) {
            if (!ValidatorUtils.checkStartEndTimes(event.getStartedAtTime(), event.getEndedAtTime())) {
                result.errorMessage().appendText(context + EventValidator.Conformance.TIME_ERROR.violation());
            }
        } else {
            result.errorMessage().appendText(context + EventValidator.Conformance.STARTEDATTIME_IS_NULL.violation());
        }
        if (!ValidatorUtils.checkDuration(event.getDuration())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.DURATION_INVALID.violation());
        }
        if (result.errorMessage().length() == 0) {
            result.setIsValid(true);
        } else {
            result.errorMessage().endMessage("Caliper Outcome profile conformance:");
        }
        return result;
    }
}

