/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.validators;

import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.entities.assignable.Attempt;
import com.intellify.api.caliper.impl.validators.EventValidator;
import com.intellify.api.caliper.impl.validators.ValidatorResult;
import com.intellify.api.caliper.impl.validators.ValidatorUtils;

public class AttemptValidator {
    public static ValidatorResult validate(Attempt attempt) {
        String context = "Attempt ";
        ValidatorResult result = new ValidatorResult();
        if (!attempt.getType().equals(Entity.Type.ATTEMPT.uri())) {
            result.errorMessage().appendText(context + EventValidator.Conformance.TYPE_ERROR.violation());
        }
        if (attempt.getCount() < 1) {
            result.errorMessage().appendText(context + EventValidator.Conformance.COUNT_NOT_ZERO.violation());
        }
        if (ValidatorUtils.checkStartedAtTime(attempt.getStartedAtTime())) {
            if (!ValidatorUtils.checkStartEndTimes(attempt.getStartedAtTime(), attempt.getEndedAtTime())) {
                result.errorMessage().appendText(context + EventValidator.Conformance.TIME_ERROR.violation());
            }
        } else {
            result.errorMessage().appendText(context + EventValidator.Conformance.STARTEDATTIME_IS_NULL.violation());
        }
        if (result.errorMessage().length() == 0) {
            result.setIsValid(true);
        }
        return result;
    }
}

