/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.google.common.collect.ImmutableMap;
import com.intellify.api.caliper.impl.events.SessionEvent;
import com.intellify.api.caliper.impl.profiles.AssessmentItemProfile;
import com.intellify.api.caliper.impl.validators.EventValidator;
import com.intellify.api.caliper.impl.validators.EventValidatorContext;
import com.intellify.api.caliper.impl.validators.SessionEventValidator;
import com.intellify.api.caliper.impl.validators.ValidatorResult;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class SessionProfile {
    public static String getActionFromBundle(String key) {
        if (AssessmentItemProfile.AssessmentItemActions.hasKey(key) || Actions.hasKey(key)) {
            ResourceBundle rBundle = ResourceBundle.getBundle("actions");
            return rBundle.getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static ValidatorResult validateEvent(SessionEvent event) {
        return Actions.validateEvent(event);
    }

    public static enum Actions {
        STARTED("session.started"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                EventValidatorContext validator = new EventValidatorContext(new SessionEventValidator(STARTED.key()));
                return validator.validate(event);
            }
        }
        ,
        COMPLETED("session.completed"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                EventValidatorContext validator = new EventValidatorContext(new SessionEventValidator(COMPLETED.key()));
                return validator.validate(event);
            }
        }
        ,
        LOGGEDIN("session.loggedIn"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                EventValidatorContext validator = new EventValidatorContext(new SessionEventValidator(LOGGEDIN.key()));
                return validator.validate(event);
            }
        }
        ,
        LOGGEDOUT("session.loggedOut"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                EventValidatorContext validator = new EventValidatorContext(new SessionEventValidator(LOGGEDOUT.key()));
                return validator.validate(event);
            }
        }
        ,
        TIMEDOUT("session.timedOut"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                EventValidatorContext validator = new EventValidatorContext(new SessionEventValidator(TIMEDOUT.key()));
                return validator.validate(event);
            }
        }
        ,
        UNRECOGNIZED("action.unrecognized"){

            @Override
            ValidatorResult validate(SessionEvent event) {
                ValidatorResult result = new ValidatorResult();
                result.errorMessage().appendText("Caliper Session profile conformance: " + EventValidator.Conformance.ACTION_UNRECOGNIZED.violation());
                result.errorMessage().endSentence();
                return result;
            }
        };

        private final String key;
        private static Map<String, Actions> lookup;

        private Actions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static String lookupKey(String action) {
            ResourceBundle bundle = ResourceBundle.getBundle("actions");
            for (Map.Entry<String, Actions> entry : lookup.entrySet()) {
                if (!action.equals(bundle.getString(entry.getKey()))) continue;
                return entry.getKey();
            }
            return UNRECOGNIZED.key();
        }

        abstract ValidatorResult validate(SessionEvent var1);

        protected static ValidatorResult validateEvent(SessionEvent event) {
            return Actions.matchConstant(event.getAction()).validate(event);
        }

        private static Actions matchConstant(String action) {
            ResourceBundle bundle = ResourceBundle.getBundle("actions");
            for (Map.Entry<String, Actions> entry : lookup.entrySet()) {
                if (!action.equals(bundle.getString(entry.getKey()))) continue;
                return entry.getValue();
            }
            return UNRECOGNIZED;
        }

        static {
            HashMap<String, Actions> map = new HashMap<String, Actions>();
            for (Actions constants : Actions.values()) {
                map.put(constants.key(), constants);
            }
            lookup = ImmutableMap.copyOf(map);
        }
    }
}

