/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.DigitalResource;
import com.intellify.api.caliper.impl.entities.Targetable;
import com.intellify.api.caliper.impl.entities.reading.Frame;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class ReadingProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (ReadingActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static String getViewActionFromBundle(String key) {
        if (key.equals(ReadingActions.VIEWED.key())) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static DigitalResource validateObject(Object object) {
        if (object instanceof DigitalResource) {
            return (DigitalResource)object;
        }
        throw new ClassCastException("Object must be of type DigitalResource.");
    }

    public static Frame validateTarget(Targetable target) {
        if (target instanceof Frame) {
            return (Frame)target;
        }
        throw new ClassCastException("Target must be of type Frame.");
    }

    public static enum ReadingActions {
        SEARCHED("reading.searched"),
        VIEWED("reading.viewed");

        private final String key;
        private static final Map<String, ReadingActions> lookup;

        private ReadingActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static ReadingActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, ReadingActions>();
            for (ReadingActions constants : ReadingActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

