/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.Targetable;
import com.intellify.api.caliper.impl.entities.media.AudioObject;
import com.intellify.api.caliper.impl.entities.media.ImageObject;
import com.intellify.api.caliper.impl.entities.media.MediaLocation;
import com.intellify.api.caliper.impl.entities.media.MediaObject;
import com.intellify.api.caliper.impl.entities.media.VideoObject;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MediaProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (MediaActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static MediaObject validateObject(Object object) {
        if (object instanceof AudioObject) {
            return (AudioObject)object;
        }
        if (object instanceof ImageObject) {
            return (ImageObject)object;
        }
        if (object instanceof VideoObject) {
            return (VideoObject)object;
        }
        throw new ClassCastException("Object must be of type MediaObject.");
    }

    public static MediaLocation validateTarget(Targetable target) {
        if (target instanceof MediaLocation) {
            return (MediaLocation)target;
        }
        throw new ClassCastException("Target must be of type MediaLocation.");
    }

    public static enum MediaActions {
        ENABLEDCLOSEDCAPTIONING("media.accessibility.enabledClosedCaptioning"),
        DISABLEDCLOSEDCAPTIONING("media.accessibility.disabledClosedCaptioning"),
        CHANGEDVOLUME("media.audio.changedVolume"),
        MUTED("media.audio.muted"),
        UNMUTED("media.audio.unmuted"),
        CHANGEDSPEED("media.playback.changedSpeed"),
        ENDED("media.playback.ended"),
        JUMPEDTO("media.playback.jumpedTo"),
        FORWARDEDTO("media.playback.forwardedTo"),
        PAUSED("media.playback.paused"),
        RESUMED("media.playback.resumed"),
        REWINDED("media.playback.rewindedTo"),
        STARTED("media.playback.started"),
        CHANGEDRESOLUTION("media.viewer.changedResolution"),
        CHANGEDSIZE("media.viewer.changedSize"),
        CLOSEDPOPOUT("media.viewer.closedPopout"),
        ENTEREDFULLSCREEN("media.viewer.enteredFullScreen"),
        EXITEDFULLSCREEN("media.viewer.exitedFullScreen"),
        OPENEDPOPOUT("media.viewer.openedPopout"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, MediaActions> lookup;

        private MediaActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static MediaActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, MediaActions>();
            for (MediaActions constants : MediaActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

