/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.Generatable;
import com.intellify.api.caliper.impl.entities.assessment.Assessment;
import com.intellify.api.caliper.impl.entities.assignable.Attempt;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class AssessmentProfile
extends Profile {
    public static String getActionFromBundle(String key) {
        if (AssessmentActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            return ResourceBundle.getBundle("actions").getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static Assessment validateObject(Object object) {
        if (object instanceof Assessment) {
            return (Assessment)object;
        }
        throw new ClassCastException("Object must be of type Assessment.");
    }

    public static Attempt validateGenerated(Generatable generated) {
        if (generated instanceof Attempt) {
            return (Attempt)generated;
        }
        throw new ClassCastException("Generatable must be of type Attempt.");
    }

    public static enum AssessmentActions {
        STARTED("assessment.started"),
        PAUSED("assessment.paused"),
        RESTARTED("assessment.restarted"),
        SUBMITTED("assessment.submitted"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, AssessmentActions> lookup;

        private AssessmentActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static AssessmentActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, AssessmentActions>();
            for (AssessmentActions constants : AssessmentActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

