/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.profiles;

import com.intellify.api.caliper.impl.entities.assessment.AssessmentItem;
import com.intellify.api.caliper.impl.profiles.Profile;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentItemProfile
extends Profile {
    private static final Logger LOG = LoggerFactory.getLogger(AssessmentItemProfile.class);

    public static String getActionFromBundle(String key) {
        if (AssessmentItemActions.hasKey(key) || Profile.Actions.hasKey(key)) {
            ResourceBundle rBundle = ResourceBundle.getBundle("actions");
            LOG.debug("#### Loaded ResourceBundle" + rBundle + " with keys = " + rBundle.getKeys());
            return rBundle.getString(key);
        }
        throw new IllegalArgumentException("Unrecognized key: " + key);
    }

    public static AssessmentItem validateObject(Object object) {
        if (object instanceof AssessmentItem) {
            return (AssessmentItem)object;
        }
        throw new ClassCastException("Object must be of type AssessmentItem.");
    }

    public static enum AssessmentItemActions {
        STARTED("assessment.item.started"),
        COMPLETED("assessment.item.completed"),
        SKIPPED("assessment.item.skipped"),
        REVIEWED("assessment.item.reviewed"),
        VIEWED("assessment.item.viewed"),
        NAVIGATED_TO("navigation.navigatedTo");

        private final String key;
        private static final Map<String, AssessmentItemActions> lookup;

        private AssessmentItemActions(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public static boolean hasKey(String key) {
            return lookup.containsKey(key);
        }

        public static AssessmentItemActions lookupConstant(String key) {
            return lookup.get(key);
        }

        static {
            lookup = new HashMap<String, AssessmentItemActions>();
            for (AssessmentItemActions constants : AssessmentItemActions.values()) {
                lookup.put(constants.key(), constants);
            }
        }
    }
}

