/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellify.api.caliper.impl.entities.DigitalResource;
import com.intellify.api.caliper.impl.events.Event;
import com.intellify.api.caliper.impl.profiles.Profile;

public class NavigationEvent
extends Event {
    @JsonProperty(value="navigatedFrom")
    private DigitalResource fromResource;

    public NavigationEvent() {
    }

    protected NavigationEvent(Builder<?> builder) {
        super(builder);
        this.fromResource = ((Builder)builder).fromResource;
    }

    public DigitalResource getFromResource() {
        return this.fromResource;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Event.Builder<T> {
        private DigitalResource fromResource;

        public Builder() {
            this.context(Event.Context.NAVIGATION.uri());
            this.type(Event.Type.NAVIGATION.uri());
            this.action(Profile.Actions.NAVIGATED_TO.key());
        }

        @Override
        public T action(String key) {
            try {
                super.action(Profile.getNavigatedToActionFromBundle(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return (T)((Builder)this.self());
        }

        public T fromResource(DigitalResource fromResource) {
            this.fromResource = fromResource;
            return (T)((Builder)this.self());
        }

        public NavigationEvent build() {
            return new NavigationEvent(this);
        }
    }
}

