/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.events;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellify.api.caliper.impl.entities.media.MediaLocation;
import com.intellify.api.caliper.impl.entities.media.MediaObject;
import com.intellify.api.caliper.impl.events.Event;
import com.intellify.api.caliper.impl.profiles.MediaProfile;

@JsonPropertyOrder(value={"@context", "@type", "actor", "action", "object", "target", "generated", "startedAtTime", "endedAtTime", "duration", "edApp", "group"})
public class MediaEvent
extends Event {
    public MediaEvent() {
    }

    protected MediaEvent(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Event.Builder<T> {
        private MediaObject object;
        private MediaLocation target;

        public Builder() {
            this.context(Event.Context.MEDIA.uri());
            this.type(Event.Type.MEDIA.uri());
        }

        @Override
        public T action(String key) {
            try {
                super.action(MediaProfile.getActionFromBundle(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return (T)((Builder)this.self());
        }

        public MediaEvent build() {
            return new MediaEvent(this);
        }
    }
}

