/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.entities.lis;

import com.google.common.collect.Lists;
import com.intellify.api.caliper.impl.entities.Entity;
import com.intellify.api.caliper.impl.entities.foaf.Agent;
import java.util.List;

public class Person
extends Entity
implements Agent {
    private String firstName;
    private String lastName;
    private String email;
    private List<String> roles;

    public Person() {
        this.roles = Lists.newArrayList();
    }

    protected Person(Builder<?> builder) {
        super(builder);
        this.firstName = ((Builder)builder).firstName;
        this.lastName = ((Builder)builder).lastName;
        this.email = ((Builder)builder).email;
        this.roles = ((Builder)builder).roles;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Entity.Builder<T> {
        private String firstName;
        private String lastName;
        private String email;
        private List<String> roles;

        public Builder() {
            this.type(Entity.Type.LIS_PERSON.uri());
        }

        public T firstName(String firstName) {
            this.firstName = firstName;
            return (T)((Builder)this.self());
        }

        public T lastName(String lastName) {
            this.lastName = lastName;
            return (T)((Builder)this.self());
        }

        public T email(String email) {
            this.email = email;
            return (T)((Builder)this.self());
        }

        public T roles(List<String> roles) {
            this.roles = roles;
            return (T)((Builder)this.self());
        }

        public Person build() {
            return new Person(this);
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

