/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.caliper.impl.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.intellify.api.caliper.impl.entities.LearningObjective;
import com.intellify.api.caliper.impl.entities.Reference;
import com.intellify.api.caliper.impl.entities.Session;
import com.intellify.api.caliper.impl.entities.SoftwareApplication;
import com.intellify.api.caliper.impl.entities.annotation.BookmarkAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.HighlightAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.SharedAnnotation;
import com.intellify.api.caliper.impl.entities.annotation.TagAnnotation;
import com.intellify.api.caliper.impl.entities.assessment.Assessment;
import com.intellify.api.caliper.impl.entities.assessment.AssessmentItem;
import com.intellify.api.caliper.impl.entities.assignable.AssignableDigitalResource;
import com.intellify.api.caliper.impl.entities.lis.CourseSection;
import com.intellify.api.caliper.impl.entities.lis.Organization;
import com.intellify.api.caliper.impl.entities.lis.Person;
import com.intellify.api.caliper.impl.entities.media.AudioObject;
import com.intellify.api.caliper.impl.entities.media.ImageObject;
import com.intellify.api.caliper.impl.entities.media.MediaLocation;
import com.intellify.api.caliper.impl.entities.media.VideoObject;
import com.intellify.api.caliper.impl.entities.reading.EpubChapter;
import com.intellify.api.caliper.impl.entities.reading.EpubPart;
import com.intellify.api.caliper.impl.entities.reading.EpubSubChapter;
import com.intellify.api.caliper.impl.entities.reading.EpubVolume;
import com.intellify.api.caliper.impl.entities.reading.Frame;
import com.intellify.api.caliper.impl.entities.reading.Reading;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="iType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Session.class, name="session"), @JsonSubTypes.Type(value=Person.class, name="person"), @JsonSubTypes.Type(value=Organization.class, name="organization"), @JsonSubTypes.Type(value=CourseSection.class, name="courseSection"), @JsonSubTypes.Type(value=SoftwareApplication.class, name="softwareApplication"), @JsonSubTypes.Type(value=Reading.class, name="reading"), @JsonSubTypes.Type(value=Assessment.class, name="assessment"), @JsonSubTypes.Type(value=AssessmentItem.class, name="assessmentItem"), @JsonSubTypes.Type(value=AssignableDigitalResource.class, name="assignableDigitalResource"), @JsonSubTypes.Type(value=VideoObject.class, name="videoObject"), @JsonSubTypes.Type(value=AudioObject.class, name="audioObject"), @JsonSubTypes.Type(value=ImageObject.class, name="imageObject"), @JsonSubTypes.Type(value=MediaLocation.class, name="mediaLocation"), @JsonSubTypes.Type(value=BookmarkAnnotation.class, name="bookmarkAnnotation"), @JsonSubTypes.Type(value=HighlightAnnotation.class, name="highlightAnnotation"), @JsonSubTypes.Type(value=SharedAnnotation.class, name="sharedAnnotation"), @JsonSubTypes.Type(value=TagAnnotation.class, name="tagAnnotation"), @JsonSubTypes.Type(value=EpubVolume.class, name="ePubVolume"), @JsonSubTypes.Type(value=EpubPart.class, name="ePubPart"), @JsonSubTypes.Type(value=EpubChapter.class, name="ePubChapter"), @JsonSubTypes.Type(value=EpubSubChapter.class, name="ePubSubChapter"), @JsonSubTypes.Type(value=Frame.class, name="frame"), @JsonSubTypes.Type(value=LearningObjective.class, name="learningObjective")})
@JsonPropertyOrder(value={"@id", "@type", "name", "dateModified"})
public abstract class Entity {
    @Reference
    @JsonProperty(value="@id")
    protected String id;
    @JsonProperty(value="@type")
    protected String type;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="description")
    protected String description;
    @JsonProperty(value="properties")
    protected Map<String, Object> properties;
    @JsonProperty(value="extensions")
    protected Map<String, String> extensions;
    @JsonProperty(value="dateCreated")
    protected long dateCreated;
    @JsonProperty(value="dateModified")
    protected long dateModified;

    public Entity() {
        this.type = null;
        this.properties = null;
        this.name = null;
        this.description = null;
        this.id = null;
        this.dateModified = 0L;
    }

    protected Entity(Builder<?> builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.properties = builder.properties;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getDateModified() {
        return this.dateModified;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setDateModified(long dateModified) {
        this.dateModified = dateModified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(long dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String type;
        protected String name;
        protected String description;
        protected Map<String, Object> properties;
        protected Map<String, String> extensions;
        protected long dateCreated;
        protected long dateModified;

        protected abstract T self();

        public Builder() {
            this.type(Type.ENTITY.uri());
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T properties(Map<String, Object> properties) {
            this.properties = properties;
            return this.self();
        }

        public T extensions(Map<String, String> extensions) {
            this.extensions = extensions;
            return this.self();
        }

        public T dateCreated(long dateCreated) {
            this.dateCreated = dateCreated;
            return this.self();
        }

        public T dateModified(long dateModified) {
            this.dateModified = dateModified;
            return this.self();
        }
    }

    public static enum Type {
        AGENT("http://purl.imsglobal.org/caliper/v1/Agent"),
        ATTEMPT("http://purl.imsglobal.org/caliper/v1/Attempt"),
        DIGITAL_RESOURCE("http://purl.imsglobal.org/caliper/v1/DigitalResource"),
        ENTITY("http://purl.imsglobal.org/caliper/v1/Entity"),
        GENERATED("http://purl.imsglobal.org/caliper/v1/Generated"),
        LEARNING_OBJECTIVE("http://purl.imsglobal.org/caliper/v1/LearningObjective"),
        LIS_PERSON("http://purl.imsglobal.org/caliper/v1/lis/Person"),
        LIS_ORGANIZATION("http://purl.imsglobal.org/caliper/v1/lis/Organization"),
        RESULT("http://purl.imsglobal.org/caliper/v1/Result"),
        SOFTWARE_APPLICATION("http://purl.imsglobal.org/caliper/v1/SoftwareApplication"),
        TARGET("http://purl.imsglobal.org/caliper/v1/Target"),
        VIEW("http://purl.imsglobal.org/caliper/v1/View"),
        SESSION("http://purl.imsglobal.org/caliper/v1/Session");

        private final String uri;

        private Type(String uri) {
            this.uri = uri;
        }

        public String uri() {
            return this.uri;
        }
    }
}

