/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin.template;

import com.google.common.base.Preconditions;
import java.util.EnumMap;

public enum FilterType {
    INTELLIVIEW_FILTER("intelliviewfilter"),
    ROLE_FILTER("rolefilter"),
    USER_FILTER("userfilter");

    private String name;
    private static EnumMap<FilterType, String> filterEMap;

    private FilterType(String name) {
        this.name = name;
    }

    private String getName() {
        return this.name;
    }

    public static FilterType getFilterType(String filter) {
        Preconditions.checkNotNull((Object)filter);
        for (FilterType filterType : filterEMap.keySet()) {
            if (!filterType.getName().equalsIgnoreCase(filter)) continue;
            return filterType;
        }
        return null;
    }

    public static String getName(FilterType filterType) {
        return filterEMap.get((Object)filterType);
    }

    static {
        if (null == filterEMap) {
            filterEMap = new EnumMap(FilterType.class);
        }
        filterEMap.clear();
        for (FilterType filter : FilterType.values()) {
            filterEMap.put(filter, filter.getName());
        }
    }
}

