/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin.spec;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellify.api.admin.spec.CategorizeSpec;
import com.intellify.api.admin.spec.JoinSpec;
import com.intellify.api.admin.spec.ProcessingSpec;
import java.util.List;

public class PipelineSpec {
    private String primaryStream;
    private List<ProcessingSpec> processingSpecs = Lists.newArrayList();

    @JsonIgnore
    public String getPrimaryStreamName() {
        if (!Strings.isNullOrEmpty((String)this.getPrimaryStream())) {
            return this.getPrimaryStream();
        }
        JoinSpec joinSpec = this.getJoinSpec();
        if (joinSpec != null) {
            return joinSpec.getPrimaryStream().getStreamName();
        }
        CategorizeSpec categorizeSpec = this.getCategorizeSpec();
        if (categorizeSpec != null) {
            return categorizeSpec.getPrimaryStream();
        }
        return null;
    }

    public String getPrimaryStream() {
        return this.primaryStream;
    }

    public void setPrimaryStream(String primaryStream) {
        this.primaryStream = primaryStream;
    }

    public List<ProcessingSpec> getProcessingSpecs() {
        return this.processingSpecs;
    }

    public void setProcessingSpecs(List<ProcessingSpec> processingSpecs) {
        this.processingSpecs = processingSpecs;
    }

    @JsonIgnore
    public JoinSpec getJoinSpec() {
        JoinSpec joinSpec = null;
        if (this.getProcessingSpecs().size() == 1 && this.getProcessingSpecs().get(0).getClass().equals(JoinSpec.class)) {
            joinSpec = (JoinSpec)this.getProcessingSpecs().get(0);
        }
        return joinSpec;
    }

    @JsonIgnore
    public CategorizeSpec getCategorizeSpec() {
        CategorizeSpec categorizeSpec = null;
        if (this.getProcessingSpecs().size() == 1 && this.getProcessingSpecs().get(0).getClass().equals(CategorizeSpec.class)) {
            categorizeSpec = (CategorizeSpec)this.getProcessingSpecs().get(0);
        }
        return categorizeSpec;
    }

    public boolean equals(Object obj) {
        PipelineSpec objToCompare = (PipelineSpec)obj;
        PipelineSpec thisObj = this;
        boolean equals = true;
        if (!thisObj.getPrimaryStream().equals(objToCompare.getPrimaryStream())) {
            equals = false;
        }
        int index = 0;
        for (ProcessingSpec processingSpec : thisObj.getProcessingSpecs()) {
            if (!processingSpec.equals(objToCompare.getProcessingSpecs().get(index))) {
                equals = false;
            }
            ++index;
        }
        return equals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PipelineSpec [primaryStream=").append(this.primaryStream).append(", processingSpecs=").append(this.processingSpecs).append("]");
        return builder.toString();
    }
}

