/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import com.intellify.api.Entity;
import com.intellify.api.admin.template.Filter;
import com.intellify.api.security.Permission;
import java.util.List;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IntelliView
extends Entity {
    private boolean active = false;
    @Indexed
    private String parentDataCollectionId;
    @JsonIgnore
    private String sharedSecret;
    private String url;
    private String indexAlias;
    private String templateId;
    @DBRef
    private List<Filter> filters = Lists.newArrayList();
    private String customStyleSheet;
    @DBRef
    private List<Permission> permissions = Lists.newArrayList();
    private boolean timeRangeFilter;
    private boolean showFilters;
    private boolean quickLinksActive = true;
    private boolean menuBarEnabled;
    private boolean embedMode = true;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getParentDataCollectionId() {
        return this.parentDataCollectionId;
    }

    public void setParentDataCollectionId(String parentDataCollectionId) {
        this.parentDataCollectionId = parentDataCollectionId;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIndexAlias() {
        return this.indexAlias;
    }

    public void setIndexAlias(String indexAlias) {
        this.indexAlias = indexAlias;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getCustomStyleSheet() {
        return this.customStyleSheet;
    }

    public void setCustomStyleSheet(String customStyleSheet) {
        this.customStyleSheet = customStyleSheet;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean isTimeRangeFilter() {
        return this.timeRangeFilter;
    }

    public void setTimeRangeFilter(boolean timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
    }

    public boolean isShowFilters() {
        return this.showFilters;
    }

    public void setShowFilters(boolean showFilters) {
        this.showFilters = showFilters;
    }

    public boolean isQuickLinksActive() {
        return this.quickLinksActive;
    }

    public void setQuickLinksActive(boolean quickLinksActive) {
        this.quickLinksActive = quickLinksActive;
    }

    public boolean isMenuBarEnabled() {
        return this.menuBarEnabled;
    }

    public boolean isEmbedMode() {
        return this.embedMode;
    }

    public void setEmbedMode(boolean embedMode) {
        this.embedMode = embedMode;
    }

    public void setMenuBarEnabled(boolean menuBarEnabled) {
        this.menuBarEnabled = menuBarEnabled;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        if (equal) {
            IntelliView other = (IntelliView)obj;
            if (!this.getName().equalsIgnoreCase(other.getName())) {
                equal = false;
            }
            if (!this.getParentDataCollectionId().equalsIgnoreCase(other.getParentDataCollectionId())) {
                equal = false;
            }
            if (this.getSharedSecret() != null && other.getSharedSecret() != null && !this.getSharedSecret().equalsIgnoreCase(other.getSharedSecret())) {
                equal = false;
            }
            if (!this.getTemplateId().equalsIgnoreCase(other.getTemplateId())) {
                equal = false;
            }
            return equal;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntelliView [ uuid=").append(this.getUuid()).append(", name=").append(this.getName()).append(", active=").append(this.active).append(", parentDataCollectionId=").append(this.parentDataCollectionId).append(", sharedSecret=").append(this.sharedSecret).append(", url=").append(this.url).append(", indexAlias=").append(this.indexAlias).append(", templateId=").append(this.templateId).append(", filters=").append(this.filters).append(", customStyleSheet").append(this.customStyleSheet).append(", permissions=").append(this.permissions).append(", timeRangeFilter=").append(this.timeRangeFilter).append(", showFilters=").append(this.showFilters).append(", quickLinksActive=").append(this.quickLinksActive).append(", menuBarEnabled=").append(this.menuBarEnabled).append("]");
        return builder.toString();
    }
}

