/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.intellify.api.Entity;
import com.intellify.api.admin.ContextUpdateStrategy;
import com.intellify.api.admin.IntelliStreamJobSpec;
import com.intellify.api.admin.StreamTaskSpec;
import java.util.List;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class IntelliStream
extends Entity {
    @JsonIgnore
    public static final String RAW = "raw";
    @JsonIgnore
    public static final String COMPUTED = "computed";
    @JsonIgnore
    public static final String DYNAMIC = "dynamic";
    private String type = "computed";
    private boolean active = false;
    @Indexed
    private String parentDataCollectionId;
    private String indexAlias;
    private String currentIndex;
    private double lastIndexBuildTimeSecs = 0.0;
    private ContextUpdateStrategy contextUpdateStrategy = ContextUpdateStrategy.ALWAYS_REBUILD_WHEN_NEEDED;
    private boolean jobRequired = false;
    private IntelliStreamJobSpec intellistreamJobSpec;
    private boolean streamTaskRequired = false;
    private StreamTaskSpec streamTaskSpec;
    private String searchJSON;
    private String cronExpression;
    private List<String> courseIds = Lists.newArrayList();
    private String sharedSecret;
    private String url;
    public static final String CHAINED_STREAM_JOB_DATA_MAP_LIST = "chainedStreamJobDataMapList";
    private boolean hasChainedStreams = false;
    private List<String> chainedStreamUuids = Lists.newArrayList();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParentDataCollectionId() {
        return this.parentDataCollectionId;
    }

    public void setParentDataCollectionId(String parentDataCollectionId) {
        this.parentDataCollectionId = parentDataCollectionId;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public List<String> getCourseIds() {
        return this.courseIds;
    }

    public void setCourseIds(List<String> courseIds) {
        this.courseIds = courseIds;
    }

    public void addCourseId(String courseId) {
        this.courseIds.add(courseId);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isJobRequired() {
        return this.jobRequired;
    }

    public void setJobRequired(boolean jobRequired) {
        this.jobRequired = jobRequired;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIndexAlias() {
        return this.indexAlias;
    }

    public void setIndexAlias(String indexAlias) {
        this.indexAlias = indexAlias;
    }

    public String getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(String currentIndex) {
        this.currentIndex = currentIndex;
    }

    public double getLastIndexBuildTimeSecs() {
        return this.lastIndexBuildTimeSecs;
    }

    public void setLastIndexBuildTimeSecs(double lastIndexBuildTimeSecs) {
        this.lastIndexBuildTimeSecs = lastIndexBuildTimeSecs;
    }

    public ContextUpdateStrategy getContextUpdateStrategy() {
        return this.contextUpdateStrategy;
    }

    public void setContextUpdateStrategy(ContextUpdateStrategy contextUpdateStrategy) {
        this.contextUpdateStrategy = contextUpdateStrategy;
    }

    public IntelliStreamJobSpec getIntellistreamJobSpec() {
        return this.intellistreamJobSpec;
    }

    public void setIntellistreamJobSpec(IntelliStreamJobSpec intellistreamJobSpec) {
        this.intellistreamJobSpec = intellistreamJobSpec;
    }

    public boolean isStreamTaskRequired() {
        return this.streamTaskRequired;
    }

    public void setStreamTaskRequired(boolean streamTaskRequired) {
        this.streamTaskRequired = streamTaskRequired;
    }

    public StreamTaskSpec getStreamTaskSpec() {
        return this.streamTaskSpec;
    }

    public void setStreamTaskSpec(StreamTaskSpec streamTaskSpec) {
        this.streamTaskSpec = streamTaskSpec;
    }

    public String getSearchJSON() {
        return this.searchJSON;
    }

    public void setSearchJSON(String searchJSON) {
        this.searchJSON = searchJSON;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntelliStream [type=").append(this.type).append(", active=").append(this.active).append(", parentDataCollectionId=").append(this.parentDataCollectionId).append(", indexAlias=").append(this.indexAlias).append(", currentIndex=").append(this.currentIndex).append(", lastIndexBuildTimeSecs=").append(this.lastIndexBuildTimeSecs).append(", contextUpdateStrategy=").append((Object)this.contextUpdateStrategy).append(", jobRequired=").append(this.jobRequired).append(", intellistreamJobSpec=").append(this.intellistreamJobSpec).append(", streamTaskRequired=").append(this.streamTaskRequired).append(", streamTaskSpec=").append(this.streamTaskSpec).append(", searchJSON=").append(this.searchJSON).append(", cronExpression=").append(this.cronExpression).append(", courseIds=").append(this.courseIds).append(", sharedSecret=").append(this.sharedSecret).append(", url=").append(this.url).append("]");
        return builder.toString();
    }

    public boolean isHasChainedStreams() {
        return this.hasChainedStreams;
    }

    public void setHasChainedStreams(boolean hasChainedStreams) {
        this.hasChainedStreams = hasChainedStreams;
    }

    public List<String> getChainedStreamUuids() {
        return this.chainedStreamUuids;
    }

    public void setChainedStreamUuids(List<String> chainedStreamUuids) {
        this.chainedStreamUuids = chainedStreamUuids;
    }
}

