/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api.admin;

import com.google.common.collect.Lists;
import com.intellify.api.Entity;
import com.intellify.api.admin.ApiKey;
import com.intellify.api.admin.DataSource;
import com.intellify.api.admin.IntelliStream;
import com.intellify.api.admin.IntelliView;
import java.util.List;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DataCollection
extends Entity {
    private boolean active = false;
    @Indexed
    private String parentOrgId;
    @DBRef
    private List<ApiKey> apiKeys = Lists.newArrayList();
    @DBRef
    private List<DataSource> dataSources = Lists.newArrayList();
    @DBRef
    private List<IntelliStream> intelliStreams = Lists.newArrayList();
    @DBRef
    private List<IntelliView> intelliViews = Lists.newArrayList();

    public DataCollection() {
    }

    public DataCollection(String parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgId() {
        return this.parentOrgId;
    }

    public void setParentOrgId(String parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public void setApiKeys(List<ApiKey> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public void addApiKey(ApiKey apiKey) {
        this.apiKeys.add(apiKey);
    }

    public void removeApiKey(ApiKey apiKey) {
        this.apiKeys.remove(apiKey);
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    public List<IntelliStream> getIntelliStreams() {
        return this.intelliStreams;
    }

    public void setIntelliStreams(List<IntelliStream> intelliStreams) {
        this.intelliStreams = intelliStreams;
    }

    public void addIntelliStream(IntelliStream intelliStream) {
        this.intelliStreams.add(intelliStream);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<IntelliView> getIntelliViews() {
        return this.intelliViews;
    }

    public void setIntelliViews(List<IntelliView> intelliViews) {
        this.intelliViews = intelliViews;
    }

    public void addIntelliView(IntelliView intelliView) {
        this.intelliViews.add(intelliView);
    }
}

