/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api;

import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Entity {
    @Id
    @Indexed
    private String uuid;
    private String version;
    @Indexed
    private long lastUpdatedTime = 0L;
    private long creationTime = 0L;
    private String name;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getCreationTime() {
        if (this.uuid != null && ObjectId.isValid((String)this.uuid)) {
            ObjectId mongoId = new ObjectId(this.uuid);
            return mongoId.getTime();
        }
        return 0L;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Entity [uuid = " + this.getUuid() + ", version = " + this.getVersion() + ", name = " + this.getName() + "]";
    }

    public boolean equals(Object obj) {
        Entity other = (Entity)obj;
        if (other == null) {
            return false;
        }
        return this.getUuid().equalsIgnoreCase(other.getUuid());
    }
}

