/*
 * Decompiled with CFR 0.152.
 */
package com.intellify.api;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellify.api.Entity;
import com.intellify.api.SecureObject;
import com.intellify.api.security.AccessControlEntry;
import com.intellify.api.security.Permission;
import com.intellify.api.security.User;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="uuid")
public class Collection
extends Entity
implements SecureObject {
    @NotEmpty
    private String title;
    private String description;
    private Set<String> tagList = new LinkedHashSet<String>();
    @DBRef
    private User owner;
    private List<AccessControlEntry> aceList = Lists.newArrayList();
    private String thumbnail;
    private String icon;
    private List<Collection> children = Lists.newArrayList();
    private String ancestor;

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Collection> getChildren() {
        return this.children;
    }

    public void setChildren(List<Collection> children) {
        this.children = children;
    }

    public void addChild(Collection child) {
        this.children.add(child);
    }

    public void removeChild(Collection child) {
        this.children.remove(child);
    }

    public String getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(String ancestor) {
        this.ancestor = ancestor;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(User user) {
        this.owner = user;
    }

    public Set<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(Set<String> tagList) {
        this.tagList = tagList;
    }

    @Override
    public List<AccessControlEntry> getACEList() {
        return ImmutableList.copyOf(this.aceList);
    }

    public void setACEList(List<AccessControlEntry> aceList) {
        this.aceList = aceList;
    }

    @Override
    public void addACE(AccessControlEntry ace) {
        this.aceList.add(ace);
    }

    @Override
    public void updateACE(AccessControlEntry current, AccessControlEntry updated) {
        if (this.aceList.remove(current)) {
            this.aceList.add(updated);
        }
    }

    @Override
    public void removeACE(AccessControlEntry toRemove) {
        this.aceList.remove(toRemove);
    }

    @Override
    public Permission addPermission(Permission permission) {
        return null;
    }

    @Override
    public Permission updatePermission(Permission current, Permission updated) {
        return null;
    }

    @Override
    public void removePermission(Permission toRemove) {
    }

    @Override
    public void removeAllPermissions() {
    }
}

