/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.LogEvent;
import com.influxdb.client.domain.RunLinks;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Run {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TASK_I_D = "taskID";
    @SerializedName(value="taskID")
    private String taskID;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_SCHEDULED_FOR = "scheduledFor";
    @SerializedName(value="scheduledFor")
    private OffsetDateTime scheduledFor;
    public static final String SERIALIZED_NAME_LOG = "log";
    @SerializedName(value="log")
    private List<LogEvent> log = new ArrayList<LogEvent>();
    public static final String SERIALIZED_NAME_STARTED_AT = "startedAt";
    @SerializedName(value="startedAt")
    private OffsetDateTime startedAt;
    public static final String SERIALIZED_NAME_FINISHED_AT = "finishedAt";
    @SerializedName(value="finishedAt")
    private OffsetDateTime finishedAt;
    public static final String SERIALIZED_NAME_REQUESTED_AT = "requestedAt";
    @SerializedName(value="requestedAt")
    private OffsetDateTime requestedAt;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private RunLinks links = null;

    public String getId() {
        return this.id;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public Run scheduledFor(OffsetDateTime scheduledFor) {
        this.scheduledFor = scheduledFor;
        return this;
    }

    public OffsetDateTime getScheduledFor() {
        return this.scheduledFor;
    }

    public void setScheduledFor(OffsetDateTime scheduledFor) {
        this.scheduledFor = scheduledFor;
    }

    public List<LogEvent> getLog() {
        return this.log;
    }

    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public OffsetDateTime getRequestedAt() {
        return this.requestedAt;
    }

    public Run links(RunLinks links) {
        this.links = links;
        return this;
    }

    public RunLinks getLinks() {
        return this.links;
    }

    public void setLinks(RunLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Run run = (Run)o;
        return Objects.equals(this.id, run.id) && Objects.equals(this.taskID, run.taskID) && Objects.equals((Object)this.status, (Object)run.status) && Objects.equals(this.scheduledFor, run.scheduledFor) && Objects.equals(this.log, run.log) && Objects.equals(this.startedAt, run.startedAt) && Objects.equals(this.finishedAt, run.finishedAt) && Objects.equals(this.requestedAt, run.requestedAt) && Objects.equals(this.links, run.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.taskID, this.status, this.scheduledFor, this.log, this.startedAt, this.finishedAt, this.requestedAt, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Run {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    taskID: ").append(this.toIndentedString(this.taskID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    scheduledFor: ").append(this.toIndentedString(this.scheduledFor)).append("\n");
        sb.append("    log: ").append(this.toIndentedString(this.log)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    requestedAt: ").append(this.toIndentedString(this.requestedAt)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        SCHEDULED("scheduled"),
        STARTED("started"),
        FAILED("failed"),
        SUCCESS("success"),
        CANCELED("canceled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

