/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.google.gson.Gson;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.JSON;
import com.influxdb.client.domain.Dialect;
import com.influxdb.client.domain.HealthCheck;
import com.influxdb.client.internal.AuthenticateInterceptor;
import com.influxdb.client.internal.GzipInterceptor;
import com.influxdb.client.service.HealthService;
import com.influxdb.client.service.PingService;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.internal.UserAgentInterceptor;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public abstract class AbstractInfluxDBClient
extends AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractInfluxDBClient.class.getName());
    public static final Dialect DEFAULT_DIALECT = new Dialect().header(true).delimiter(",").commentPrefix("#").addAnnotationsItem(Dialect.AnnotationsEnum.DATATYPE).addAnnotationsItem(Dialect.AnnotationsEnum.GROUP).addAnnotationsItem(Dialect.AnnotationsEnum.DEFAULT);
    public final HealthService healthService;
    public final PingService pingService;
    protected final Retrofit retrofit;
    protected final InfluxDBClientOptions options;
    protected final HttpLoggingInterceptor loggingInterceptor;
    protected final GzipInterceptor gzipInterceptor;
    private final AuthenticateInterceptor authenticateInterceptor;
    private final OkHttpClient okHttpClient;
    protected final Collection<AutoCloseable> autoCloseables = new CopyOnWriteArrayList<AutoCloseable>();

    public AbstractInfluxDBClient(@Nonnull InfluxDBClientOptions options, @Nonnull String clientType) {
        this(options, clientType, Collections.singletonList(RxJava3CallAdapterFactory.createSynchronous()));
    }

    public AbstractInfluxDBClient(@Nonnull InfluxDBClientOptions options, @Nonnull String clientType, @Nonnull Collection<CallAdapter.Factory> factories) {
        Arguments.checkNotNull((Object)options, (String)"InfluxDBClientOptions");
        Arguments.checkNotNull(factories, (String)"factories");
        Arguments.checkNonEmpty((String)clientType, (String)"clientType");
        this.options = options;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.loggingInterceptor.redactHeader("Authorization");
        this.setLogLevel(this.loggingInterceptor, options.getLogLevel());
        this.authenticateInterceptor = new AuthenticateInterceptor(options);
        this.gzipInterceptor = new GzipInterceptor();
        String customClientType = options.getClientType() != null ? options.getClientType() : clientType;
        this.okHttpClient = options.getOkHttpClient().addInterceptor((Interceptor)new UserAgentInterceptor(customClientType)).addInterceptor((Interceptor)this.authenticateInterceptor).addInterceptor((Interceptor)this.loggingInterceptor).addInterceptor((Interceptor)this.gzipInterceptor).build();
        this.authenticateInterceptor.initToken(this.okHttpClient);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(options.getUrl()).client(this.okHttpClient).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new JSON().getGson()));
        for (CallAdapter.Factory factory : factories) {
            retrofitBuilder.addCallAdapterFactory(factory);
        }
        this.retrofit = retrofitBuilder.build();
        this.healthService = (HealthService)this.retrofit.create(HealthService.class);
        this.pingService = (PingService)this.retrofit.create(PingService.class);
    }

    public void close() {
        this.autoCloseables.stream().filter(Objects::nonNull).forEach(resource -> {
            try {
                resource.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, String.format("Exception was thrown while closing: %s", resource), e);
            }
        });
        this.autoCloseables.clear();
        try {
            this.authenticateInterceptor.signout();
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "The signout exception", e);
        }
        this.okHttpClient.connectionPool().evictAll();
        this.okHttpClient.dispatcher().executorService().shutdown();
    }

    @Nonnull
    protected HealthCheck health(Call<HealthCheck> healthCall) {
        Arguments.checkNotNull(healthCall, (String)"health call");
        try {
            return (HealthCheck)this.execute(healthCall);
        }
        catch (InfluxException e) {
            HealthCheck health = new HealthCheck();
            health.setName("influxdb");
            health.setStatus(HealthCheck.StatusEnum.FAIL);
            health.setMessage(e.getMessage());
            return health;
        }
    }
}

