/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.scanners;

import java.util.List;

class AbstractScanner {
    final List<Class<?>> classes;

    AbstractScanner(List<Class<?>> classes) {
        this.classes = classes;
    }

    boolean isDomainClass(Class<?> clazz) {
        return this.classes.contains(clazz);
    }

    boolean isDomainClass(String name) {
        for (Class<?> clazz : this.classes) {
            if (!clazz.getName().equals(this.stripClassHeader(name))) continue;
            return true;
        }
        return false;
    }

    String stripClassHeader(String fullToString) {
        if (fullToString.startsWith("class ")) {
            return this.convertFromAsmToComplete(fullToString.substring(6));
        }
        if (fullToString.startsWith("interface ")) {
            return this.convertFromAsmToComplete(fullToString.substring(10));
        }
        return this.convertFromAsmToComplete(fullToString);
    }

    String convertFromAsmToComplete(String original) {
        return original.replace('/', '.');
    }
}

