/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm;

import com.iluwatar.urm.DomainMapper;
import com.iluwatar.urm.presenters.Presenter;
import com.iluwatar.urm.presenters.Representation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainMapperCli {
    private static final Logger log = LoggerFactory.getLogger(DomainMapperCli.class);
    DomainMapper domainMapper;

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        new DomainMapperCli().run(args);
    }

    public void run(String[] args) throws ClassNotFoundException, IOException {
        BasicParser parser = new BasicParser();
        Options options = new Options();
        options.addOption("f", "file", true, "write to file");
        options.addOption("p", "package", true, "comma separated list of domain packages");
        OptionBuilder.withArgName("package");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create('p'));
        options.addOption("i", "ignore", true, "comma separated list of ignored types");
        OptionBuilder.withArgName("ignore");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create('i'));
        options.addOption("s", "presenter", true, "presenter to be used");
        OptionBuilder.withArgName("presenter");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create('s'));
        try {
            CommandLine line = parser.parse(options, args);
            String[] packages = line.getOptionValue("p").split(",[ ]*");
            log.debug("Scanning domain for packages:");
            for (String packageName : packages) {
                log.debug(packageName);
            }
            String[] ignores = null;
            if (line.hasOption("i") && (ignores = line.getOptionValue("i").split(",[ ]*")) != null) {
                log.debug("Ignored types:");
                for (String ignore : ignores) {
                    log.debug(ignore);
                }
            }
            Presenter presenter = Presenter.parse(line.getOptionValue("s"));
            this.domainMapper = DomainMapper.create(presenter, Arrays.asList(packages), ignores == null ? new ArrayList() : Arrays.asList(ignores));
            Representation representation = this.domainMapper.describeDomain();
            if (line.hasOption('f')) {
                String filename = line.getOptionValue('f');
                Path parent = Paths.get(filename, new String[0]).getParent();
                if (parent != null) {
                    Files.createDirectories(Paths.get(filename, new String[0]).getParent(), new FileAttribute[0]);
                }
                Files.write(Paths.get(filename, new String[0]), representation.getContent().getBytes(), new OpenOption[0]);
                log.info("Wrote to file " + filename);
            } else {
                log.info(representation.getContent());
            }
        }
        catch (ParseException exp) {
            log.info(exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar urm-core.jar", options);
        }
    }
}

