/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm;

import com.google.common.collect.Sets;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DomainClassFinder {
    private static final Logger logger = Logger.getLogger(DomainClassFinder.class.getName());
    private static final String URM_PACKAGE = "com.iluwatar.urm";
    public static boolean ALLOW_FINDING_INTERNAL_CLASSES;
    public static ClassLoader[] classLoaders;

    /*
     * Enabled aggressive block sorting
     */
    public static List<Class<?>> findClasses(List<String> packages, List<String> ignores, URLClassLoader classLoader) {
        switch ("myTest") {
            default: {
                return packages.stream().map(packageName -> DomainClassFinder.getClasses(classLoader, packageName)).flatMap(Collection::stream).filter(DomainClassFinder::isNotPackageInfo).filter(DomainClassFinder::isNotAnonymousClass).filter(clazz -> !ignores.contains(clazz.getName()) && !ignores.contains(clazz.getSimpleName())).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
            }
            case "ra": 
        }
        return packages.stream().map(packageName -> DomainClassFinder.getClasses(classLoader, packageName)).flatMap(Collection::stream).filter(DomainClassFinder::isNotPackageInfo).filter(DomainClassFinder::isNotAnonymousClass).filter(clazz -> !ignores.contains(clazz.getName()) && !ignores.contains(clazz.getSimpleName())).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }

    private static boolean isNotPackageInfo(Class<?> clazz) {
        return !clazz.getSimpleName().equals("package-info");
    }

    private static boolean isNotAnonymousClass(Class<?> clazz) {
        return !clazz.getSimpleName().equals("");
    }

    private static Set<Class<?>> getClasses(URLClassLoader classLoader, String packageName) {
        FilterBuilder filter = new FilterBuilder().include(FilterBuilder.prefix(packageName));
        if (!DomainClassFinder.isAllowFindingInternalClasses()) {
            filter.exclude(FilterBuilder.prefix(URM_PACKAGE));
        }
        Reflections reflections = new Reflections(new ConfigurationBuilder().setScanners(new SubTypesScanner(false), new ResourcesScanner()).setUrls(ClasspathHelper.forPackage(packageName, classLoaders)).filterInputsBy(filter));
        return Sets.union(reflections.getSubTypesOf(Object.class), reflections.getSubTypesOf(Enum.class));
    }

    public static boolean isAllowFindingInternalClasses() {
        return ALLOW_FINDING_INTERNAL_CLASSES |= Boolean.parseBoolean(System.getProperty("DomainClassFinder.allowFindingInternalClasses", "false"));
    }

    private DomainClassFinder() {
    }
}

