/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.ClientConstants;
import com.ibm.ws.jmx.connector.client.rest.internal.Connector;
import com.ibm.ws.jmx.connector.client.rest.internal.DynamicURL;
import com.ibm.ws.jmx.connector.client.rest.internal.FileTransferClient;
import com.ibm.ws.jmx.connector.client.rest.internal.NotificationRegistry;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.datatypes.CreateMBean;
import com.ibm.ws.jmx.connector.datatypes.Invocation;
import com.ibm.ws.jmx.connector.datatypes.JMXServerInfo;
import com.ibm.ws.jmx.connector.datatypes.MBeanInfoWrapper;
import com.ibm.ws.jmx.connector.datatypes.MBeanQuery;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.ClosedByInterruptException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

class RESTMBeanServerConnection
implements MBeanServerConnection {
    private static final Logger logger = Logger.getLogger(RESTMBeanServerConnection.class.getName());
    protected static final String CLIENT_VERSION = "IBM_JMX_REST_client_v5";
    private static final long NANOS_IN_A_MILLISECOND = 1000000L;
    private final AtomicBoolean isRecoveringConnection = new AtomicBoolean();
    private ServerPollingThread serverPollingThread;
    protected final Connector connector;
    private volatile boolean disconnected = false;
    protected int serverVersion;
    private final DynamicURL rootURL;
    private DynamicURL mbeansURL;
    private DynamicURL createMBeanURL;
    private DynamicURL instanceOfURL;
    private DynamicURL mbeanCountURL;
    private DynamicURL defaultDomainURL;
    private DynamicURL domainsURL;
    private DynamicURL notificationsURL;
    private DynamicURL fileTransferURL;
    private final ConcurrentMap<ObjectName, DynamicURL> mbeanInfoURLMap;
    private final ConcurrentMap<ObjectName, DynamicURL> mbeanAttributesURLMap;
    private final ConcurrentMap<ObjectName, Map<String, DynamicURL>> mbeanAttributeURLsMap;
    private final ConcurrentMap<ObjectName, Map<String, DynamicURL>> mbeanOperationURLsMap;
    private final FileTransferClient fileTransferClient;
    private NotificationRegistry notificationRegistry;
    protected final HostnameVerifier hostnameVerificationDisabler;
    protected Map<String, Object> mapRouting = null;

    RESTMBeanServerConnection(Connector connector) throws IOException {
        this.connector = connector;
        this.rootURL = new DynamicURL(connector, connector.getServiceURL().getURLPath());
        this.hostnameVerificationDisabler = connector.isHostnameVerificationDisabled() ? new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        } : null;
        this.findInitialEndpoint();
        try {
            this.loadJMXServerInfo();
        }
        catch (IOException e) {
            if (this.isConnected()) {
                this.loadJMXServerInfo();
            }
            throw e;
        }
        this.mbeanInfoURLMap = new ConcurrentHashMap<ObjectName, DynamicURL>();
        this.mbeanAttributesURLMap = new ConcurrentHashMap<ObjectName, DynamicURL>();
        this.mbeanAttributeURLsMap = new ConcurrentHashMap<ObjectName, Map<String, DynamicURL>>();
        this.mbeanOperationURLsMap = new ConcurrentHashMap<ObjectName, Map<String, DynamicURL>>();
        this.fileTransferClient = new FileTransferClient(this);
        if (connector.getServerFailoverInterval() >= 0) {
            this.setPollingMode(PollingMode.FAILOVER);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "constructor", "Initiated connector " + RESTClientMessagesUtil.getObjID(this) + " within connection: " + connector.getConnectionId());
        }
        if (connector.logFailovers()) {
            String connectMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.connect", connector.getCurrentEndpoint());
            logger.logp(Level.INFO, logger.getName(), "constructor", connectMsg);
        }
    }

    private NotificationRegistry getNotificationRegistry() throws IOException {
        if (this.notificationRegistry == null) {
            this.notificationRegistry = new NotificationRegistry(this);
        }
        return this.notificationRegistry;
    }

    protected void setPollingMode(PollingMode mode) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setPollingMode", "Entering setPollingMode with new mode " + mode.toString());
        }
        if (this.serverPollingThread != null) {
            this.serverPollingThread.changeMode(mode);
        } else {
            this.serverPollingThread = new ServerPollingThread(mode);
            this.serverPollingThread.start();
        }
    }

    protected void discardNotificationRegistry() {
        if (this.connector.getServerFailoverInterval() >= 0) {
            this.setPollingMode(PollingMode.FAILOVER);
        } else {
            this.closePollingThread();
        }
        this.notificationRegistry.close();
        this.notificationRegistry = null;
    }

    private void loadJMXServerInfo() throws IOException {
        String sourceMethod = "loadJMXServerInfo";
        this.checkConnection();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadJMXServerInfo", "Loading server info for endpoint: " + this.connector.getCurrentEndpoint());
        }
        URL rootURL = null;
        HttpsURLConnection connection = null;
        try {
            rootURL = this.getRootURL();
            connection = this.getConnection(rootURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("loadJMXServerInfo", io, rootURL);
        }
        JMXServerInfo jmx = null;
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce, true);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    jmx = converter.readJMX(connection.getInputStream());
                    break;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("loadJMXServerInfo", e, rootURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("loadJMXServerInfo", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException io = this.getResponseCodeErrorException("loadJMXServerInfo", responseCode, connection);
                this.recoverConnection(io, true);
                throw io;
            }
            default: {
                throw this.getResponseCodeErrorException("loadJMXServerInfo", responseCode, connection);
            }
        }
        this.serverVersion = jmx.version;
        this.mbeansURL = new DynamicURL(this.connector, jmx.mbeansURL);
        this.createMBeanURL = new DynamicURL(this.connector, jmx.createMBeanURL);
        this.instanceOfURL = new DynamicURL(this.connector, jmx.instanceOfURL);
        this.mbeanCountURL = new DynamicURL(this.connector, jmx.mbeanCountURL);
        this.defaultDomainURL = new DynamicURL(this.connector, jmx.defaultDomainURL);
        this.domainsURL = new DynamicURL(this.connector, jmx.domainsURL);
        this.notificationsURL = new DynamicURL(this.connector, jmx.notificationsURL);
        this.fileTransferURL = new DynamicURL(this.connector, jmx.fileTransferURL);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return this.createMBean(className, name, null, null, null, false, false);
        }
        catch (InstanceNotFoundException inf) {
            throw new IOException(inf);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.createMBean(className, name, loaderName, null, null, true, false);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return this.createMBean(className, name, null, params, signature, false, true);
        }
        catch (InstanceNotFoundException inf) {
            throw new IOException(inf);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.createMBean(className, name, loaderName, params, signature, true, true);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature, boolean useLoader, boolean useSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        String sourceMethod = "createMBean";
        this.checkConnection();
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.class.name.null", new Object[0])));
        }
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name)));
        }
        URL createURL = null;
        HttpsURLConnection connection = null;
        JSONConverter converter = JSONConverter.getConverter();
        try {
            createURL = this.getCreateMBeanURL();
            connection = this.getConnection(createURL, ClientConstants.HttpMethod.POST);
            CreateMBean createMBean = new CreateMBean();
            createMBean.className = className;
            createMBean.objectName = name;
            createMBean.loaderName = loaderName;
            createMBean.params = params;
            createMBean.signature = signature;
            createMBean.useLoader = useLoader;
            createMBean.useSignature = useSignature;
            OutputStream output = connection.getOutputStream();
            converter.writeCreateMBean(output, createMBean);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("createMBean", io, createURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                converter = JSONConverter.getConverter();
                try {
                    ObjectInstanceWrapper wrapper = converter.readObjectInstance(connection.getInputStream());
                    this.mbeanInfoURLMap.put(wrapper.objectInstance.getObjectName(), new DynamicURL(this.connector, wrapper.mbeanInfoURL));
                    ObjectInstance objectInstance = wrapper.objectInstance;
                    return objectInstance;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("createMBean", e, createURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("createMBean", connection);
                }
                catch (RuntimeOperationsException roe) {
                    throw roe;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (InstanceAlreadyExistsException iae) {
                    throw iae;
                }
                catch (MBeanRegistrationException mbr) {
                    throw mbr;
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (NotCompliantMBeanException ncm) {
                    throw ncm;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("createMBean", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("createMBean", responseCode, connection);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        String sourceMethod = "unregisterMBean";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        URL mbeanURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanURL = this.getMBeanURL(name);
            connection = this.getConnection(mbeanURL, ClientConstants.HttpMethod.DELETE);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("unregisterMBean", io, mbeanURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 204: {
                this.purgeMBeanURLs(name);
                return;
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("unregisterMBean", connection);
                }
                catch (MBeanRegistrationException mbr) {
                    throw mbr;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("unregisterMBean", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("unregisterMBean", responseCode, connection);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        Set results = this.queryMBeans(name, null, null, true);
        if (results.size() == 1) {
            return results.toArray(new ObjectInstance[1])[0];
        }
        throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
    }

    private Set queryMBeans(ObjectName name, QueryExp query, String className, boolean objectInstance) throws IOException {
        String sourceMethod = "queryMBeans";
        boolean usePOST = query != null;
        URL baseMBeansURL = null;
        URL mbeansURL = null;
        HttpsURLConnection connection = null;
        JSONConverter converter = JSONConverter.getConverter();
        try {
            baseMBeansURL = this.getMBeansURL();
            mbeansURL = usePOST ? baseMBeansURL : this.getMBeansURL(name, className);
            connection = this.getConnection(mbeansURL, usePOST ? ClientConstants.HttpMethod.POST : ClientConstants.HttpMethod.GET);
            if (usePOST) {
                MBeanQuery mbeanQuery = new MBeanQuery();
                mbeanQuery.objectName = name;
                mbeanQuery.queryExp = query;
                mbeanQuery.className = className;
                OutputStream output = connection.getOutputStream();
                converter.writeMBeanQuery(output, mbeanQuery);
                output.flush();
                output.close();
            }
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("queryMBeans", io, mbeansURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                converter = JSONConverter.getConverter();
                try {
                    ObjectInstanceWrapper[] wrappers = converter.readObjectInstances(connection.getInputStream());
                    HashSet<Serializable> mbeans = new HashSet<Serializable>(wrappers.length);
                    HashMap<ObjectName, String> tempMBeanInfoURLMap = new HashMap<ObjectName, String>(wrappers.length);
                    for (ObjectInstanceWrapper wrapper : wrappers) {
                        tempMBeanInfoURLMap.put(wrapper.objectInstance.getObjectName(), wrapper.mbeanInfoURL);
                        if (objectInstance) {
                            mbeans.add(wrapper.objectInstance);
                            continue;
                        }
                        mbeans.add(wrapper.objectInstance.getObjectName());
                    }
                    this.processMBeanInfoURLs(tempMBeanInfoURLMap, this.getMBeansURL().getPath(), name == null && query == null && className == null);
                    HashSet<Serializable> hashSet = mbeans;
                    return hashSet;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("queryMBeans", e, mbeansURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("queryMBeans", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException("jmx.rest.client.unexpected.server.throwable", t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException io = this.getResponseCodeErrorException("queryMBeans", responseCode, connection);
                this.recoverConnection(io);
                throw io;
            }
        }
        throw this.getResponseCodeErrorException("queryMBeans", responseCode, connection);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        this.checkConnection();
        return this.queryMBeans(name, query, null, true);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        this.checkConnection();
        return this.queryMBeans(name, query, null, false);
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            return false;
        }
        Set results = this.queryMBeans(name, null, null, true);
        return results.size() == 1;
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        String sourceMethod = "getMBeanCount";
        this.checkConnection();
        URL mbeanCountURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanCountURL = this.getMBeanCountURL();
            connection = this.getConnection(mbeanCountURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getMBeanCount", io, mbeanCountURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    Integer n = converter.readInt(connection.getInputStream());
                    return n;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getMBeanCount", e, mbeanCountURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getMBeanCount", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException io = this.getResponseCodeErrorException("getMBeanCount", responseCode, connection);
                this.recoverConnection(io);
                throw io;
            }
        }
        throw this.getResponseCodeErrorException("getMBeanCount", responseCode, connection);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        HttpsURLConnection connection;
        URL attributeURL;
        String sourceMethod = "getAttribute";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.name.null", new Object[0])));
        }
        try {
            attributeURL = this.getAttributeURL(name, attribute);
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("getAttribute", intro);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttribute", io);
        }
        try {
            connection = this.getConnection(attributeURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttribute", io, attributeURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    Object object = converter.readPOJO(connection.getInputStream());
                    return object;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getAttribute", e, attributeURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getAttribute", connection);
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (AttributeNotFoundException anf) {
                    throw anf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("getAttribute", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("getAttribute", responseCode, connection);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        HttpsURLConnection connection;
        URL attributesURL;
        String sourceMethod = "getAttributes";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.names.null", new Object[0])));
        }
        try {
            attributesURL = this.getAttributesURL(name, attributes);
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("getAttributes", intro);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttributes", io);
        }
        try {
            connection = this.getConnection(attributesURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttributes", io, attributesURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    AttributeList attributeList = converter.readAttributeList(connection.getInputStream());
                    return attributeList;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getAttributes", e, attributesURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getAttributes", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("getAttributes", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("getAttributes", responseCode, connection);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        HttpsURLConnection connection;
        URL attributeURL;
        String sourceMethod = "setAttribute";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.null", new Object[0])));
        }
        JSONConverter converter = JSONConverter.getConverter();
        try {
            attributeURL = this.getAttributeURL(name, attribute.getName());
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IntrospectionException intro) {
            this.getRequestErrorException("setAttribute", intro);
            throw new IOException(intro);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttribute", io);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        try {
            connection = this.getConnection(attributeURL, ClientConstants.HttpMethod.PUT);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttribute", io, attributeURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        try {
            OutputStream output = connection.getOutputStream();
            converter.writePOJO(output, attribute.getValue());
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttribute", io, attributeURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 204: {
                return;
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("setAttribute", connection);
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (AttributeNotFoundException anf) {
                    throw anf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (InvalidAttributeValueException iav) {
                    throw iav;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("setAttribute", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("setAttribute", responseCode, connection);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        HttpsURLConnection connection;
        URL attributesURL;
        String sourceMethod = "setAttributes";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.list.null", new Object[0])));
        }
        JSONConverter converter = JSONConverter.getConverter();
        try {
            attributesURL = this.getAttributesURL(name);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("setAttributes", intro);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttributes", io);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        try {
            connection = this.getConnection(attributesURL, ClientConstants.HttpMethod.POST);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttributes", io, attributesURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        try {
            OutputStream output = connection.getOutputStream();
            converter.writeAttributeList(output, attributes);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttributes", io, attributesURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                converter = JSONConverter.getConverter();
                try {
                    AttributeList ce = converter.readAttributeList(connection.getInputStream());
                    return ce;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("setAttributes", e, attributesURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("setAttributes", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("setAttributes", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("setAttributes", responseCode, connection);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String sourceMethod = "invoke";
        try {
            if ("RoutingContext".equals(name.getKeyProperty("name")) && "WebSphere".equals(name.getDomain())) {
                if ("assignServerContext".equals(operationName)) {
                    if (params.length == 3) {
                        this.mapRouting = new HashMap<String, Object>();
                        this.mapRouting.put("com.ibm.websphere.jmx.connector.rest.routing.hostName", params[0]);
                        this.mapRouting.put("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir", params[1]);
                        this.mapRouting.put("com.ibm.websphere.jmx.connector.rest.routing.serverName", params[2]);
                        return Boolean.TRUE;
                    }
                } else if ("assignHostContext".equals(operationName) && params.length == 1) {
                    this.mapRouting = new HashMap<String, Object>();
                    this.mapRouting.put("com.ibm.websphere.jmx.connector.rest.routing.hostName", params[0]);
                    return Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        this.checkConnection();
        if ("FileTransfer".equals(name.getKeyProperty("name")) && "WebSphere".equals(name.getDomain())) {
            return this.fileTransferClient.handleOperation(operationName, params);
        }
        URL invokeURL = null;
        HttpsURLConnection connection = null;
        JSONConverter converter = JSONConverter.getConverter();
        try {
            invokeURL = this.getOperationURL(name, operationName);
            connection = this.getConnection(invokeURL, ClientConstants.HttpMethod.POST);
            Invocation invocation = new Invocation();
            invocation.params = params;
            invocation.signature = signature;
            OutputStream output = connection.getOutputStream();
            converter.writeInvocation(output, invocation);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("invoke", intro, invokeURL);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("invoke", io, invokeURL);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                converter = JSONConverter.getConverter();
                try {
                    Object ce = converter.readPOJO(connection.getInputStream());
                    return ce;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("invoke", e, invokeURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("invoke", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("invoke", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        IOException e = this.getResponseCodeErrorException("invoke", responseCode, connection);
        throw e;
    }

    @Override
    public String getDefaultDomain() throws IOException {
        String sourceMethod = "getDefaultDomain";
        this.checkConnection();
        URL defaultDomainURL = null;
        HttpsURLConnection connection = null;
        try {
            defaultDomainURL = this.getDefaultDomainURL();
            connection = this.getConnection(defaultDomainURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getDefaultDomain", io, defaultDomainURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    String string = converter.readString(connection.getInputStream());
                    return string;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getDefaultDomain", e, defaultDomainURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getDefaultDomain", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException io = this.getResponseCodeErrorException("getDefaultDomain", responseCode, connection);
                this.recoverConnection(io);
                throw io;
            }
        }
        throw this.getResponseCodeErrorException("getDefaultDomain", responseCode, connection);
    }

    @Override
    public String[] getDomains() throws IOException {
        String sourceMethod = "getDomains";
        this.checkConnection();
        URL domainsURL = null;
        HttpsURLConnection connection = null;
        try {
            domainsURL = this.getDomainsURL();
            connection = this.getConnection(domainsURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getDomains", io, domainsURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    String[] stringArray = converter.readStringArray(connection.getInputStream());
                    return stringArray;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getDomains", e, domainsURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getDomains", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException io = this.getResponseCodeErrorException("getDomains", responseCode, connection);
                this.recoverConnection(io);
                throw io;
            }
        }
        throw this.getResponseCodeErrorException("getDomains", responseCode, connection);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.getNotificationRegistry().removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        String sourceMethod = "getMBeanInfo";
        this.checkConnection();
        URL mbeanURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanURL = this.getMBeanURL(name);
            connection = this.getConnection(mbeanURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getMBeanInfo", io, mbeanURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    ConcurrentHashMap<String, DynamicURL> operationURLsMap;
                    boolean updateOperations;
                    boolean updateAttributes;
                    MBeanInfoWrapper wrapper = converter.readMBeanInfo(connection.getInputStream());
                    this.mbeanAttributesURLMap.put(name, new DynamicURL(this.connector, wrapper.attributesURL));
                    ConcurrentHashMap<String, DynamicURL> attributeURLsMap = (ConcurrentHashMap<String, DynamicURL>)this.mbeanAttributeURLsMap.get(name);
                    boolean bl = updateAttributes = attributeURLsMap != null;
                    if (!updateAttributes) {
                        attributeURLsMap = new ConcurrentHashMap<String, DynamicURL>();
                    }
                    this.processAttributeOrOperationURLs(attributeURLsMap, wrapper.attributeURLs, updateAttributes);
                    if (!updateAttributes) {
                        this.mbeanAttributeURLsMap.putIfAbsent(name, attributeURLsMap);
                    }
                    boolean bl2 = updateOperations = (operationURLsMap = (ConcurrentHashMap<String, DynamicURL>)this.mbeanOperationURLsMap.get(name)) != null;
                    if (!updateOperations) {
                        operationURLsMap = new ConcurrentHashMap<String, DynamicURL>();
                    }
                    this.processAttributeOrOperationURLs(operationURLsMap, wrapper.operationURLs, updateOperations);
                    if (!updateOperations) {
                        this.mbeanOperationURLsMap.putIfAbsent(name, operationURLsMap);
                    }
                    MBeanInfo mBeanInfo = wrapper.mbeanInfo;
                    return mBeanInfo;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getMBeanInfo", e, mbeanURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getMBeanInfo", connection);
                }
                catch (IntrospectionException ie) {
                    throw ie;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("getMBeanInfo", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("getMBeanInfo", responseCode, connection);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        String sourceMethod = "isInstanceOf";
        this.checkConnection();
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        URL instanceOfURL = null;
        HttpsURLConnection connection = null;
        try {
            instanceOfURL = this.getInstanceOfURL(name, className);
            connection = this.getConnection(instanceOfURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("isInstanceOf", io, instanceOfURL);
        }
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException ce) {
            this.recoverConnection(ce);
            throw ce;
        }
        switch (responseCode) {
            case 200: {
                JSONConverter converter = JSONConverter.getConverter();
                try {
                    boolean bl = converter.readBoolean(connection.getInputStream());
                    return bl;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("isInstanceOf", e, instanceOfURL);
                }
                finally {
                    JSONConverter.returnConverter(converter);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("isInstanceOf", connection);
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(cnf);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            case 404: 
            case 410: {
                IOException ioe = this.getResponseCodeErrorException("isInstanceOf", responseCode, connection);
                this.recoverConnection(ioe);
                throw ioe;
            }
        }
        throw this.getResponseCodeErrorException("isInstanceOf", responseCode, connection);
    }

    protected URL getRootURL() throws IOException {
        return this.rootURL.getURL();
    }

    private URL getDefaultDomainURL() throws IOException {
        return this.defaultDomainURL.getURL();
    }

    private URL getDomainsURL() throws IOException {
        return this.domainsURL.getURL();
    }

    URL getNotificationsURL() throws IOException {
        return this.notificationsURL.getURL();
    }

    URL getFileTransferURL() throws IOException {
        return this.fileTransferURL.getURL();
    }

    private URL getMBeanCountURL() throws IOException {
        return this.mbeanCountURL.getURL();
    }

    private URL getAttributeURL(ObjectName name, String attributeName) throws IOException, AttributeNotFoundException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.mbeanAttributeURLsMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanAttributeURLsMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        if (!((Map)this.mbeanAttributeURLsMap.get(name)).containsKey(attributeName)) {
            throw new AttributeNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.not.found", name, attributeName));
        }
        return ((DynamicURL)((Map)this.mbeanAttributeURLsMap.get(name)).get(attributeName)).getURL();
    }

    private URL getAttributesURL(ObjectName name) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.mbeanAttributesURLMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanAttributesURLMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        return ((DynamicURL)this.mbeanAttributesURLMap.get(name)).getURL();
    }

    private URL getAttributesURL(ObjectName name, String[] attributes) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (attributes != null && attributes.length > 0) {
            StringBuilder sb = new StringBuilder();
            int length = attributes.length;
            for (int i = 0; i < length - 1; ++i) {
                sb.append("attribute=");
                sb.append(URLEncoder.encode(attributes[i], "UTF-8"));
                sb.append("&");
            }
            sb.append("attribute=");
            sb.append(URLEncoder.encode(attributes[length - 1], "UTF-8"));
            String attributeList = sb.toString();
            return new URL(this.getAttributesURL(name).toString() + "?" + attributeList);
        }
        return this.getAttributesURL(name);
    }

    private URL getOperationURL(ObjectName name, String operationName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        if (!this.mbeanOperationURLsMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanOperationURLsMap.containsKey(name) || !((Map)this.mbeanOperationURLsMap.get(name)).containsKey(operationName)) {
            throw new ReflectionException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.operation.not.found", name, operationName)));
        }
        return ((DynamicURL)((Map)this.mbeanOperationURLsMap.get(name)).get(operationName)).getURL();
    }

    private URL getCreateMBeanURL() throws IOException {
        return this.createMBeanURL.getURL();
    }

    private URL getInstanceOfURL() throws IOException {
        return this.instanceOfURL.getURL();
    }

    private URL getInstanceOfURL(ObjectName name, String className) throws IOException {
        return new URL(this.getInstanceOfURL().toString() + "?" + (name != null ? "objectName=" + URLEncoder.encode(name.getCanonicalName(), "UTF-8") + "&" : "") + (className != null ? "className=" + URLEncoder.encode(className, "UTF-8") : ""));
    }

    private URL getMBeansURL() throws IOException {
        return this.mbeansURL.getURL();
    }

    private URL getMBeansURL(ObjectName name, String instanceOf) throws IOException {
        return new URL(this.getMBeansURL().toString() + "?" + (name != null ? "objectName=" + URLEncoder.encode(name.getCanonicalName(), "UTF-8") + "&" : "") + (instanceOf != null ? "className=" + URLEncoder.encode(instanceOf, "UTF-8") : ""));
    }

    private URL getMBeanURL(ObjectName name) throws IOException, InstanceNotFoundException {
        if (!this.mbeanInfoURLMap.containsKey(name)) {
            this.queryMBeans(name, null, null, true);
        }
        if (!this.mbeanInfoURLMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        return ((DynamicURL)this.mbeanInfoURLMap.get(name)).getURL();
    }

    private void purgeMBeanURLs(ObjectName name) {
        this.mbeanInfoURLMap.remove(name);
        this.mbeanAttributesURLMap.remove(name);
        this.mbeanAttributeURLsMap.remove(name);
        this.mbeanOperationURLsMap.remove(name);
    }

    private void processAttributeOrOperationURLs(Map<String, DynamicURL> destination, Map<String, String> source, boolean update) {
        if (update) {
            HashSet<String> missingKeys = new HashSet<String>(destination.keySet());
            missingKeys.removeAll(source.keySet());
            for (String missingKey : missingKeys) {
                destination.remove(missingKey);
            }
        }
        for (Map.Entry<String, String> e : source.entrySet()) {
            if (update && destination.containsKey(e.getKey()) && destination.get(e.getKey()).getName().equals(e.getValue())) continue;
            destination.put(e.getKey(), new DynamicURL(this.connector, e.getValue()));
        }
    }

    private void processMBeanInfoURLs(Map<ObjectName, String> source, String parentPath, boolean complete) {
        if (complete) {
            HashSet missingKeys = new HashSet(this.mbeanInfoURLMap.keySet());
            missingKeys.removeAll(source.keySet());
            for (ObjectName missingKey : missingKeys) {
                this.purgeMBeanURLs(missingKey);
            }
        }
        for (Map.Entry<ObjectName, String> e : source.entrySet()) {
            if (this.mbeanInfoURLMap.containsKey(e.getKey()) && ((DynamicURL)this.mbeanInfoURLMap.get(e.getKey())).getName().equals(e.getValue())) continue;
            if (this.mbeanInfoURLMap.containsKey(e.getKey())) {
                this.purgeMBeanURLs(e.getKey());
            }
            this.mbeanInfoURLMap.put(e.getKey(), new DynamicURL(this.connector, e.getValue()));
        }
    }

    synchronized void logSevereException(String sourceMethod, String errorMsg, Exception e) {
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
    }

    synchronized IOException getRequestErrorException(String sourceMethod, Exception e, URL url) {
        String urlString = url != null ? url.toString() : "null";
        String connectionId = this.connector.getConnectionId();
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.request.error", urlString, connectionId);
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    synchronized IOException getRequestErrorException(String sourceMethod, Exception e) {
        String connectionId = this.connector.getConnectionId();
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.request.error", null, connectionId);
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    synchronized IOException getResponseErrorException(String sourceMethod, Exception e, URL url) {
        String urlString = url != null ? url.toString() : "null";
        String connectionId = this.connector.getConnectionId();
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.response.error", urlString, connectionId);
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    synchronized IOException getResponseCodeErrorException(String methodName, int responseCode, HttpsURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.response.code.error", responseCode, responseMessage, connection.getURL().toString(), this.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        return new IOException(errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Throwable getServerThrowable(String methodName, HttpsURLConnection connection) {
        Throwable t;
        JSONConverter converter = JSONConverter.getConverter();
        try {
            t = converter.readThrowable(connection.getErrorStream());
        }
        catch (ClassNotFoundException cnf) {
            t = new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.throwable.exception", new Object[0]), cnf);
        }
        catch (Exception e) {
            t = this.getResponseErrorException(methodName, e, connection.getURL());
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        return t;
    }

    IOException getBadCredentialsException(int responseCode, HttpsURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.bad.user.credentials", responseCode, responseMessage));
    }

    void close() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "close", "Close called for " + RESTClientMessagesUtil.getObjID(this) + " within connection: " + this.connector.getConnectionId());
        }
        this.closePollingThread();
        if (this.notificationRegistry != null) {
            this.notificationRegistry.close();
        }
        if (this.connector.logFailovers()) {
            String disconnectMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.disconnect", this.connector.getCurrentEndpoint());
            logger.logp(Level.INFO, logger.getName(), "close", disconnectMsg);
        }
        this.disconnect();
    }

    private void closePollingThread() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "closePollingThread", "Closing thread: " + this.serverPollingThread.getCustomId());
        }
        if (this.serverPollingThread != null) {
            this.serverPollingThread.interrupt();
            try {
                this.serverPollingThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.serverPollingThread = null;
            }
        }
    }

    synchronized void connectionFailed(Throwable t) {
        if (!this.isConnected()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "connectionFailed", "Connection failed: " + RESTClientMessagesUtil.getObjID(this));
        }
        this.disconnect();
        if (this.notificationRegistry != null) {
            this.notificationRegistry.close();
        }
        this.connector.connectionFailed(t);
    }

    private void disconnect() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "disconnect", "Disconnect called for " + RESTClientMessagesUtil.getObjID(this));
        }
        this.disconnected = true;
    }

    boolean isConnected() {
        return !this.disconnected;
    }

    private void checkConnection() throws IOException {
        if (!this.isConnected()) {
            throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.not.connected", new Object[0]));
        }
    }

    HttpsURLConnection getBasicConnection(URL url, ClientConstants.HttpMethod method) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(method == ClientConstants.HttpMethod.POST || method == ClientConstants.HttpMethod.PUT);
        connection.setUseCaches(false);
        connection.setRequestMethod(method.toString());
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setReadTimeout(this.connector.getReadTimeout());
        if (this.connector.getBasicAuthHeader() != null) {
            connection.setRequestProperty("Authorization", this.connector.getBasicAuthHeader());
        }
        if (this.connector.isHostnameVerificationDisabled()) {
            connection.setHostnameVerifier(this.hostnameVerificationDisabler);
        }
        if (this.connector.getCustomSSLSocketFactory() != null) {
            connection.setSSLSocketFactory(this.connector.getCustomSSLSocketFactory());
        }
        connection.setRequestProperty("User-Agent", CLIENT_VERSION);
        return connection;
    }

    Connector getConnector() {
        return this.connector;
    }

    protected boolean isServerLevelRouting() {
        return this.mapRouting != null && this.mapRouting.size() == 3 && this.isValueSet((String)this.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.hostName")) && this.isValueSet((String)this.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.serverName")) && this.isValueSet((String)this.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir"));
    }

    protected boolean isHostLevelRouting() {
        return this.mapRouting != null && this.mapRouting.size() == 1 && this.isValueSet((String)this.mapRouting.get("com.ibm.websphere.jmx.connector.rest.routing.hostName"));
    }

    public boolean isValueSet(String s) {
        return s != null && !s.trim().isEmpty();
    }

    HttpsURLConnection getConnection(URL originalUrl, ClientConstants.HttpMethod method) throws IOException {
        return this.getConnection(originalUrl, method, false);
    }

    HttpsURLConnection getConnection(URL originalUrl, ClientConstants.HttpMethod method, boolean ignoreProxy) throws IOException {
        return this.getConnection(originalUrl, method, ignoreProxy, null);
    }

    HttpsURLConnection getConnection(URL originalUrl, ClientConstants.HttpMethod method, boolean ignoreProxy, Map<String, Object> routingInfo) throws IOException {
        boolean inProxyMode;
        URL url = originalUrl;
        String sURL = originalUrl.toString();
        boolean bl = inProxyMode = !ignoreProxy && this.isServerLevelRouting();
        if (inProxyMode && sURL.indexOf("IBMJMXConnectorREST/router") < 0) {
            final String asURL = this.serverVersion >= 4 ? sURL : sURL.replaceFirst("IBMJMXConnectorREST", "IBMJMXConnectorREST/router");
            try {
                url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws MalformedURLException {
                        return new URL(asURL);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpsURLConnection connection = this.getBasicConnection(url, method);
        if (inProxyMode || routingInfo != null) {
            if (routingInfo == null) {
                routingInfo = this.mapRouting;
            }
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.hostName", (String)routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.hostName"));
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir", (String)routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir"));
            connection.addRequestProperty("com.ibm.websphere.jmx.connector.rest.routing.serverName", (String)routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverName"));
            if (inProxyMode) {
                connection.addRequestProperty("com.ibm.ws.jmx.connector.client.rest.readTimeout", String.valueOf(this.connector.getReadTimeout()));
            }
        }
        return connection;
    }

    protected void recoverConnection(Throwable t) {
        this.recoverConnection(t, false);
    }

    /*
     * Exception decompiling
     */
    protected void recoverConnection(Throwable t, boolean skipCurrentEndpoint) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void findInitialEndpoint() throws IOException {
        List<String> endpoints = this.connector.getEndpointList();
        if (endpoints != null) {
            if (endpoints.size() == 1) {
                this.connector.setCurrentEndpoint(endpoints.get(0));
                return;
            }
            for (String endpoint : endpoints) {
                if (!this.testConnection(endpoint)) continue;
                this.connector.setCurrentEndpoint(endpoint);
                return;
            }
        }
        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.no.endpoints", new Object[0]));
    }

    private URL getSimpleURL(String endpoint) throws MalformedURLException {
        String[] endpointSegments = RESTMBeanServerConnection.splitEndpoint(endpoint);
        return new URL("https", endpointSegments[0], Integer.valueOf(endpointSegments[1]), "/IBMJMXConnectorREST/mbeanServer");
    }

    private boolean testConnection(String endpoint) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "testConnection", "Testing connection for endpoint " + endpoint);
        }
        URL testURL = null;
        try {
            testURL = this.getSimpleURL(endpoint);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "testConnection", "Failed while making URL:" + e.getMessage());
            }
            return false;
        }
        try {
            HttpsURLConnection connection = this.getBasicConnection(testURL, ClientConstants.HttpMethod.GET);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "testConnection", "Successful!");
                }
                return true;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "testConnection", "Failed connection attempt with response code:" + responseCode);
            }
            return false;
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "testConnection", "Failed connection attempt with exception:" + e.getMessage());
            }
            return false;
        }
    }

    public static String[] splitEndpoint(String endpoint) {
        int lastColon = endpoint.lastIndexOf(":");
        String[] splitString = new String[]{endpoint.substring(0, lastColon), endpoint.substring(lastColon + 1, endpoint.length())};
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "splitEndpoint", "Split " + endpoint + " into " + splitString[0] + " and " + splitString[1]);
        }
        return splitString;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String oldValue = System.getProperty("sun.net.http.retryPost");
                if (oldValue != null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.logp(Level.INFO, logger.getName(), "StaticBlock[1]", "Value of retry post was already set: " + oldValue);
                    }
                } else {
                    System.setProperty("sun.net.http.retryPost", "false");
                }
                return null;
            }
        });
    }

    public static enum PollingMode {
        FAILOVER,
        NOTIFICATION;

    }

    public class ServerPollingThread
    extends Thread {
        private PollingMode mode = null;
        private volatile long waitInterval = 0L;
        private final Object waitFlag = new PollingWaitFlag();

        private ServerPollingThread(PollingMode mode) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "ServerPollingThread", "Created thread: " + this.getCustomId());
            }
            this.setDaemon(true);
            this.setName("JMX-REST-Client-Polling");
            this.changeMode(mode);
        }

        public String getCustomId() {
            return "ThreadID[" + this.getId() + "], from [" + RESTMBeanServerConnection.this.connector.getConnectionId() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void changeMode(PollingMode newMode) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "changeMode", "Changing mode from " + (Object)((Object)this.mode) + " to " + (Object)((Object)newMode) + " in thread: " + this.getCustomId());
            }
            if (this.mode != newMode) {
                Object object = this.waitFlag;
                synchronized (object) {
                    this.mode = newMode;
                    this.waitInterval = this.mode == PollingMode.NOTIFICATION ? (long)RESTMBeanServerConnection.this.connector.getNotificationFetchInterval() : (long)RESTMBeanServerConnection.this.connector.getServerFailoverInterval();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "changeMode", "waitInterval is now: " + this.waitInterval);
                    }
                    this.waitFlag.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String sourceMethod = "run";
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "run", "Running thread: " + this.getCustomId());
            }
            JSONConverter converter = JSONConverter.getConverter();
            block25: while (!ServerPollingThread.interrupted() && RESTMBeanServerConnection.this.isConnected()) {
                PollingMode currentMode;
                HttpsURLConnection connection;
                URL targetURL;
                block35: {
                    targetURL = null;
                    connection = null;
                    currentMode = this.mode;
                    try {
                        if (currentMode == PollingMode.NOTIFICATION) {
                            targetURL = RESTMBeanServerConnection.this.notificationRegistry.getInboxURL();
                            connection = RESTMBeanServerConnection.this.getConnection(targetURL, ClientConstants.HttpMethod.GET, true);
                            connection.setReadTimeout(RESTMBeanServerConnection.this.getConnector().getNotificationReadTimeout());
                        } else {
                            targetURL = RESTMBeanServerConnection.this.getSimpleURL(RESTMBeanServerConnection.this.connector.getCurrentEndpoint());
                            connection = RESTMBeanServerConnection.this.getConnection(targetURL, ClientConstants.HttpMethod.GET, true);
                        }
                        if (!logger.isLoggable(Level.FINEST)) break block35;
                        logger.logp(Level.FINEST, logger.getName(), "run", "Making a call to URL [" + targetURL + "] inside thread: " + this.getCustomId());
                    }
                    catch (IOException io) {
                        logger.logp(Level.FINE, logger.getName(), "run", io.getMessage(), io);
                        RESTMBeanServerConnection.this.connectionFailed(RESTMBeanServerConnection.this.getRequestErrorException("run", io, targetURL));
                        break;
                    }
                }
                try {
                    int responseCode;
                    block36: {
                        responseCode = 0;
                        try {
                            responseCode = connection.getResponseCode();
                            if (!logger.isLoggable(Level.FINER)) break block36;
                            logger.logp(Level.FINER, logger.getName(), "run", "Response code: " + responseCode);
                        }
                        catch (ConnectException ce) {
                            logger.logp(Level.FINE, logger.getName(), "run", ce.getMessage(), ce);
                            RESTMBeanServerConnection.this.recoverConnection(ce);
                            continue;
                        }
                        catch (IOException io) {
                            logger.logp(Level.FINE, logger.getName(), "run", io.getMessage(), io);
                            continue;
                        }
                    }
                    switch (responseCode) {
                        case 200: {
                            try {
                                NotificationRecord[] notificationRecords;
                                if (currentMode != PollingMode.NOTIFICATION || (notificationRecords = converter.readNotificationRecords(connection.getInputStream())) == null || !RESTMBeanServerConnection.this.isConnected()) break;
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.logp(Level.FINEST, logger.getName(), "run", "Received " + notificationRecords.length + " notifications");
                                }
                                for (NotificationRecord nr : notificationRecords) {
                                    Notification n = nr.getNotification();
                                    Object source = n.getSource();
                                    if (!(source instanceof ObjectName)) {
                                        logger.logp(Level.FINE, logger.getName(), "run", "Notification source was not ObjectName: " + source);
                                        RESTMBeanServerConnection.this.getConnector().notificationLost(n);
                                        continue;
                                    }
                                    NotificationRegistry.ClientNotificationRegistration localRegistration = RESTMBeanServerConnection.this.notificationRegistry.getRegistrationMap().get(nr.getNotificationTargetInformation());
                                    if (localRegistration != null) {
                                        try {
                                            localRegistration.handleNotification(n);
                                        }
                                        catch (Exception e) {
                                            RESTMBeanServerConnection.this.logSevereException("run", RESTClientMessagesUtil.getMessage("jmx.rest.client.notification.lost", new Object[0]), e);
                                            RESTMBeanServerConnection.this.getConnector().notificationLost(n);
                                        }
                                        continue;
                                    }
                                    RESTMBeanServerConnection.this.getConnector().notificationLost(n);
                                }
                                if (notificationRecords.length > 0) {
                                    continue block25;
                                }
                                break;
                            }
                            catch (ClassNotFoundException cnf) {
                                throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                            }
                            catch (Exception e) {
                                logger.logp(Level.FINE, logger.getName(), "run", e.getMessage(), e);
                                throw RESTMBeanServerConnection.this.getResponseErrorException("run", e, targetURL);
                            }
                        }
                        case 404: {
                            IOException ex = new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.url.not.found", new Object[0]));
                            logger.logp(Level.FINE, logger.getName(), "run", ex.getMessage());
                            RESTMBeanServerConnection.this.recoverConnection(ex);
                            continue block25;
                        }
                        case 410: {
                            Throwable t = RESTMBeanServerConnection.this.getServerThrowable("run", connection);
                            logger.logp(Level.FINE, logger.getName(), "run", t.getMessage());
                            RESTMBeanServerConnection.this.recoverConnection(t);
                            continue block25;
                        }
                        case 400: 
                        case 500: {
                            Throwable ie = RESTMBeanServerConnection.this.getServerThrowable("run", connection);
                            logger.logp(Level.FINE, "run", logger.getName(), ie.getMessage());
                            throw ie;
                        }
                        case 401: 
                        case 403: {
                            throw RESTMBeanServerConnection.this.getBadCredentialsException(responseCode, connection);
                        }
                        default: {
                            throw RESTMBeanServerConnection.this.getResponseCodeErrorException("run", responseCode, connection);
                        }
                    }
                }
                catch (ClosedByInterruptException ie) {
                    logger.logp(Level.FINE, logger.getName(), "run", ie.getMessage());
                    break;
                }
                catch (Throwable t) {
                    logger.logp(Level.FINE, logger.getName(), "run", t.getMessage());
                    RESTMBeanServerConnection.this.recoverConnection(t);
                    continue;
                }
                if (this.waitInterval <= 0L) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, logger.getName(), "run", "Calling sleep for " + this.waitInterval + " milliseconds on thread: " + this.getCustomId());
                }
                try {
                    Object t = this.waitFlag;
                    synchronized (t) {
                        this.waitFlag.wait(this.waitInterval);
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, logger.getName(), "run", "Interrupted sleep in thread: " + this.getCustomId());
                }
            }
            JSONConverter.returnConverter(converter);
        }

        private class PollingWaitFlag {
            private PollingWaitFlag() {
            }
        }
    }
}

