/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.AbstractHttpResponseException;
import com.ibm.ws.security.common.http.HttpResponseNot200Exception;
import com.ibm.ws.security.common.http.HttpResponseNullOrEmptyException;
import com.ibm.ws.security.common.http.SocialLoginWrapperException;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpUtils {
    public static final TraceComponent tc = Tr.register(HttpUtils.class, null, null);
    static final long serialVersionUID = 79432011522465843L;

    public HttpPost createHttpPostMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpPost postMethod = new HttpPost(url);
        this.addHeadersToHttpObject((HttpRequestBase)postMethod, commonHeaders);
        return postMethod;
    }

    public HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        this.addHeadersToHttpObject((HttpRequestBase)getMethod, commonHeaders);
        return getMethod;
    }

    void addHeadersToHttpObject(HttpRequestBase requestObject, List<NameValuePair> headers) {
        if (headers == null) {
            return;
        }
        for (NameValuePair nvp : headers) {
            requestObject.addHeader(nvp.getName(), nvp.getValue());
        }
    }

    public void debugPostToEndPoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, List<NameValuePair> commonHeaders) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)tc, (String)("postToEndpoint: url: " + url + " headers: " + commonHeaders + " params: ***** baUsername: " + baUsername + " baPassword: " + (baPassword != null ? "****" : null) + " accessToken: " + accessToken), (Object[])new Object[0]);
        StringBuffer sb = new StringBuffer();
        sb.append("curl -k -v");
        if (commonHeaders != null) {
            for (NameValuePair nvp : commonHeaders) {
                sb.append(" -H \"");
                sb.append(nvp.getName());
                sb.append(": ");
                sb.append(nvp.getValue());
                sb.append("\"");
            }
        }
        if (params != null && params.size() > 0) {
            sb.append(" -d \"");
            Iterator<NameValuePair> i = params.iterator();
            while (i.hasNext()) {
                NameValuePair nvp;
                nvp = i.next();
                String name = nvp.getName();
                sb.append(name);
                sb.append("=");
                if (name.equals("client_secret")) {
                    sb.append("*****");
                } else {
                    sb.append(nvp.getValue());
                }
                if (!i.hasNext()) continue;
                sb.append("&");
            }
            sb.append("\"");
        }
        if (baUsername != null && baPassword != null) {
            sb.append(" -u \"");
            sb.append(baUsername);
            sb.append(":");
            sb.append("****");
            sb.append("\"");
        }
        if (accessToken != null) {
            sb.append(" -H \"Authorization: bearer ");
            sb.append(accessToken);
            sb.append("\"");
        }
        sb.append(" ");
        sb.append(url);
        Tr.debug((TraceComponent)tc, (String)("CURL Command: " + sb.toString()), (Object[])new Object[0]);
    }

    public HttpClient createHttpClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification) {
        return this.createHttpClient(sslSocketFactory, url, isHostnameVerification, false);
    }

    public HttpClient createHttpClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) {
        return this.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient createHttpClientWithCookieSpec(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections, BasicCredentialsProvider credentialsProvider) {
        boolean isSecure;
        CloseableHttpClient client = null;
        boolean bl = isSecure = url != null && url.startsWith("https:");
        if (isSecure) {
            ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
            try {
                SSLConnectionSocketFactory connectionFactory = null;
                connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new NoopHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new DefaultHostnameVerifier());
                RequestConfig rcfg = RequestConfig.custom().setCookieSpec("standard").build();
                client = this.createBuilder(useSystemPropertiesForHttpClientConnections).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).setDefaultRequestConfig(rcfg).build();
            }
            finally {
                ThreadContextHelper.setClassLoader((ClassLoader)origCL);
            }
        } else {
            HttpClientBuilder clientBuilder = this.createBuilder(useSystemPropertiesForHttpClientConnections);
            if (credentialsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            client = clientBuilder.build();
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient createHttpClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections, BasicCredentialsProvider credentialsProvider) {
        boolean isSecure;
        CloseableHttpClient client = null;
        boolean bl = isSecure = url != null && url.startsWith("https:");
        if (isSecure) {
            ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
            try {
                SSLConnectionSocketFactory connectionFactory = null;
                connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new NoopHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new DefaultHostnameVerifier());
                HttpClientBuilder clientBuilder = this.createBuilder(useSystemPropertiesForHttpClientConnections).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
                if (credentialsProvider != null) {
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                client = clientBuilder.build();
            }
            finally {
                ThreadContextHelper.setClassLoader((ClassLoader)origCL);
            }
        } else {
            HttpClientBuilder clientBuilder = this.createBuilder(useSystemPropertiesForHttpClientConnections);
            if (credentialsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            client = clientBuilder.build();
        }
        return client;
    }

    HttpClientBuilder createBuilder(boolean useSystemProperties) {
        return useSystemProperties ? HttpClientBuilder.create().useSystemProperties() : HttpClientBuilder.create();
    }

    public BasicCredentialsProvider createCredentialsProvider(String username, @Sensitive String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    public String getHttpJsonRequest(HttpClient client, String url) throws SocialLoginWrapperException, IOException {
        if (client != null) {
            return this.getHttpJsonRequestAsString(client, url);
        }
        return null;
    }

    public String getHttpJsonRequest(SSLSocketFactory sslSocketFactory, String url, boolean hostNameVerificationEnabled, boolean useSystemProperties) throws SocialLoginWrapperException, IOException {
        HttpClient client = this.createHttpClient(sslSocketFactory, url, hostNameVerificationEnabled, useSystemProperties);
        if (client != null) {
            return this.getHttpJsonRequestAsString(client, url);
        }
        return null;
    }

    String getHttpJsonRequestAsString(HttpClient httpClient, String url) throws SocialLoginWrapperException, IOException {
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        return this.getHttpRequestAsString(httpClient, url, headers);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={AbstractHttpResponseException.class})
    String getHttpRequestAsString(HttpClient httpClient, String url, List<NameValuePair> headers) throws SocialLoginWrapperException, IOException {
        HttpGet request = this.createHttpGetMethod(url, headers);
        HttpResponse result = null;
        ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
        try {
            result = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.http.HttpUtils", (String)"267", (Object)this, (Object[])new Object[]{httpClient, url, headers});
            String errMsg = "IOException: " + e.getMessage() + " " + e.getCause();
            String nlsMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages", (String)"OIDC_CLIENT_DISCOVERY_ERROR", (Object[])new Object[]{url, errMsg}, (String)"Error processing discovery request");
            throw new SocialLoginWrapperException(url, 0, nlsMessage, (Exception)e);
        }
        finally {
            ThreadContextHelper.setClassLoader((ClassLoader)origCL);
        }
        try {
            return this.extractResponseAsString(result, url);
        }
        catch (AbstractHttpResponseException e) {
            throw this.getSocialLoginWrapperException(e);
        }
    }

    String extractResponseAsString(HttpResponse result, String url) throws IOException, AbstractHttpResponseException {
        StatusLine statusLine = result.getStatusLine();
        int iStatusCode = statusLine.getStatusCode();
        String response = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        if (iStatusCode == 200) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{response});
            }
            if (response == null || response.isEmpty()) {
                throw new HttpResponseNullOrEmptyException(url, iStatusCode, "empty or null response");
            }
            return response;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + response), (Object[])new Object[0]);
        }
        throw new HttpResponseNot200Exception(url, iStatusCode, response);
    }

    private SocialLoginWrapperException getSocialLoginWrapperException(AbstractHttpResponseException e) {
        String defaultMessage = "Error processing discovery request";
        String nlsMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages", (String)"OIDC_CLIENT_DISC_RESPONSE_ERROR", (Object[])new Object[]{e.getUrl(), e.getStatusCode(), e.getNlsMessage()}, (String)defaultMessage);
        return new SocialLoginWrapperException(e.getUrl(), e.getStatusCode(), nlsMessage, e);
    }

    /*
     * WARNING - void declaration
     */
    public String invokeUrl(RequestMethod requestMethod, String url, SSLSocketFactory sslSocketFactory) throws Exception {
        try {
            HttpURLConnection connection = this.createConnection(requestMethod, url, sslSocketFactory);
            String response = this.readConnectionResponse(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new Exception("Received unexpected " + responseCode + " response from " + (Object)((Object)requestMethod) + " request sent to " + url + ".");
            }
            return response;
        }
        catch (IOException connection) {
            void e;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.security.common.http.HttpUtils", (String)"321", (Object)this, (Object[])new Object[]{requestMethod, url, sslSocketFactory});
            throw new Exception("Connection to URL [" + url + "] failed. " + e, (Throwable)e);
        }
    }

    public HttpURLConnection createConnection(RequestMethod requestMethod, String url, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpURLConnection connection = null;
        connection = url != null && url.toLowerCase().startsWith("https") ? this.getHttpsConnection(requestMethod, url, sslSocketFactory) : this.getHttpConnection(requestMethod, url);
        return connection;
    }

    public String readConnectionResponse(HttpURLConnection con) throws IOException {
        String line;
        InputStream responseStream = this.getResponseStream(con);
        if (responseStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(responseStream, "UTF-8"));
        String response = "";
        while ((line = in.readLine()) != null) {
            response = response + line;
        }
        in.close();
        return response;
    }

    HttpsURLConnection getHttpsConnection(RequestMethod requestMethod, String apiUrl, SSLSocketFactory sslSocketFactory) throws IOException {
        URL url = new URL(apiUrl);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(sslSocketFactory);
        connection.setRequestMethod(requestMethod.toString());
        return connection;
    }

    HttpURLConnection getHttpConnection(RequestMethod requestMethod, String apiUrl) throws IOException {
        URL url = new URL(apiUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMethod.toString());
        return connection;
    }

    InputStream getResponseStream(HttpURLConnection con) throws IOException {
        InputStream responseStream = null;
        int responseCode = con.getResponseCode();
        if (responseCode < 400) {
            responseStream = con.getInputStream();
            if (responseStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to obtain response stream from InputStream. Getting ErrorStream instead", (Object[])new Object[0]);
                }
                responseStream = con.getErrorStream();
            }
        } else {
            responseStream = con.getErrorStream();
            if (responseStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to obtain response stream from ErrorStream. Getting InputStream instead", (Object[])new Object[0]);
                }
                responseStream = con.getInputStream();
            }
        }
        return responseStream;
    }

    public HttpURLConnection setHeaders(HttpURLConnection con, @Sensitive Map<String, String> headers) {
        if (headers == null) {
            return con;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return con;
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

