/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.session.IBMSessionListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.AbstractSessionData;
import com.ibm.ws.session.EOSSessionStorer;
import com.ibm.ws.session.ManualSessionStorer;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionAffinityManager;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionContextRegistry;
import com.ibm.ws.session.SessionData;
import com.ibm.ws.session.SessionInvalidator;
import com.ibm.ws.session.SessionInvalidatorWithThreadPool;
import com.ibm.ws.session.SessionManager;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionManagerRegistry;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.TBWSessionStorer;
import com.ibm.ws.session.WasHttpAppSessionObserver;
import com.ibm.ws.session.WasHttpSessionAdapter;
import com.ibm.ws.session.WasHttpSessionObserver;
import com.ibm.ws.session.http.HttpSessionAttributeObserver;
import com.ibm.ws.session.store.memory.MemoryStore;
import com.ibm.ws.session.store.memory.SessionSimpleHashMap;
import com.ibm.ws.session.utils.IDGeneratorImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.session.IGenericSessionManager;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionAffinityManager;
import com.ibm.wsspi.session.ISessionManagerCustomizer;
import com.ibm.wsspi.session.ISessionObserver;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.IStorer;
import com.ibm.wsspi.session.ITimer;
import com.ibm.wsspi.session.SessionAffinityContext;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class SessionContext {
    public SessionManagerConfig _smc;
    private final SessionStoreService sessionStoreService;
    public SessionApplicationParameters _sap;
    protected IGenericSessionManager _coreHttpSessionManager = null;
    public IGenericSessionManager _coreHttpAppSessionManager = null;
    protected ISessionAffinityManager _sam = null;
    protected boolean isSIPApplication = false;
    protected boolean sessionAttributeListener = false;
    protected boolean sessionListener = false;
    protected ArrayList mHttpSessionAttributeListeners = new ArrayList();
    protected ArrayList mHttpSessionListeners = new ArrayList();
    protected ArrayList mHttpSessionIdListeners = new ArrayList();
    protected ArrayList mHttpSessionAttributeListenersJ2eeNames = new ArrayList();
    protected ArrayList mHttpSessionListenersJ2eeNames = new ArrayList();
    protected ArrayList mHttpSessionIdListenersJ2eeNames = new ArrayList();
    protected static InetAddress mLocalHost;
    private int _refCount = 1;
    protected static WSThreadLocal currentThreadSacHashtable;
    private static final String methodClassName = "SessionContext";
    static final String ANONYMOUS_USER = "anonymous";
    protected WasHttpSessionObserver wasHttpSessionObserver;
    HttpSessionAttributeObserver wasHttpSessionAttributeObserver;
    protected ITimer _invalidator = null;
    protected IStorer _storer = null;
    protected WasHttpAppSessionObserver wasHttpAppSessionObserver = null;
    protected ArrayList mHttpAppSessionListeners = null;
    private static final String cmvcInfo = "CMVC Version 1.9 6/24/07 11:12:24";
    private static boolean _loggedVersion;
    protected static final int CREATE_CORE_SESSION_MANAGER = 0;
    protected static final int GET_REQUESTED_SESSION_ID = 1;
    protected static final int GET_IHTTP_SESSION = 2;
    protected static final int SESSION_PRE_INVOKE = 3;
    protected static final int SESSION_POST_INVOKE = 4;
    protected static final int STOP = 5;
    protected static final int STOP_LISTENERS = 6;
    protected static final int IS_VALID = 7;
    protected static final int ENCODE_URL = 8;
    protected static final int SHOULD_ENCODE_URL = 9;
    protected static final int IS_PROTOCOL_SWITCH = 10;
    protected static final int GET_LOCAL_HOST = 11;
    protected static final int ADD_HTTP_SESSION_ATTRIBUTE_LISTENER = 12;
    protected static final int ADD_HTTP_SESSION_LISTENER = 13;
    protected static final int GET_SESSION_AFFINITY_CONTEXT = 14;
    protected static final int CHECK_SECURITY = 15;
    protected static final int INVALIDATE = 16;
    protected static final int CHECK_SESSSIONID_IS_RIGHT_LENGTH = 17;
    protected static final int LOCK_SESSION = 18;
    protected static final int UNLOCK_SESSION = 19;
    protected static final int ADD_HTTP_SESSION_ID_LISTENER = 20;
    protected static final String[] methodNames;

    public SessionManagerConfig get_smc() {
        return this._smc;
    }

    public SessionContext(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService) {
        this(smc, sap, sessionStoreService, false);
    }

    public SessionContext(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService, boolean removeAttrOnInvalidate) {
        if (!_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.9 6/24/07 11:12:24, removeAttrOnInvalidate -->" + removeAttrOnInvalidate);
            _loggedVersion = true;
        }
        this._smc = smc;
        this._sap = sap;
        this.sessionStoreService = sessionStoreService;
        this._coreHttpSessionManager = !removeAttrOnInvalidate ? this.createCoreSessionManager() : this.createCoreSessionManager(removeAttrOnInvalidate);
        if (sap.getHasApplicationSession()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "Creating an appSessionContext for " + this._sap.getAppName());
            }
            this._coreHttpAppSessionManager = this.createCoreAppSessionManager();
            if (this._coreHttpAppSessionManager == null) {
                sap.setHasApplicationSession(false);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "Setting hasApplicationSession to false for " + sap.getAppName());
                }
            }
        }
    }

    public IGenericSessionManager createCoreAppSessionManager() {
        return null;
    }

    public IGenericSessionManager createCoreSessionManager() {
        return this.createCoreSessionManager(false);
    }

    public IGenericSessionManager createCoreSessionManager(boolean removeAttrOnInvalidate) {
        long sessionTimeout;
        EnumSet<SessionTrackingMode> trackingMode;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "appName = " + this._sap.getAppName());
        }
        String _sessionManagerID = this._sap.getAppName();
        SessionManager _sessionManager = new SessionManager(_sessionManagerID);
        ISessionManagerCustomizer sessionMgrCustomizer = _sessionManager.getSessionManagerCustomizer();
        sessionMgrCustomizer.setServletContext(this._sap.getServletContext());
        sessionMgrCustomizer.setIDGenerator(new IDGeneratorImpl(SessionManagerConfig.getSessionIDLength()));
        SessionCookieConfig sessionCookieConfig = this._sap.getSessionCookieConfig();
        if (sessionCookieConfig != null) {
            this._smc.updateCookieInfo(sessionCookieConfig);
        }
        if ((trackingMode = this._sap.getSessionTrackingModes()) != null) {
            this._smc.updateTrackingMode(trackingMode);
        }
        if ((sessionTimeout = this._sap.getSessionTimeout()) == 0L) {
            sessionTimeout = this._smc.getSessionInvalidationTime();
        }
        sessionTimeout = this.checkMinimumInvalidation(sessionTimeout);
        sessionMgrCustomizer.setSessionTimeout((int)sessionTimeout);
        WasHttpSessionAdapter adapter = new WasHttpSessionAdapter(this, this._sap.getServletContext());
        sessionMgrCustomizer.setAdapter(adapter);
        this.wasHttpSessionObserver = this.mHttpSessionIdListeners == null ? new WasHttpSessionObserver(this.mHttpSessionListeners, adapter) : new WasHttpSessionObserver(this.mHttpSessionListeners, this.mHttpSessionIdListeners, adapter);
        sessionMgrCustomizer.registerSessionObserver(this.wasHttpSessionObserver);
        sessionMgrCustomizer.registerSessionStateObserver(new HttpSessionAttributeObserver(this.mHttpSessionAttributeListeners, adapter));
        IStore _store = null;
        _store = !removeAttrOnInvalidate ? this.createStore(this._smc, _sessionManagerID, this._sap.getServletContext(), false) : this.createStore(this._smc, _sessionManagerID, this._sap.getServletContext(), false, removeAttrOnInvalidate);
        _store.setDistributable(this._sap.getDistributableWebApp());
        sessionMgrCustomizer.registerStore(_store);
        this._invalidator = this.createInvalidator();
        int reaperInterval = this.getReaperInterval(sessionTimeout);
        IStore fStore = _store;
        CheckpointPhase.onRestore((int)3, () -> this._invalidator.start(fStore, reaperInterval));
        this._storer = this.createStorer(this._smc, _store);
        sessionMgrCustomizer.registerStorer(this._storer);
        ISessionAffinityManager isam = this.createSessionAffinityManager(this._smc, this, _store);
        sessionMgrCustomizer.registerAffinityManager(isam);
        this._sam = isam;
        ISessionObserver servantAffinityManager = this.getServantAffinityManager(this._smc, adapter, this._sap.getAppName());
        if (servantAffinityManager != null) {
            sessionMgrCustomizer.registerSessionObserver(servantAffinityManager);
        }
        SessionManagerRegistry.getSessionManagerRegistry().registerSessionManager(_sessionManagerID, _sessionManager);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "_sessionManager =" + _sessionManager);
        }
        return _sessionManager;
    }

    public ITimer createInvalidator() {
        if (this._smc.getUseSeparateSessionInvalidatorThreadPool()) {
            SessionInvalidatorWithThreadPool invalidator = new SessionInvalidatorWithThreadPool();
            invalidator.setDelay(this._smc.getDelayForInvalidationAlarmDuringServerStartup());
            return invalidator;
        }
        SessionInvalidator invalidator = new SessionInvalidator();
        invalidator.setDelay(this._smc.getDelayForInvalidationAlarmDuringServerStartup());
        return invalidator;
    }

    protected MemoryStoreHelper createStoreHelper(ServletContext sc) {
        return null;
    }

    public IStore createStore(SessionManagerConfig smc, String smid, ServletContext sc) {
        return this.createStore(smc, smid, sc, false, false);
    }

    public IStore createStore(SessionManagerConfig smc, String smid, ServletContext sc, boolean applicationSessionStore) {
        return this.createStore(smc, smid, sc, applicationSessionStore, false);
    }

    public IStore createStore(SessionManagerConfig smc, String smid, ServletContext sc, boolean applicationSessionStore, boolean removeAttrOnInvalidate) {
        IStore store = null;
        MemoryStoreHelper storeHelper = this.createStoreHelper(sc);
        SessionStoreService service = this.sessionStoreService;
        if (service != null) {
            store = service.createStore(smc, smid, sc, storeHelper, this._sap.getAppClassLoader(), applicationSessionStore);
        }
        if (store == null) {
            store = !removeAttrOnInvalidate ? new MemoryStore(smc, smid, sc, storeHelper, applicationSessionStore) : new MemoryStore(smc, smid, sc, storeHelper, applicationSessionStore, removeAttrOnInvalidate);
        }
        return store;
    }

    public IStorer createStorer(SessionManagerConfig smc, IStore store) {
        IStorer storer = null;
        storer = smc.getEnableTimeBasedWrite() ? (smc.getPropertyWriterInterval() < 10L ? new TBWSessionStorer(store, (int)smc.getPropertyWriterInterval()) : new TBWSessionStorer(store, 10)) : (smc.getEnableManualWrite() ? new ManualSessionStorer() : new EOSSessionStorer());
        return storer;
    }

    public ISessionObserver getServantAffinityManager(SessionManagerConfig smc, IProtocolAdapter adapter, String appName) {
        return null;
    }

    public ISessionAffinityManager createSessionAffinityManager(SessionManagerConfig smc, SessionContext sctx, IStore istore) {
        return new SessionAffinityManager(smc, sctx, istore);
    }

    public Object createSessionObject(ISession isess, ServletContext servCtx) {
        return new SessionData(isess, this, servCtx);
    }

    public long checkMinimumInvalidation(long invalTime) {
        return invalTime;
    }

    public int getReaperInterval(long timeout) {
        int rpi = (int)this._smc.getReaperPollInterval();
        if (rpi < 30) {
            int randomLessThanThirty = (int)(System.currentTimeMillis() % 30L);
            rpi = timeout <= 120L ? 60 - randomLessThanThirty : (timeout <= 900L ? 60 + randomLessThanThirty : (timeout <= 1800L ? 120 + 2 * randomLessThanThirty : 240 + 2 * randomLessThanThirty));
            this._smc.setReaperPollInterval(rpi);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "getReaperInterval", "returning " + rpi);
        }
        return rpi;
    }

    protected void setSIPCookieIfApplicable(HttpServletRequest _request, HttpServletResponse response, SessionData sd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionPostInvoke(HttpSession sess) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[4]);
        }
        AbstractSessionData s = (AbstractSessionData)sess;
        if (this._smc.getAllowSerializedSessionAccess()) {
            this.unlockSession(sess);
        }
        if (s != null) {
            AbstractSessionData abstractSessionData = s;
            synchronized (abstractSessionData) {
                ISession iSess;
                SessionAffinityContext sac = null;
                this._coreHttpSessionManager.releaseSession(s.getISession(), sac);
                if (this._coreHttpAppSessionManager != null && (iSess = (ISession)this._coreHttpAppSessionManager.getIStore().getFromMemory(s.getId())) != null) {
                    this._coreHttpAppSessionManager.releaseSession(iSess, sac);
                }
            }
        }
        if (this._smc.isDebugSessionCrossover()) {
            currentThreadSacHashtable.set(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4]);
        }
    }

    public String getCurrentSessionId() {
        SessionAffinityContext sac;
        String currentId = null;
        Hashtable ht = (Hashtable)currentThreadSacHashtable.get();
        if (ht != null && (sac = (SessionAffinityContext)ht.get(this._smc.getSessionAffinityContextKey())) != null && (currentId = this._sam.getInUseSessionID(null, sac)) == null) {
            currentId = "NONE";
        }
        return currentId;
    }

    public void lockSession(HttpServletRequest req, HttpSession sess) {
    }

    public void unlockSession(HttpSession sess) {
    }

    public synchronized void stop(String J2EEName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[5]);
        }
        this.decrementRefCount();
        if (this._refCount > 0) {
            if (this._sap.getAppName() == "GLOBAL_HTTP_SESSION_CONTEXT") {
                this.stopListeners(J2EEName);
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5], "Reference count is not zero, so returning without stopping");
            }
            return;
        }
        String coreManagerId = this._coreHttpSessionManager.getID();
        this._coreHttpSessionManager.getIStore().stop();
        if (this._coreHttpAppSessionManager != null) {
            this.cleanUpAppSessionManager(coreManagerId, J2EEName);
        }
        this._invalidator.stop();
        if (this._storer instanceof ITimer) {
            ((ITimer)((Object)this._storer)).stop();
        }
        String appName = this._sap.getAppName();
        SessionContextRegistry.remove(appName);
        SessionManagerRegistry.getSessionManagerRegistry().unregisterSessionManager(appName);
        SessionManager removedSessionManager = SessionManager.removeSessionManager(appName);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINEST)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINEST, methodClassName, methodNames[5], "Removed session manager: " + removedSessionManager);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5]);
        }
    }

    protected void cleanUpAppSessionManager(String coreManagerId, String J2EEName) {
    }

    public void reload(String J2EEName) {
        this.stop(J2EEName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListeners(String stoppingJ2eename) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[6], "stopListeners for " + stoppingJ2eename);
        }
        if (stoppingJ2eename != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "mHttpSessListenersJ2eeNames.size is " + this.mHttpSessionListenersJ2eeNames.size());
            }
            ArrayList arrayList = this.mHttpSessionListeners;
            synchronized (arrayList) {
                boolean mIBMSessionListenerImplemented;
                for (int x = this.mHttpSessionListenersJ2eeNames.size() - 1; x >= 0; --x) {
                    String listenerJ2eeName = (String)this.mHttpSessionListenersJ2eeNames.get(x);
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "listenerJ2eeName is " + listenerJ2eeName);
                    }
                    if (stoppingJ2eename.equals(listenerJ2eeName)) {
                        this.mHttpSessionListeners.remove(x);
                        this.mHttpSessionListenersJ2eeNames.remove(x);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) continue;
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "stopping http session listener for: " + stoppingJ2eename);
                }
                if (this.mHttpSessionListeners.size() == 0) {
                    this.sessionListener = false;
                    this._coreHttpSessionManager.getIStore().setHttpSessionListener(false);
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "stopped all http session listeners");
                    }
                }
                if (this.wasHttpSessionObserver.getDoesContainIBMSessionListener() && !(mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented(this.mHttpSessionListeners))) {
                    this.wasHttpSessionObserver.setDoesContainIBMSessionListener(false);
                }
            }
            for (int x = this.mHttpSessionAttributeListenersJ2eeNames.size() - 1; x >= 0; --x) {
                String listenerJ2eeName = (String)this.mHttpSessionAttributeListenersJ2eeNames.get(x);
                if (!stoppingJ2eename.equals(listenerJ2eeName)) continue;
                this.mHttpSessionAttributeListeners.remove(x);
                this.mHttpSessionAttributeListenersJ2eeNames.remove(x);
                if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) continue;
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "stopping http session attribute listener for: " + stoppingJ2eename);
            }
            if (this.mHttpSessionAttributeListeners.size() == 0) {
                this.sessionAttributeListener = false;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "stopped all http session attribute listeners");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[6]);
        }
    }

    public boolean shouldEncodeURL(String pURL, HttpServletRequest pRequest) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[9]);
        }
        if (!SessionManagerConfig.isAlwaysEncodeURL() && this._smc.getEnableCookies() && pRequest.getHeader("Cookie") != null) {
            if (SessionManagerConfig.checkSessionCookieNameOnEncodeURL()) {
                Cookie[] cookies = pRequest.getCookies();
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(this._smc.getSessionCookieName())) continue;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "false - A http session cookie was found");
                    }
                    return false;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "false - A cookie was found");
                }
                return false;
            }
        }
        if (!this._smc.getEnableUrlRewriting()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "false - encodeOff");
            }
            return false;
        }
        if (!this.isProtocolSwitch(pURL, pRequest)) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "true - encodeProtocolSwitchOff");
            }
            return true;
        }
        if (this._smc.getEnableUrlProtocolSwitchRewriting()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "true - encodeProtocolSwitchOn");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[9], "false");
        }
        return false;
    }

    private boolean isProtocolSwitch(String pURL, HttpServletRequest pRequest) {
        InetAddress hostaddr;
        int start;
        char ch;
        int end;
        int ix;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[10]);
        }
        if ((ix = pURL.indexOf("://")) < 0) {
            return false;
        }
        String protocol = pURL.substring(0, ix);
        if (!(protocol.equalsIgnoreCase("http") && pRequest.getScheme().equalsIgnoreCase("https") || protocol.equalsIgnoreCase("https") && pRequest.getScheme().equalsIgnoreCase("http"))) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[10], "false - No protocol switch.");
            }
            return false;
        }
        int len = pURL.length();
        for (end = start = ix + 3; end < len && (ch = pURL.charAt(end)) != ':' && ch != '/'; ++end) {
        }
        String host = pURL.substring(start, end);
        try {
            hostaddr = InetAddress.getByName(host);
        }
        catch (UnknownHostException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.session.SessionContext.isProtocolSwitch", (String)"1760", (Object)this);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[10], "CommonMessage.exception", exc);
            return false;
        }
        if (!hostaddr.equals(this.getLocalHost())) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[10], "false - Host Addresses are not equal");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[10], "true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetAddress getLocalHost() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[11]);
        }
        if (mLocalHost == null) {
            SessionContext sessionContext = this;
            synchronized (sessionContext) {
                try {
                    mLocalHost = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getLocalHost();
                        }
                    });
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[11], "InetAddress = " + mLocalHost);
                    }
                }
                catch (PrivilegedActionException pae) {
                    FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ws.session.SessionContext.getLocalHost", (String)"423", (Object)this);
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[11], "", pae);
                }
            }
        }
        return mLocalHost;
    }

    public boolean getIntegrateWASSecurity() {
        return this._smc.getIntegrateSecurity();
    }

    public void addHttpSessionAttributeListener(ArrayList al, String j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[12], "addHttpSessionAttributeListener:" + al);
        }
        if (j2eeName != null) {
            this.addToJ2eeNameList(j2eeName, al.size(), this.mHttpSessionAttributeListenersJ2eeNames);
        }
        this.mHttpSessionAttributeListeners.addAll(al);
        if (this.mHttpSessionAttributeListeners.size() > 0) {
            this.sessionAttributeListener = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[12], "addHttpSessionAttributeListener:" + al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSessionListener(ArrayList al, String j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[13], "addHttpSessionListener:" + al);
        }
        if (j2eeName != null) {
            this.addToJ2eeNameList(j2eeName, al.size(), this.mHttpSessionListenersJ2eeNames);
        }
        ArrayList arrayList = this.mHttpSessionListeners;
        synchronized (arrayList) {
            this.mHttpSessionListeners.addAll(al);
            if (this.mHttpSessionListeners.size() > 0) {
                this.sessionListener = true;
                this._coreHttpSessionManager.getIStore().setHttpSessionListener(true);
                boolean mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented(al);
                if (mIBMSessionListenerImplemented) {
                    this.wasHttpSessionObserver.setDoesContainIBMSessionListener(true);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[13], "addHttpSessionListener:" + al);
        }
    }

    private void addToJ2eeNameList(String j2eeName, int size, ArrayList listenerJ2eeNames) {
        int start = listenerJ2eeNames.size();
        int end = start + size;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("starting at ").append(start).append(" going to ").append(end).append(" for ").append(j2eeName);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "addToJ2eeNameList", sb.toString());
        }
        for (int x = start; x < end; ++x) {
            listenerJ2eeNames.add(j2eeName);
        }
    }

    public boolean isIBMSessionListenerImplemented(ArrayList listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            HttpSessionListener listener = (HttpSessionListener)listeners.get(i);
            if (listener == null || !(listener instanceof IBMSessionListener)) continue;
            return true;
        }
        return false;
    }

    public synchronized void incrementRefCount() {
        ++this._refCount;
    }

    public synchronized void decrementRefCount() {
        --this._refCount;
    }

    public boolean isValid() {
        return this._refCount > 0;
    }

    public String toHTML() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "toHTML");
        }
        StringBuffer strbuf = new StringBuffer();
        String appName = this._sap.getJ2EEName();
        MemoryStore ms = (MemoryStore)this._coreHttpSessionManager.getIStore();
        int size = 0;
        if (ms._sessions != null) {
            size = ms._sessions.size();
        }
        String globalScopeComment = "<b> (for this webapp) : </b> ";
        strbuf.append("<center><h3>J2EE NAME(AppName#WebModuleName):: " + appName + " </h3></center><UL>\n");
        strbuf.append("<b>  cloneId</b> : ");
        strbuf.append(((SessionAffinityManager)this._sam).getCloneId());
        strbuf.append("<BR>");
        strbuf.append("<BR>");
        strbuf.append("<b>  Number of sessions in memory: </b>");
        strbuf.append(globalScopeComment);
        strbuf.append(size);
        strbuf.append("<BR>");
        if (this._smc.isUsingMemory()) {
            strbuf.append("<b>  use overflow</b> : ");
            strbuf.append(this._smc.getEnableOverflow());
            strbuf.append("<BR>");
            if (this._smc.getEnableOverflow()) {
                strbuf.append("<b>  overflow size</b> ");
                strbuf.append(globalScopeComment);
                strbuf.append(((SessionSimpleHashMap)ms._sessions).getOverflowSize());
                strbuf.append("<BR>");
            }
        }
        strbuf.append("<b>  Invalidation alarm poll interval (for this webapp) </b> : ");
        strbuf.append(this._smc.getInvalidationCheckInterval());
        strbuf.append("<BR>");
        strbuf.append("<b> Max invalidation timeout (for this webapp) </b> : ");
        strbuf.append(this._smc.getSessionInvalidationTime());
        strbuf.append("<BR>");
        strbuf.append("<b> Using Cookies </b> : ");
        strbuf.append(this._smc.getEnableCookies());
        strbuf.append("<BR>");
        strbuf.append("<b> Using URL Rewriting </b> : ");
        strbuf.append(this._smc.getEnableUrlRewriting());
        strbuf.append("<BR>");
        strbuf.append("<b> use SSLId </b> : ");
        strbuf.append(this._smc.useSSLId());
        strbuf.append("<BR>");
        strbuf.append("<b> URL Protocol Switch Rewriting </b> : ");
        strbuf.append(this._smc.getEnableUrlProtocolSwitchRewriting());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie Name </b> : ");
        strbuf.append(this._smc.getSessionCookieName());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie Comment </b> : ");
        strbuf.append(this._smc.getSessionCookieComment());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie Domain </b> : ");
        strbuf.append(this._smc.getSessionCookieDomain());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie Path </b> : ");
        strbuf.append(this._smc.getSessionCookiePath());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie MaxAge </b> : ");
        strbuf.append(this._smc.getSessionCookieMaxAge());
        strbuf.append("<BR>");
        strbuf.append("<b> Session Cookie Secure </b> : ");
        strbuf.append(this._smc.getSessionCookieSecure());
        strbuf.append("<BR>");
        strbuf.append("<b> Maximum in memory table size </b> : ");
        strbuf.append(this._smc.getInMemorySize());
        strbuf.append("<BR>");
        strbuf.append("<b> current time </b> : ");
        strbuf.append(new Date(System.currentTimeMillis()).toString());
        strbuf.append("<BR>");
        strbuf.append("<b>  integrateWASSec</b> :");
        strbuf.append(this._smc.getIntegrateSecurity());
        strbuf.append("<BR><b>Session locking </b>: ");
        strbuf.append(this._smc.getAllowSerializedSessionAccess());
        if (this._smc.getAllowSerializedSessionAccess()) {
            strbuf.append("<BR><b>Session locking timeout</b>: ");
            strbuf.append(this._smc.getSerializedSessionAccessMaxWaitTime());
            strbuf.append("<BR><b>Allow access on lock timeout</b>:");
            strbuf.append(this._smc.getAccessSessionOnTimeout());
        }
        if (ms.getSessionStatistics() != null) {
            strbuf.append(ms.getSessionStatistics().toHTML());
        }
        strbuf.append(ms.toHTML());
        return strbuf.toString();
    }

    public String getAppName() {
        return this._sap.getAppName();
    }

    public boolean crossoverCheck(HttpSession session) {
        return this.crossoverCheck(null, session);
    }

    public boolean crossoverCheck(HttpServletRequest req, HttpSession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "crossoverCheck", "session crossover cannot be detected");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String sessionId) {
        ISession iSess;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("for app ").append(this._sap.getAppName()).append(" id ").append(sessionId);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[16], sb.toString());
        }
        if ((iSess = this._coreHttpSessionManager.getISession(sessionId)) != null) {
            IStore iStore = this._coreHttpSessionManager.getIStore();
            try {
                iStore.setThreadContext();
                ISession iSession = iSess;
                synchronized (iSession) {
                    if (iSess.isValid()) {
                        iSess.invalidate();
                    }
                }
            }
            finally {
                iStore.unsetThreadContext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[16]);
        }
    }

    public void remoteInvalidate(String sessionId, boolean backendUpdate) {
        IStore iStore = this._coreHttpSessionManager.getIStore();
        ((MemoryStore)iStore).remoteInvalidate(sessionId, backendUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSessionListener(HttpSessionListener listener, String J2EEName) {
        ArrayList arrayList = this.mHttpSessionListeners;
        synchronized (arrayList) {
            this.mHttpSessionListeners.add(listener);
            this.mHttpSessionListenersJ2eeNames.add(J2EEName);
            this.sessionListener = true;
            this._coreHttpSessionManager.getIStore().setHttpSessionListener(true);
            if (this.mHttpAppSessionListeners != null) {
                this.mHttpAppSessionListeners.add(listener);
            }
            if (this._coreHttpAppSessionManager != null) {
                this._coreHttpAppSessionManager.getIStore().setHttpSessionListener(true);
            }
            if (listener instanceof IBMSessionListener) {
                this.wasHttpSessionObserver.setDoesContainIBMSessionListener(true);
                if (this.wasHttpAppSessionObserver != null) {
                    this.wasHttpAppSessionObserver.setDoesContainIBMSessionListener(true);
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[13], "Marked  app IBM session listener for app observer " + this.mHttpAppSessionListeners);
                }
            }
        }
    }

    public void sessionCreatedEvent(HttpSessionEvent event) {
        ArrayList listeners = this.mHttpSessionListeners;
        for (int i = 0; i < listeners.size(); ++i) {
            HttpSessionListener listener = (HttpSessionListener)listeners.get(i);
            if (listener == null) continue;
            listener.sessionCreated(event);
        }
    }

    public void sessionDestroyedEvent(HttpSessionEvent event) {
        ArrayList listeners = this.mHttpSessionListeners;
        for (int i = listeners.size() - 1; i >= 0; --i) {
            HttpSessionListener listener = (HttpSessionListener)listeners.get(i);
            if (listener == null) continue;
            listener.sessionDestroyed(event);
        }
    }

    public void sessionAttributeAddedEvent(HttpSessionBindingEvent event) {
        ArrayList list = this.mHttpSessionAttributeListeners;
        for (int i = 0; i < list.size(); ++i) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)list.get(i);
            if (listener == null) continue;
            listener.attributeAdded(event);
        }
    }

    public void sessionAttributeReplacedEvent(HttpSessionBindingEvent event) {
        ArrayList list = this.mHttpSessionAttributeListeners;
        for (int i = 0; i < list.size(); ++i) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)list.get(i);
            if (listener == null) continue;
            listener.attributeReplaced(event);
        }
    }

    public void sessionAttributeRemovedEvent(HttpSessionBindingEvent event) {
        ArrayList list = this.mHttpSessionAttributeListeners;
        for (int i = 0; i < list.size(); ++i) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)list.get(i);
            if (listener == null) continue;
            listener.attributeRemoved(event);
        }
    }

    public boolean isSessionTimeoutSet() {
        boolean b = this._sap.getSessionTimeout() != 0L;
        return b;
    }

    public int getSessionTimeOut() {
        int i = (int)this._smc.getSessionInvalidationTime();
        return i;
    }

    public void addHttpSessionAttributeListener(HttpSessionAttributeListener listener, String J2EEName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[12], "J2EE name is " + J2EEName);
        }
        this.mHttpSessionAttributeListeners.add(listener);
        this.mHttpSessionAttributeListenersJ2eeNames.add(J2EEName);
        this.sessionAttributeListener = true;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[12]);
        }
    }

    public boolean isSIPApplication() {
        return this.isSIPApplication;
    }

    public void setSIPApplication(boolean isSIPApplication) {
        this.isSIPApplication = isSIPApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSessionIdListener(ArrayList al, String j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[20], "addHttpSessionIdListener:" + al);
        }
        if (j2eeName != null) {
            this.addToJ2eeNameList(j2eeName, al.size(), this.mHttpSessionIdListenersJ2eeNames);
        }
        ArrayList arrayList = this.mHttpSessionIdListeners;
        synchronized (arrayList) {
            this.mHttpSessionIdListeners.addAll(al);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[13], "addHttpSessionListener:" + al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSessionIdListener(HttpSessionIdListener listener, String J2EEName) {
        ArrayList arrayList = this.mHttpSessionIdListeners;
        synchronized (arrayList) {
            this.mHttpSessionIdListeners.add(listener);
            this.mHttpSessionIdListenersJ2eeNames.add(J2EEName);
        }
    }

    static {
        currentThreadSacHashtable = null;
        _loggedVersion = false;
        methodNames = new String[]{"createCoreSessionManager", "getRequestedSessionId", "getIHttpSession", "sessionPreInvoke", "sessionPostInvoke", "stop", "stopListeners", "isValid", "encodeURL", "shouldEncodeURL", "isProtocolSwitch", "getLocalHost", "addHttpSessionAttributeListener", "addHttpSessionListener", "getSessionAffinityContext", "checkSecurity", "invalidate", "checkSessionIdIsRightLength", "lockSession", "unlockSession", "addHttpSessionIdListener"};
    }
}

