/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.reporting.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.FixManager;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.reporting.internal.ReporterTask;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.SatisfyingConditionTarget;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPid={"io.openliberty.reporting.CVEReportingComponent"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@SatisfyingConditionTarget(value="(osgi.condition.id=io.openliberty.process.running)")
public class FixReportingComponent {
    ReporterTask reporterTask;
    ScheduledFuture<?> future;
    ScheduledExecutorService scheduledExecutor;
    private static final TraceComponent tc = Tr.register(FixReportingComponent.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
    static final long serialVersionUID = -575812010628632018L;

    @Activate
    public FixReportingComponent(ComponentContext ignored, Map<String, Object> properties, @Reference ServerStartedPhase2 justAMarker, @Reference FeatureProvisioner featureProvisioner, @Reference FixManager fixManager, @Reference ServerInfoMBean serverInfo, @Reference(target="(deferrable=true)") ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        this.reporterTask = new ReporterTask(featureProvisioner, fixManager, serverInfo, properties);
        if (FixReportingComponent.isEnabled(properties)) {
            Tr.info((TraceComponent)tc, (String)"CWWKF1700.reporting.is.enabled", (Object[])new Object[0]);
            this.future = scheduledExecutor.scheduleAtFixedRate(this.reporterTask, 0L, 1L, TimeUnit.DAYS);
        } else {
            Tr.info((TraceComponent)tc, (String)"CWWKF1701.reporting.is.disabled", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (FixReportingComponent.isEnabled(properties)) {
            if (this.future == null || this.future.isDone()) {
                Tr.info((TraceComponent)tc, (String)"CWWKF1700.reporting.is.enabled", (Object[])new Object[0]);
                this.future = this.scheduledExecutor.scheduleAtFixedRate(this.reporterTask, 0L, 1L, TimeUnit.DAYS);
            }
        } else if (this.future != null && !this.future.isDone()) {
            Tr.info((TraceComponent)tc, (String)"CWWKF1701.reporting.is.disabled", (Object[])new Object[0]);
            this.future.cancel(false);
            this.future = null;
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    private static boolean isEnabled(final Map<String, Object> properties) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 3765027106842543993L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                Boolean enabled = false;
                enabled = Boolean.getBoolean("cve.insight.enabled");
                if (enabled.booleanValue()) {
                    return !Boolean.FALSE.equals(properties.get("enabled"));
                }
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.reporting.internal.FixReportingComponent$1", 1.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
            }
        });
    }
}

