/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] buf) {
        super(buf);
    }

    DerInputBuffer(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalArgumentException(e2.toString());
        }
    }

    void rewind(int length) {
        if (length <= this.pos) {
            this.pos -= length;
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        for (int i2 = 0; i2 < max; ++i2) {
            if (this.buf[this.pos + i2] == other.buf[other.pos + i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p2 = this.pos;
        for (int i2 = 0; i2 < len; ++i2) {
            retval += this.buf[p2 + i2] * i2;
        }
        return retval;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInteger getBigInteger(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        return new BigInteger(bytes);
    }

    BigInteger getPositiveBigInteger(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        return new BigInteger(1, bytes);
    }

    int getSigned(int len) throws IOException {
        int result = 0;
        if (len > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        byte[] data = new byte[len];
        System.arraycopy(this.buf, this.pos, data, 0, len);
        for (int i2 = 0; i2 < len; ++i2) {
            result |= (data[i2] & 0xFF) << 8 * (len - (i2 + 1));
        }
        if (len > 0 && (data[0] & 0x80) == 128) {
            result |= -1 << 8 * len;
        }
        this.skip(len);
        return result;
    }

    byte[] getBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte numOfPadBits = this.buf[this.pos];
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, this.pos + 1, retval, 0, len - 1);
        if (numOfPadBits != 0) {
            int n2 = len - 2;
            retval[n2] = (byte)(retval[n2] & 255 << numOfPadBits);
        }
        this.skip(len);
        return retval;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int len = this.available();
        int unusedBits = this.buf[this.pos] & 0xFF;
        if (unusedBits > 7) {
            throw new IOException("Invalid value for unused bits: " + unusedBits);
        }
        byte[] bits = new byte[len - 1];
        int length = bits.length == 0 ? 0 : bits.length * 8 - unusedBits;
        System.arraycopy(this.buf, this.pos + 1, bits, 0, len - 1);
        BitArray bitArray = new BitArray(length, bits);
        this.pos = this.count;
        return bitArray;
    }
}

