/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public final class PKCS12 {
    static final String MAC_ALGORITHM = "SHA1";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12";
    public static final byte KEY_ID = 1;
    public static final byte IV_ID = 2;
    public static final byte MAC_ID = 3;
    public static final int NO_ENCRYPT = 1;
    public static final int PASSWD_ENCRYPT = 2;
    public static final int PUBKEY_ENCRYPT = 3;

    private PKCS12() {
    }

    private PKCS12(String provider) {
    }

    public static byte[] genKey(byte id, String digestAlg, char[] pwd, byte[] salt, int iterations, int keysize) throws NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{new Byte(id), digestAlg, pwd, salt, new Integer(iterations), new Integer(keysize)};
            debug.entry(49152L, (Object)className, "genKey", parms);
            debug.exit(49152L, className, "genKey");
        }
        return PKCS12.genKey(id, digestAlg, pwd, salt, iterations, keysize, null);
    }

    public static byte[] genKey(byte id, String digestAlg, char[] pwd, byte[] salt, int iterations, int keysize, String provider) throws NoSuchAlgorithmException {
        int v2;
        int u2;
        if (debug != null) {
            Object[] parms = new Object[]{new Byte(id), digestAlg, pwd, salt, new Integer(iterations), new Integer(keysize), provider};
            debug.entry(49152L, (Object)className, "genKey", parms);
        }
        if (id != 1 && id != 2 && id != 3) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
            }
            throw new IllegalArgumentException("Illegal identifier byte: " + id + ". Must be one of 1, 2 or 3.");
        }
        if (digestAlg == null || digestAlg.length() == 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "No digest algorithm specified.");
            }
            throw new IllegalArgumentException("No digest algorithm specified.");
        }
        if (iterations <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Iterations must be greater than zero.");
            }
            throw new IllegalArgumentException("Iterations must be greater than zero.");
        }
        if (keysize <= 0) {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Keybits must be greater than zero.");
            }
            throw new IllegalArgumentException("Keybits must be greater than zero.");
        }
        if (digestAlg.equalsIgnoreCase("SHA") || digestAlg.equalsIgnoreCase(MAC_ALGORITHM) || digestAlg.equalsIgnoreCase("SHA-1")) {
            u2 = 20;
            v2 = 64;
        } else if (digestAlg.equalsIgnoreCase("MD2") || digestAlg.equalsIgnoreCase("MD5")) {
            u2 = 16;
            v2 = 64;
        } else {
            if (debug != null) {
                debug.text(49152L, className, "genKey", "Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digestAlg + ".  Must be one of SHA, MD2 or MD5.");
        }
        byte[] passwd = PKCS12Utils.ascii2bmp(pwd);
        MessageDigest md = null;
        if (provider != null) {
            try {
                md = MessageDigest.getInstance(digestAlg, provider);
            }
            catch (NoSuchProviderException nspe) {
                if (debug != null) {
                    debug.text(49152L, className, "genKey", "provider " + provider + " not found");
                }
                throw new IllegalArgumentException("provider " + provider + " not found");
            }
        } else {
            md = MessageDigest.getInstance(digestAlg);
        }
        int c2 = PKCS12.roundup(keysize, u2) / u2;
        byte[] D = new byte[v2];
        int s2 = PKCS12.roundup(salt.length, v2);
        int p2 = PKCS12.roundup(passwd.length, v2);
        byte[] I = new byte[s2 + p2];
        byte[] key = new byte[keysize];
        Arrays.fill(D, id);
        PKCS12.concat(salt, I, 0, s2);
        PKCS12.concat(passwd, I, s2, p2);
        byte[] B = new byte[v2];
        byte[] tmp = new byte[v2];
        int i2 = 0;
        while (true) {
            md.update(D);
            md.update(I);
            byte[] Ai = md.digest();
            for (int r2 = 1; r2 < iterations; ++r2) {
                Ai = md.digest(Ai);
            }
            System.arraycopy(Ai, 0, key, u2 * i2, Math.min(keysize, u2));
            if (i2 + 1 == c2) break;
            PKCS12.concat(Ai, B, 0, B.length);
            BigInteger B1 = new BigInteger(1, B).add(BigInteger.ONE);
            for (int j2 = 0; j2 < I.length; j2 += v2) {
                if (tmp.length != v2) {
                    tmp = new byte[v2];
                }
                System.arraycopy(I, j2, tmp, 0, v2);
                BigInteger Ij = new BigInteger(1, tmp);
                Ij = Ij.add(B1);
                tmp = Ij.toByteArray();
                int trunc = tmp.length - v2;
                if (trunc >= 0) {
                    System.arraycopy(tmp, trunc, I, j2, v2);
                    continue;
                }
                if (trunc >= 0) continue;
                Arrays.fill(I, j2, j2 + -trunc, (byte)0);
                System.arraycopy(tmp, 0, I, j2 + -trunc, tmp.length);
            }
            ++i2;
            keysize -= u2;
        }
        Arrays.fill(passwd, (byte)0);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "genKey", key);
        }
        return key;
    }

    private static int roundup(int x2, int y2) {
        if (debug != null) {
            debug.entry(49152L, className, "roundup", new Integer(x2), new Integer(y2));
            debug.exit(49152L, (Object)className, "roundup", (x2 + (y2 - 1)) / y2 * y2);
        }
        return (x2 + (y2 - 1)) / y2 * y2;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        int loop = len / src.length;
        if (debug != null) {
            Object[] parms = new Object[]{src, dst, new Integer(start), new Integer(len)};
            debug.entry(49152L, (Object)className, "concat", parms);
        }
        int i2 = 0;
        int off = 0;
        while (i2 < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i2;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
        if (debug != null) {
            debug.exit(49152L, className, "concat");
        }
    }
}

