/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.eclipse.equinox.coordinator.CoordinationImpl;
import org.eclipse.equinox.coordinator.CoordinationReferent;
import org.eclipse.equinox.coordinator.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;

public class CoordinationWeakReference
extends WeakReference<CoordinationReferent> {
    private static final ReferenceQueue<CoordinationReferent> referenceQueue = new ReferenceQueue();
    private final CoordinationImpl coordination;

    public static void processOrphanedCoordinations() {
        CoordinationWeakReference r;
        while ((r = (CoordinationWeakReference)referenceQueue.poll()) != null) {
            CoordinationImpl c = r.getCoordination();
            if (c.isEnding()) continue;
            try {
                try {
                    c.fail(Coordination.ORPHANED);
                }
                catch (Exception e) {
                    c.getLogService().log(2, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e);
                    try {
                        c.end();
                    }
                    catch (CoordinationException e2) {
                        if (Coordination.ORPHANED.equals(e2.getCause())) continue;
                        c.getLogService().log(4, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e2);
                    }
                    catch (Exception e3) {
                        c.getLogService().log(2, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e3);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    c.end();
                }
                catch (CoordinationException e) {
                    if (!Coordination.ORPHANED.equals(e.getCause())) {
                        c.getLogService().log(4, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e);
                    }
                }
                catch (Exception e) {
                    c.getLogService().log(2, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e);
                }
                throw throwable;
            }
            try {
                c.end();
            }
            catch (CoordinationException e) {
                if (Coordination.ORPHANED.equals(e.getCause())) continue;
                c.getLogService().log(4, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e);
            }
            catch (Exception e) {
                c.getLogService().log(2, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), e);
            }
        }
    }

    public CoordinationWeakReference(CoordinationReferent referent, CoordinationImpl coordination) {
        super(referent, referenceQueue);
        if (coordination == null) {
            throw new NullPointerException();
        }
        this.coordination = coordination;
    }

    public CoordinationImpl getCoordination() {
        return this.coordination;
    }
}

