/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install;

import com.ibm.ws.install.Version;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class MapBasedInstallKernel
implements Map {
    private static final String RUNTIME_INSTALL_DIR = "runtime.install.dir";
    private static final String INSTALL_KERNEL_INIT_CODE = "install.kernel.init.code";
    private static final String INSTALL_KERNEL_INIT_ERROR_MESSAGE = "install.kernel.init.error.message";
    private static final String MESSAGE_LOCALE = "message.locale";
    private static final Integer ERROR = 1;
    private final Map data = new HashMap();
    private Map installKernelMap = null;
    private Locale locale;
    private ResourceBundle messagesRes;

    private String getMessage(String key, Object ... args) {
        if (this.messagesRes == null) {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            this.messagesRes = ResourceBundle.getBundle("com.ibm.ws.install.internal.resources.MapBasedInstallKernelMessages", this.locale);
        }
        String message = this.messagesRes.getString(key);
        if (args.length == 0) {
            return message;
        }
        MessageFormat messageFormat = new MessageFormat(message, this.locale);
        return messageFormat.format(args);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (INSTALL_KERNEL_INIT_CODE.equals(key)) {
            return this.initValidate();
        }
        if (INSTALL_KERNEL_INIT_ERROR_MESSAGE.equals(key) || RUNTIME_INSTALL_DIR.equals(key)) {
            return this.data.get(key);
        }
        if (this.installKernelMap == null) {
            throw new RuntimeException(this.getMessage("MAPBASED_ERROR_KERNEL_NOT_INIT", new Object[0]));
        }
        return this.installKernelMap.get(key);
    }

    public Object put(Object key, Object value) {
        if (MESSAGE_LOCALE.equals(key)) {
            if (!(value instanceof Locale)) {
                throw new IllegalArgumentException();
            }
            this.locale = (Locale)value;
            this.data.put(MESSAGE_LOCALE, value);
            if (this.installKernelMap != null) {
                this.installKernelMap.put(key, value);
            }
            return value;
        }
        if (this.installKernelMap == null) {
            if (RUNTIME_INSTALL_DIR.equals(key)) {
                if (value instanceof File) {
                    return this.data.put(RUNTIME_INSTALL_DIR, value);
                }
                throw new IllegalArgumentException();
            }
            this.data.put(INSTALL_KERNEL_INIT_CODE, ERROR);
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.getMessage("MAPBASED_ERROR_KERNEL_NOT_INIT", new Object[0]));
            throw new RuntimeException(this.getMessage("MAPBASED_ERROR_KERNEL_NOT_INIT", new Object[0]));
        }
        return this.installKernelMap.put(key, value);
    }

    public static void sortFile(List<File> jarsList, final String fName) {
        Collections.sort(jarsList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String f1Name = f1.getName();
                f1Name = f1Name.substring(fName.length() + 1, f1Name.length() - 4);
                String f2Name = f2.getName();
                f2Name = f2Name.substring(fName.length() + 1, f2Name.length() - 4);
                Version v1 = Version.createVersion(f1Name);
                Version v2 = Version.createVersion(f2Name);
                if (v1 != null && v2 != null) {
                    return v1.compareTo(v2);
                }
                return f1Name.compareTo(f2Name);
            }
        });
    }

    public static boolean accept(String fName, String name, Version min, Version max) {
        if (fName.startsWith(name + "_") && fName.toLowerCase().endsWith(".jar")) {
            if (min == null || max == null) {
                return true;
            }
            int i = fName.indexOf("_");
            String versionStr = fName.substring(i + 1, fName.length() - 4);
            Version v = Version.createVersion(versionStr);
            if (v == null) {
                return true;
            }
            return v.compareTo(min) >= 0 && v.compareTo(max) < 0;
        }
        return false;
    }

    private URL getURL(File installDir, String[] bundle) {
        Version max;
        Version min;
        final String fName = bundle[0].trim();
        String location = null;
        Version minVersion = null;
        Version maxVersion = null;
        for (String b : bundle) {
            String rangeStr;
            String[] range;
            int j;
            int i;
            if ((b = b.trim()).toLowerCase().startsWith("location=")) {
                location = b.substring(9);
                location = location.replaceAll("\"", "");
                location = location.replaceAll("'", "");
                location = location.trim();
            }
            if (!b.toLowerCase().startsWith("version=") || (i = b.indexOf("[")) <= 0 || (j = b.indexOf(")")) <= 0 || (range = (rangeStr = b.substring(i + 1, j)).split(",")).length <= 1) continue;
            minVersion = Version.createVersion(range[0].trim());
            maxVersion = Version.createVersion(range[1].trim());
        }
        File libDir = new File(installDir, location == null ? "lib" : location);
        File[] jars = libDir.listFiles(new FilenameFilter(){
            final /* synthetic */ Version val$min;
            final /* synthetic */ Version val$max;
            {
                this.val$min = version;
                this.val$max = version2;
            }

            @Override
            public boolean accept(File dir, String name) {
                return MapBasedInstallKernel.accept(name, fName, this.val$min, this.val$max);
            }
        });
        if (jars == null || jars.length == 0) {
            return null;
        }
        if (jars.length == 1) {
            try {
                return jars[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        List<File> jarsList = Arrays.asList(jars);
        MapBasedInstallKernel.sortFile(jarsList, fName);
        try {
            return jarsList.get(jarsList.size() - 1).toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL[] getJars(File installDir) {
        ZipFile wsInstallUtilityJar = null;
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        try {
            String[] requireBundles;
            wsInstallUtilityJar = new JarFile(new File(installDir, "bin/tools/ws-installUtility.jar"));
            Manifest manifest = ((JarFile)wsInstallUtilityJar).getManifest();
            Attributes attributes = manifest.getMainAttributes();
            for (String requireBundle : requireBundles = attributes.getValue("Require-Bundle").split(",")) {
                String[] bundle = requireBundle.split(";");
                URL url = this.getURL(installDir, bundle);
                if (url == null) continue;
                jarURLs.add(url);
            }
        }
        catch (Exception e) {
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, e.getMessage());
            URL[] uRLArray = null;
            return uRLArray;
        }
        finally {
            if (wsInstallUtilityJar != null) {
                try {
                    wsInstallUtilityJar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return jarURLs.toArray(new URL[jarURLs.size()]);
    }

    private Integer initValidate() {
        File installDir = (File)this.data.get(RUNTIME_INSTALL_DIR);
        if (installDir == null) {
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.getMessage("MAPBASED_ERROR_RUNTIME_INSTALL_DIR_NOT_SET", new Object[0]));
            return null;
        }
        if (!installDir.exists()) {
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.getMessage("MAPBASED_ERROR_RUNTIME_INSTALL_DIR_NOT_EXISTS", installDir));
            return null;
        }
        if (!installDir.isDirectory()) {
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.getMessage("MAPBASED_ERROR_RUNTIME_INSTALL_DIR_NOT_DIR", installDir));
            return null;
        }
        final URL[] jars = this.getJars(installDir);
        if (jars == null) {
            return ERROR;
        }
        try {
            this.installKernelMap = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

                @Override
                public Map<String, Object> run() throws Exception {
                    URLClassLoader loader = new URLClassLoader(jars, null);
                    Class<?> clazz = loader.loadClass("com.ibm.ws.install.internal.InstallKernelMap");
                    return (Map)clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.getMessage("MAPBASED_ERROR_KERNEL_INIT_FAILED", e.getMessage()));
            return ERROR;
        }
        for (Object key : this.data.keySet()) {
            this.installKernelMap.put(key, this.data.get(key));
        }
        Integer rc = (Integer)this.installKernelMap.get(INSTALL_KERNEL_INIT_CODE);
        this.data.put(INSTALL_KERNEL_INIT_CODE, rc);
        this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, this.installKernelMap.get(INSTALL_KERNEL_INIT_ERROR_MESSAGE));
        return rc;
    }
}

