/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAIntrospection;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAScopeInfo;
import com.ibm.ws.jpa.management.JaxbPUnit;
import com.ibm.ws.jpa.management.JaxbPersistence;
import com.ibm.ws.jpa.management.JaxbUnmarshaller;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JPAPxmlInfo {
    private static final TraceComponent tc = Tr.register(JPAPxmlInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final JPAScopeInfo ivScopeInfo;
    private final URL ivRootURL;
    private final Map<String, JPAPUnitInfo> ivPuList;

    JPAPxmlInfo(JPAScopeInfo scopeInfo, URL rootURL) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{scopeInfo, rootURL});
        }
        this.ivScopeInfo = scopeInfo;
        this.ivRootURL = rootURL;
        this.ivPuList = new HashMap<String, JPAPUnitInfo>();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    void extractPersistenceUnits(JPAPXml pxml) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractPersistenceUnits : " + pxml), (Object[])new Object[0]);
        }
        JaxbPersistence p = JaxbUnmarshaller.unmarshal(pxml);
        List<JaxbPUnit> pus = p.getPersistenceUnit();
        for (JaxbPUnit pu : pus) {
            String puName = pu.getName();
            JPAApplInfo applInfo = pxml.getApplInfo();
            JPAPuId puId = new JPAPuId(applInfo.getApplName(), pxml.getArchiveName(), puName);
            JPAPUnitInfo puInfo = applInfo.createJPAPUnitInfo(puId, pxml, this.ivScopeInfo);
            puInfo.setPersistenceXMLSchemaVersion(p.getVersion());
            puInfo.setPersistenceUnitRootUrl(pxml.getRootURL());
            puInfo.setTransactionType(pu.getTransactionType());
            puInfo.setPersistenceUnitDescription(pu.getDescription());
            puInfo.setPersistenceProviderClassName(pu.getProvider());
            puInfo.setQualifierAnnotationNames(pu.getQualifier());
            puInfo.setScopeAnnotationName(pu.getScope());
            puInfo.setJtaDataSource(pu.getJtaDataSource());
            puInfo.setNonJtaDataSource(pu.getNonJtaDataSource());
            puInfo.setMappingFileNames(pu.getMappingFile());
            puInfo.setJarFileUrls(pu.getJarFile(), pxml);
            puInfo.setManagedClassNames(pu.getClazz());
            puInfo.setSharedCacheMode(pu.getSharedCacheMode());
            puInfo.setValidationMode(pu.getValidationMode());
            puInfo.setExcludeUnlistedClasses(pu.isExcludeUnlistedClasses());
            puInfo.setProperties(pu.getProperties());
            if (isTraceOn && tc.isDebugEnabled()) {
                String rootURLStr = pxml.getRootURL().getFile();
                int earIndex = rootURLStr.indexOf(applInfo.getApplName() + ".ear");
                if (earIndex != -1) {
                    rootURLStr = rootURLStr.substring(earIndex + applInfo.getApplName().length() + 5);
                }
                rootURLStr = rootURLStr + "META-INF/persistence.xml";
                Tr.debug((TraceComponent)tc, (String)("extractPersistenceUnits : " + applInfo.getApplName() + "|" + pxml.getArchiveName() + "|" + rootURLStr + "|" + puInfo.getPersistenceUnitName() + "|" + (Object)((Object)this.ivScopeInfo.getScopeType()) + "|" + puInfo.dump()), (Object[])new Object[0]);
            }
            if (this.getPuInfo(puName) != null) {
                Tr.warning((TraceComponent)tc, (String)"DUPLICATE_PERSISTENCE_UNIT_DEFINED_CWWJP0007W", (Object[])new Object[]{puName, applInfo.getApplName(), pxml.getArchiveName()});
                puInfo.close();
            } else {
                this.addPU(puName, puInfo);
                puInfo.initialize();
            }
            JPAIntrospection.visitJPAPUnitInfo(puName, puInfo);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("extractPersistenceUnits : # of PU defined = " + this.getPuCount()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            for (JPAPUnitInfo puInfo : this.ivPuList.values()) {
                puInfo.close();
            }
            this.ivPuList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAPUnitInfo getPuInfo(String puName) {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            return this.ivPuList.get(puName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPAPUnitInfo addPU(String puName, JPAPUnitInfo puInfo) {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            return this.ivPuList.put(puName, puInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getPuNames() {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            return this.ivPuList.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPuCount() {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            return this.ivPuList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder toStringBuilder(StringBuilder sbuf) {
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            sbuf.append("\n  PxmlInfo: ScopeName=").append(this.ivScopeInfo.getScopeName()).append("\tRootURL = ").append(this.ivRootURL).append("\t# PUs = ").append(this.ivPuList.size()).append("\t[");
            int index = 0;
            for (JPAPUnitInfo puInfo : this.ivPuList.values()) {
                puInfo.toStringBuilder(sbuf);
                if (++index >= this.ivPuList.size()) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }
        return sbuf;
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIntrospect() {
        HashMap<String, JPAPUnitInfo> ivPuListCopy = new HashMap<String, JPAPUnitInfo>();
        Map<String, JPAPUnitInfo> map = this.ivPuList;
        synchronized (map) {
            ivPuListCopy.putAll(this.ivPuList);
        }
        for (Map.Entry entry : ivPuListCopy.entrySet()) {
            String puName = (String)entry.getKey();
            JPAPUnitInfo jpaPUInfo = (JPAPUnitInfo)entry.getValue();
            JPAIntrospection.visitJPAPUnitInfo(puName, jpaPUInfo);
        }
    }
}

