/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.config.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.rest.config.ConfigBasedRESTHandler;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.rest.handler.config", configurationPolicy=ConfigurationPolicy.IGNORE, service={RESTHandler.class}, property={"com.ibm.wsspi.rest.handler.root=/config"})
public class ConfigRESTHandler
extends ConfigBasedRESTHandler {
    private static final TraceComponent tc = Tr.register(ConfigRESTHandler.class, (String)"rest.config", (String)"com.ibm.ws.rest.handler.config.resources.CWWKOMessages");
    @Reference
    private ConfigurationAdmin configAdmin;
    @Reference
    private WSConfigurationHelper configHelper;
    private ComponentContext context;
    static final long serialVersionUID = -3823236983940002776L;

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
    }

    public boolean filterBy(String name) {
        return true;
    }

    public final String getAPIRoot() {
        return "/config";
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject getConfigInfo(String uid, Dictionary<String, Object> config, Set<String> processed, Locale locale) throws IOException {
        Iterator id;
        String key;
        Enumeration<String> keys;
        String metaTypeElementName;
        String extendsSourcePid;
        String configElementName;
        boolean isAppDefined;
        String configDisplayId = (String)config.get("config.displayId");
        boolean isFactoryPid = configDisplayId.endsWith("]");
        if (isFactoryPid) {
            isAppDefined = configDisplayId.contains("[java:");
            int end = configDisplayId.lastIndexOf(91);
            int begin = configDisplayId.lastIndexOf(47, end) + 1;
            configElementName = configDisplayId.substring(begin, end);
        } else {
            int slash = configDisplayId.lastIndexOf(47);
            isAppDefined = slash >= 0;
            isFactoryPid = isAppDefined;
            configElementName = isAppDefined ? configDisplayId.substring(slash + 1) : configDisplayId;
        }
        if (configElementName.indexOf(46) >= 0 && !configElementName.startsWith("properties.")) {
            return null;
        }
        String servicePid = isFactoryPid ? (String)config.get("service.factoryPid") : (String)config.get("service.pid");
        String string = extendsSourcePid = isFactoryPid ? (String)config.get("ibm.extends.source.factoryPid") : (String)config.get("ibm.extends.source.pid");
        if (!isAppDefined && (metaTypeElementName = this.configHelper.getMetaTypeElementName(extendsSourcePid == null ? servicePid : extendsSourcePid)) != null && metaTypeElementName.equalsIgnoreCase("internal")) {
            return null;
        }
        OrderedJSONObject json = new OrderedJSONObject();
        json.put((Object)"configElementName", (Object)configElementName);
        if (isFactoryPid) {
            json.put((Object)"uid", (Object)uid);
        }
        if (!processed.add(configDisplayId)) {
            json.put((Object)"error", (Object)Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"CWWKO1530_CIRCULAR_DEPENDENCY", (Object[])new Object[]{configElementName}));
            return json;
        }
        boolean registryEntryExists = this.configHelper.registryEntryExists(servicePid);
        if (isAppDefined) {
            try {
                Dictionary defaults = this.configHelper.getMetaTypeDefaultProperties(extendsSourcePid == null ? servicePid : extendsSourcePid);
                if (defaults != null) {
                    String key2;
                    Hashtable<String, Object> merged = new Hashtable<String, Object>();
                    keys = defaults.keys();
                    while (keys.hasMoreElements()) {
                        key2 = (String)keys.nextElement();
                        merged.put(key2, defaults.get(key2));
                    }
                    keys = config.keys();
                    while (keys.hasMoreElements()) {
                        key2 = keys.nextElement();
                        Object value = config.get(key2);
                        if (value instanceof String) {
                            value = this.configHelper.convert(extendsSourcePid == null ? servicePid : extendsSourcePid, key2, (String)value);
                        }
                        merged.put(key2, value);
                    }
                    config = merged;
                }
            }
            catch (ConfigEvaluatorException defaults) {
                void x;
                FFDCFilter.processException((Throwable)defaults, (String)"com.ibm.ws.rest.handler.config.internal.ConfigRESTHandler", (String)"165", (Object)((Object)this), (Object[])new Object[]{uid, config, processed, locale});
                throw new RuntimeException((Throwable)x);
            }
        }
        TreeMap<String, TreeMap<String, Object>> flattened = new TreeMap<String, TreeMap<String, Object>>();
        TreeMap<String, TreeSet<String>> flattenedPids = new TreeMap<String, TreeSet<String>>();
        keys = new TreeSet();
        Enumeration<String> en = config.keys();
        while (en.hasMoreElements()) {
            String possiblePrefix;
            key = en.nextElement();
            if (key.startsWith("config.") || key.startsWith("service.") || key.startsWith("ibm.extends") || key.equals("creates.objectClass") || key.equals("jndiName.unique") || key.startsWith("osgi.ds.")) continue;
            String metaTypeName = this.configHelper.getMetaTypeAttributeName(extendsSourcePid == null ? servicePid : extendsSourcePid, key);
            if ("id".equals(key) && "library".equals(configElementName)) {
                keys.add(key);
                continue;
            }
            if (metaTypeName != null && !metaTypeName.equalsIgnoreCase("internal") || !registryEntryExists) {
                keys.add(key);
                continue;
            }
            int prefixEnd = -1;
            StringBuilder prefix = new StringBuilder();
            String suffix = key;
            while ((prefixEnd = ConfigRESTHandler.nthIndexOf(suffix, ".", 2) + 1) > 0 && suffix.length() >= prefixEnd && (possiblePrefix = suffix.substring(0, prefixEnd)).matches(".*\\.\\d+\\.")) {
                prefix.append(possiblePrefix);
                suffix = suffix.substring(prefixEnd);
            }
            if (prefix.length() > 0) {
                if ("config.referenceType".equals(suffix)) {
                    String flattenedPid = (String)config.get(key);
                    TreeSet<String> f = (TreeSet<String>)flattenedPids.get(flattenedPid);
                    if (f == null) {
                        f = new TreeSet<String>();
                        flattenedPids.put(flattenedPid, f);
                    }
                    f.add(prefix.toString());
                    continue;
                }
                TreeMap<String, Object> f = (TreeMap<String, Object>)flattened.get(prefix.toString());
                if (f == null) {
                    f = new TreeMap<String, Object>();
                    flattened.put(prefix.toString(), f);
                }
                f.put(suffix, config.get(key));
                continue;
            }
            if (metaTypeName != null) continue;
            keys.add(key);
        }
        if ("resourceAdapter".equals(configElementName)) {
            Configuration[] childFirstConfigs;
            String childFirstFilter = "(config.parentPID=" + config.get("service.pid") + ')';
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"child first pid filter", (Object[])new Object[]{childFirstFilter});
                }
                childFirstConfigs = this.configAdmin.listConfigurations(childFirstFilter);
            }
            catch (InvalidSyntaxException metaTypeName) {
                void x;
                FFDCFilter.processException((Throwable)metaTypeName, (String)"com.ibm.ws.rest.handler.config.internal.ConfigRESTHandler", (String)"241", (Object)((Object)this), (Object[])new Object[]{uid, config, processed, locale});
                throw new RuntimeException((Throwable)x);
            }
            if (childFirstConfigs != null) {
                for (Configuration c : childFirstConfigs) {
                    Dictionary props = c.getProperties();
                    String childConfigDisplayId = (String)props.get("config.displayId");
                    int start = configDisplayId.length() + 1;
                    String childElementName = childConfigDisplayId.substring(start, childConfigDisplayId.indexOf(91, start));
                    keys.add(childElementName);
                    config.put(childElementName, Collections.singleton(props.get("service.pid")));
                }
            }
        }
        if (keys.remove("id") && !ConfigRESTHandler.isGenerated((String)((Object)(id = (String)config.get("id"))))) {
            json.put((Object)"id", (Object)id);
        }
        if (keys.remove("jndiName")) {
            json.put((Object)"jndiName", config.get("jndiName"));
        }
        if (!registryEntryExists) {
            json.put((Object)"error", (Object)Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"CWWKO1531_NOT_FOUND", (Object[])new Object[]{configElementName}));
        }
        id = keys.iterator();
        while (id.hasNext()) {
            key = (String)id.next();
            Integer cardinality = this.configHelper.getMetaTypeAttributeCardinality(extendsSourcePid == null ? servicePid : extendsSourcePid, key);
            json.put((Object)key, this.getJSONValue(config.get(key), cardinality, processed, locale));
        }
        for (Map.Entry entry : flattenedPids.entrySet()) {
            String pid = (String)entry.getKey();
            boolean registryEntryExistsForFlattenedConfig = this.configHelper.registryEntryExists(pid);
            JSONArray list = new JSONArray();
            String prefix = null;
            for (String flatConfigPrefix : (SortedSet)entry.getValue()) {
                OrderedJSONObject j = new OrderedJSONObject();
                prefix = flatConfigPrefix;
                SortedMap flattenedConfigProps = (SortedMap)flattened.get(prefix);
                if (flattenedConfigProps != null) {
                    for (Map.Entry prop : flattenedConfigProps.entrySet()) {
                        String key3 = (String)prop.getKey();
                        String metaTypeName = this.configHelper.getMetaTypeAttributeName(pid, key3);
                        Integer cardinality = this.configHelper.getMetaTypeAttributeCardinality(pid, key3);
                        if (metaTypeName != null && metaTypeName.equalsIgnoreCase("internal") && registryEntryExistsForFlattenedConfig) continue;
                        Object value = prop.getValue();
                        if (isAppDefined && value instanceof String) {
                            value = this.configHelper.convert(pid, key3, (String)value);
                        }
                        j.put((Object)key3, this.getJSONValue(value, cardinality, processed, locale));
                    }
                }
                list.add((Object)j);
            }
            String name = (String)config.get(prefix + ".resourceAdapterConfig.id");
            if (name == null) {
                String baseAlias = prefix.replaceAll("\\.\\d+\\.", "");
                name = this.configHelper.aliasFor(pid, baseAlias);
            }
            if (list.size() == 1) {
                String flatAttrName = prefix.substring(0, prefix.indexOf(46));
                Integer cardinality = this.configHelper.getMetaTypeAttributeCardinality(extendsSourcePid == null ? servicePid : extendsSourcePid, flatAttrName);
                if (isAppDefined && cardinality == null && "properties".equals(flatAttrName) && servicePid != null && servicePid.startsWith("com.ibm.ws.jca.") && servicePid.endsWith(".supertype")) {
                    cardinality = 1;
                }
                if (cardinality != null && cardinality >= -1 && cardinality <= 1) {
                    json.put((Object)name, list.get(0));
                    continue;
                }
                json.put((Object)name, (Object)list);
                continue;
            }
            json.put((Object)name, (Object)list);
        }
        if (servicePid != null) {
            ServiceReference[] refs;
            String filter = FilterUtils.createPropertyFilter((String)"com.ibm.wsspi.rest.handler.config.pid", (String)servicePid);
            try {
                refs = this.context.getBundleContext().getServiceReferences((String)null, filter);
            }
            catch (InvalidSyntaxException pid) {
                FFDCFilter.processException((Throwable)pid, (String)"com.ibm.ws.rest.handler.config.internal.ConfigRESTHandler", (String)"329", (Object)((Object)this), (Object[])new Object[]{uid, config, processed, locale});
                refs = null;
            }
            if (refs != null) {
                TreeSet<String> apiRoots = new TreeSet<String>();
                for (ServiceReference ref : refs) {
                    String root = (String)ref.getProperty("com.ibm.wsspi.rest.handler.root");
                    if (root == null) continue;
                    apiRoots.add(root);
                }
                JSONArray api = new JSONArray();
                for (String root : apiRoots) {
                    StringBuilder r = new StringBuilder("/ibm/api");
                    if (root.charAt(0) != '/') {
                        r.append('/');
                    }
                    r.append(root);
                    if (root.charAt(root.length() - 1) != '/') {
                        r.append('/');
                    }
                    r.append(configElementName);
                    if (isFactoryPid) {
                        r.append('/').append(URLEncoder.encode(uid, "UTF-8"));
                    }
                    api.add((Object)r.toString());
                }
                if (!api.isEmpty()) {
                    json.put((Object)"api", (Object)api);
                }
            }
        }
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private Object getJSONValue(Object value, Integer cardinality, Set<String> processed, Locale locale) throws IOException {
        if (value instanceof String) {
            String s = (String)value;
            if (s.matches(".*_\\d+")) {
                Dictionary props;
                String uid;
                JSONObject configInfo;
                Configuration[] c;
                try {
                    String filter = FilterUtils.createPropertyFilter((String)"service.pid", (String)s);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getJSONValue pid filter", (Object[])new Object[]{filter});
                    }
                    c = this.configAdmin.listConfigurations(filter);
                }
                catch (InvalidSyntaxException filter) {
                    void x;
                    FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.rest.handler.config.internal.ConfigRESTHandler", (String)"381", (Object)((Object)this), (Object[])new Object[]{value, cardinality, processed, locale});
                    throw new RuntimeException((Throwable)x);
                }
                if (c != null && (configInfo = this.getConfigInfo(uid = ConfigRESTHandler.getUID((String)(props = c[0].getProperties()).get("config.displayId"), (String)props.get("id")), props, new HashSet<String>(processed), locale)) != null) {
                    value = configInfo;
                }
            }
        } else if (!(value instanceof Number) && !(value instanceof Boolean)) {
            if (value instanceof SerializableProtectedString) {
                value = "******";
            } else if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                if (length == 1 && Integer.valueOf(1).equals(cardinality)) {
                    value = this.getJSONValue(Array.get(value, 0), null, processed, locale);
                } else {
                    JSONArray a = new JSONArray();
                    for (int i = 0; i < length; ++i) {
                        a.add(this.getJSONValue(Array.get(value, i), null, processed, locale));
                    }
                    value = a;
                }
            } else if (value instanceof Collection) {
                Collection list = (Collection)value;
                int length = list.size();
                if (length == 1 && Integer.valueOf(-1).equals(cardinality)) {
                    value = this.getJSONValue(list.iterator().next(), null, processed, locale);
                } else {
                    JSONArray a = new JSONArray();
                    for (Object o : list) {
                        a.add(this.getJSONValue(o, null, processed, locale));
                    }
                    value = a;
                }
            } else {
                value = value.toString();
            }
        }
        return value;
    }

    @Trivial
    private static final String getUID(String configDisplayId, String id) {
        return id == null || configDisplayId.matches(".*/.*\\[.*\\].*") ? configDisplayId : id;
    }

    public Object handleError(RESTRequest request, String uid, String errorMessage) {
        if (uid == null) {
            return this.toJSONObject("error", errorMessage);
        }
        return this.toJSONObject("uid", uid, "error", errorMessage);
    }

    public Object handleSingleInstance(RESTRequest request, String uid, String id, Dictionary<String, Object> configProps) throws IOException {
        return this.getConfigInfo(uid, configProps, new HashSet<String>(), request.getLocale());
    }

    private static final boolean isGenerated(String id) {
        return id.matches(".*//.*\\[.*\\].*");
    }

    @Trivial
    private JSONObject toJSONObject(Object ... args) {
        OrderedJSONObject json = new OrderedJSONObject();
        for (int i = 0; i < args.length; i += 2) {
            json.put(args[i], args[i + 1]);
        }
        return json;
    }

    @Trivial
    private static int nthIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }

    @Trivial
    public void populateResponse(RESTResponse response, Object responseInfo) throws IOException {
        JSONArtifact json;
        if (responseInfo instanceof JSONArtifact) {
            json = (JSONArtifact)responseInfo;
        } else if (responseInfo instanceof List) {
            JSONArray ja = new JSONArray();
            for (Object info : (List)responseInfo) {
                if (info instanceof JSONArtifact) {
                    ja.add(info);
                    continue;
                }
                throw new IllegalArgumentException(info.toString());
            }
            json = ja;
        } else {
            throw new IllegalArgumentException(responseInfo.toString());
        }
        String jsonString = json.serialize(true);
        jsonString = jsonString.replaceAll("\\\\/", "/");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"populateResponse", (Object[])new Object[]{jsonString});
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().write(jsonString.getBytes("UTF-8"));
    }

    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Request method was " + request.getMethod() + " but the config endpoint is restricted to GET requests only."), (Object[])new Object[0]);
            }
            response.setResponseHeader("Accept", "GET");
            response.sendError(405);
            return;
        }
        super.handleRequest(request, response);
    }

    public boolean requireAdministratorRole() {
        return false;
    }
}

