/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TimerBucketMinConfiguration
extends PropertySingleValueConfiguration<Duration> {
    private static final String CLASS_NAME = TimerBucketMinConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -8566042606146426500L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TimerBucketMinConfiguration(String metricName, Duration value) {
        super(metricName, value);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration", "<init>", new Object[]{metricName, value});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<TimerBucketMinConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<TimerBucketMinConfiguration> sloMinConfigCollection = new ArrayDeque<TimerBucketMinConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<TimerBucketMinConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String val;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketMinConfiguration sloMinConfiguration = null;
            Duration dur = null;
            if (keyValueSplit.length != 2) continue;
            String s = keyValueSplit[1];
            if (s.matches("[0-9]+ms")) {
                val = s.substring(0, s.length() - 2);
                dur = Duration.ofMillis(Long.parseLong(val));
            } else if (s.matches("[0-9]+s")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofSeconds(Long.parseLong(val));
            } else if (s.matches("[0-9]+m")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofMinutes(Long.parseLong(val));
            } else if (s.matches("[0-9]+h")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofHours(Long.parseLong(val));
            } else if (s.matches("[0-9]+")) {
                dur = Duration.ofMillis(Long.parseLong(s));
            } else {
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer values with an optional time unit (e.g. ms,s,m,h) are accepted.", new Object[]{s, "mp.metrics.distribution.timer.buckets"});
            }
            if (dur == null) continue;
            sloMinConfiguration = new TimerBucketMinConfiguration(metricName, dur);
            sloMinConfigCollection.addFirst(sloMinConfiguration);
        }
        ArrayDeque<TimerBucketMinConfiguration> arrayDeque = sloMinConfigCollection;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

