/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TimerBucketMaxConfiguration
extends PropertySingleValueConfiguration<Duration> {
    private static final String CLASS_NAME = TimerBucketMaxConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -7551164822014424533L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TimerBucketMaxConfiguration(String metricName, Duration value) {
        super(metricName, value);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration", "<init>", new Object[]{metricName, value});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<TimerBucketMaxConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<TimerBucketMaxConfiguration> sloMinConfigCollection = new ArrayDeque<TimerBucketMaxConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<TimerBucketMaxConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String val;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketMaxConfiguration sloMinConfiguration = null;
            Duration dur = null;
            if (keyValueSplit.length != 2) continue;
            String s = keyValueSplit[1];
            if (s.matches("[0-9]+ms")) {
                val = s.substring(0, s.length() - 2);
                dur = Duration.ofMillis(Long.parseLong(val));
            } else if (s.matches("[0-9]+s")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofSeconds(Long.parseLong(val));
            } else if (s.matches("[0-9]+m")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofMinutes(Long.parseLong(val));
            } else if (s.matches("[0-9]+h")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofHours(Long.parseLong(val));
            } else if (s.matches("[0-9]+")) {
                dur = Duration.ofMillis(Long.parseLong(s));
            } else {
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer values with an optional time unit (e.g. ms,s,m,h) are accepted.", new Object[]{s, "mp.metrics.distribution.timer.buckets"});
            }
            if (dur == null) continue;
            sloMinConfiguration = new TimerBucketMaxConfiguration(metricName, dur);
            sloMinConfigCollection.addFirst(sloMinConfiguration);
        }
        ArrayDeque<TimerBucketMaxConfiguration> arrayDeque = sloMinConfigCollection;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

