/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TimerBucketConfiguration
extends PropertyArrayConfiguration<Duration> {
    private static final String CLASS_NAME = TimerBucketConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -4976305329759764434L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TimerBucketConfiguration(String metricName, Duration[] values) {
        super(metricName, values);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration", "<init>", new Object[]{metricName, values});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<TimerBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<TimerBucketConfiguration> metricSLOConfiguration = new ArrayDeque<TimerBucketConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<TimerBucketConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            Object[] arrDuration = (Duration[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                if ((s = s.trim()).matches("[0-9]+ms")) {
                    String val = s.substring(0, s.length() - 2);
                    return Duration.ofMillis(Long.parseLong(val));
                }
                if (s.matches("[0-9]+s")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofSeconds(Long.parseLong(val));
                }
                if (s.matches("[0-9]+m")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofMinutes(Long.parseLong(val));
                }
                if (s.matches("[0-9]+h")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofHours(Long.parseLong(val));
                }
                if (s.matches("[0-9]+")) {
                    return Duration.ofMillis(Long.parseLong(s));
                }
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer values with an optional time unit (e.g. ms,s,m,h) are accepted.", new Object[]{s, "mp.metrics.distribution.timer.buckets"});
                return null;
            }).filter(s -> s != null).toArray(Duration[]::new);
            Arrays.sort(arrDuration);
            metricBucketConfiguration = new TimerBucketConfiguration(metricName, (Duration[])arrDuration);
            metricSLOConfiguration.addFirst(metricBucketConfiguration);
        }
        ArrayDeque<TimerBucketConfiguration> arrayDeque = metricSLOConfiguration;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

