/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.PropertyConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MetricsConfigurationManager {
    private static final String CLASS_NAME = MetricsConfigurationManager.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final String MP_PERCENTILES_PROP = "mp.metrics.distribution.percentiles";
    static final String MP_HISTOGRAM_BUCKET_PROP = "mp.metrics.distribution.histogram.buckets";
    static final String MP_TIMER_BUCKET_PROP = "mp.metrics.distribution.timer.buckets";
    static final String MP_DEFAULT_BUCKET_PROP = "mp.metrics.distribution.percentiles-histogram.enabled";
    static final String MP_HISTOGRAM_MAX_CONFIG = "mp.metrics.distribution.histogram.max-value";
    static final String MP_HISTOGRAM_MIN_CONFIG = "mp.metrics.distribution.histogram.min-value";
    static final String MP_TIMER_MAX_CONFIG = "mp.metrics.distribution.timer.max-value";
    static final String MP_TIMER_MIN_CONFIG = "mp.metrics.distribution.timer.min-value";
    private static MetricsConfigurationManager instance;
    private volatile Map<String, Collection<MetricPercentileConfiguration>> percentilesConfigMap;
    private volatile Map<String, Collection<HistogramBucketConfiguration>> histogramBucketsConfigMap;
    private volatile Map<String, Collection<TimerBucketConfiguration>> timerBucketsConfigMap;
    private volatile Map<String, Collection<DefaultBucketConfiguration>> defaultBucketConfigMap;
    private volatile Map<String, Collection<HistogramBucketMaxConfiguration>> defaultHistogramBucketMaxConfig;
    private volatile Map<String, Collection<HistogramBucketMinConfiguration>> defaultHistogramBucketMinConfig;
    private volatile Map<String, Collection<TimerBucketMaxConfiguration>> defaultTimerBucketMaxConfig;
    private volatile Map<String, Collection<TimerBucketMinConfiguration>> defaultTimerBucketMinConfig;
    static final long serialVersionUID = -3656142232618906783L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MetricsConfigurationManager() {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "<init>", new Object[0]);
        }
        this.percentilesConfigMap = new HashMap<String, Collection<MetricPercentileConfiguration>>();
        this.histogramBucketsConfigMap = new HashMap<String, Collection<HistogramBucketConfiguration>>();
        this.timerBucketsConfigMap = new HashMap<String, Collection<TimerBucketConfiguration>>();
        this.defaultBucketConfigMap = new HashMap<String, Collection<DefaultBucketConfiguration>>();
        this.defaultHistogramBucketMaxConfig = new HashMap<String, Collection<HistogramBucketMaxConfiguration>>();
        this.defaultHistogramBucketMinConfig = new HashMap<String, Collection<HistogramBucketMinConfiguration>>();
        this.defaultTimerBucketMaxConfig = new HashMap<String, Collection<TimerBucketMaxConfiguration>>();
        this.defaultTimerBucketMinConfig = new HashMap<String, Collection<TimerBucketMinConfiguration>>();
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static synchronized MetricsConfigurationManager getInstance() {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getInstance", new Object[0]);
        }
        if (instance == null) {
            instance = new MetricsConfigurationManager();
        }
        MetricsConfigurationManager metricsConfigurationManager = instance;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            metricsConfigurationManager = metricsConfigurationManager;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getInstance", metricsConfigurationManager);
        }
        return metricsConfigurationManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized MetricPercentileConfiguration getPercentilesConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getPercentilesConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.percentilesConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_PERCENTILES_PROP, String.class);
            return input.isPresent() ? MetricPercentileConfiguration.parseMetricPercentiles((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            MetricPercentileConfiguration retVal = (MetricPercentileConfiguration)MetricPercentileConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{0}\" with values: {1} ", new Object[]{MP_PERCENTILES_PROP, metricName, retVal});
            }
            MetricPercentileConfiguration metricPercentileConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                metricPercentileConfiguration = metricPercentileConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getPercentilesConfiguration", metricPercentileConfiguration);
            }
            return metricPercentileConfiguration;
        }
        MetricPercentileConfiguration metricPercentileConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            metricPercentileConfiguration = metricPercentileConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getPercentilesConfiguration", metricPercentileConfiguration);
        }
        return metricPercentileConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized HistogramBucketConfiguration getHistogramBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getHistogramBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.histogramBucketsConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_BUCKET_PROP, String.class);
            return input.isPresent() ? HistogramBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketConfiguration retVal = (HistogramBucketConfiguration)HistogramBucketConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_HISTOGRAM_BUCKET_PROP, metricName, retVal});
            }
            HistogramBucketConfiguration histogramBucketConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                histogramBucketConfiguration = histogramBucketConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getHistogramBucketConfiguration", histogramBucketConfiguration);
            }
            return histogramBucketConfiguration;
        }
        HistogramBucketConfiguration histogramBucketConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            histogramBucketConfiguration = histogramBucketConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getHistogramBucketConfiguration", histogramBucketConfiguration);
        }
        return histogramBucketConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized TimerBucketConfiguration getTimerBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getTimerBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.timerBucketsConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_BUCKET_PROP, String.class);
            return input.isPresent() ? TimerBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketConfiguration retVal = (TimerBucketConfiguration)TimerBucketConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_TIMER_BUCKET_PROP, metricName, retVal});
            }
            TimerBucketConfiguration timerBucketConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                timerBucketConfiguration = timerBucketConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getTimerBucketConfiguration", timerBucketConfiguration);
            }
            return timerBucketConfiguration;
        }
        TimerBucketConfiguration timerBucketConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            timerBucketConfiguration = timerBucketConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getTimerBucketConfiguration", timerBucketConfiguration);
        }
        return timerBucketConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized DefaultBucketConfiguration getDefaultBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultBucketConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_DEFAULT_BUCKET_PROP, String.class);
            return input.isPresent() ? DefaultBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            DefaultBucketConfiguration retVal = (DefaultBucketConfiguration)DefaultBucketConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_DEFAULT_BUCKET_PROP, metricName, retVal});
            }
            DefaultBucketConfiguration defaultBucketConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                defaultBucketConfiguration = defaultBucketConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultBucketConfiguration", defaultBucketConfiguration);
            }
            return defaultBucketConfiguration;
        }
        DefaultBucketConfiguration defaultBucketConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            defaultBucketConfiguration = defaultBucketConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultBucketConfiguration", defaultBucketConfiguration);
        }
        return defaultBucketConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized HistogramBucketMaxConfiguration getDefaultHistogramMaxBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMaxBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultHistogramBucketMaxConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_MAX_CONFIG, String.class);
            return input.isPresent() ? HistogramBucketMaxConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketMaxConfiguration retVal = (HistogramBucketMaxConfiguration)HistogramBucketMaxConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_HISTOGRAM_MAX_CONFIG, metricName, retVal});
            }
            HistogramBucketMaxConfiguration histogramBucketMaxConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                histogramBucketMaxConfiguration = histogramBucketMaxConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMaxBucketConfiguration", histogramBucketMaxConfiguration);
            }
            return histogramBucketMaxConfiguration;
        }
        HistogramBucketMaxConfiguration histogramBucketMaxConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            histogramBucketMaxConfiguration = histogramBucketMaxConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMaxBucketConfiguration", histogramBucketMaxConfiguration);
        }
        return histogramBucketMaxConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized HistogramBucketMinConfiguration getDefaultHistogramMinBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMinBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultHistogramBucketMinConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_MIN_CONFIG, String.class);
            return input.isPresent() ? HistogramBucketMinConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketMinConfiguration retVal = (HistogramBucketMinConfiguration)HistogramBucketMinConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_HISTOGRAM_MIN_CONFIG, metricName, retVal});
            }
            HistogramBucketMinConfiguration histogramBucketMinConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                histogramBucketMinConfiguration = histogramBucketMinConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMinBucketConfiguration", histogramBucketMinConfiguration);
            }
            return histogramBucketMinConfiguration;
        }
        HistogramBucketMinConfiguration histogramBucketMinConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            histogramBucketMinConfiguration = histogramBucketMinConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultHistogramMinBucketConfiguration", histogramBucketMinConfiguration);
        }
        return histogramBucketMinConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized TimerBucketMaxConfiguration getDefaultTimerMaxBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMaxBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultTimerBucketMaxConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_MAX_CONFIG, String.class);
            return input.isPresent() ? TimerBucketMaxConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketMaxConfiguration retVal = (TimerBucketMaxConfiguration)TimerBucketMaxConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_TIMER_MAX_CONFIG, metricName, retVal});
            }
            TimerBucketMaxConfiguration timerBucketMaxConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                timerBucketMaxConfiguration = timerBucketMaxConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMaxBucketConfiguration", timerBucketMaxConfiguration);
            }
            return timerBucketMaxConfiguration;
        }
        TimerBucketMaxConfiguration timerBucketMaxConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            timerBucketMaxConfiguration = timerBucketMaxConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMaxBucketConfiguration", timerBucketMaxConfiguration);
        }
        return timerBucketMaxConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized TimerBucketMinConfiguration getDefaultTimerMinBucketConfiguration(String metricName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMinBucketConfiguration", new Object[]{metricName});
        }
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultTimerBucketMinConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_MIN_CONFIG, String.class);
            return input.isPresent() ? TimerBucketMinConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketMinConfiguration retVal = (TimerBucketMinConfiguration)TimerBucketMinConfiguration.matches(computedValues, metricName);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, (String)null, "Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", new Object[]{MP_TIMER_MIN_CONFIG, metricName, retVal});
            }
            TimerBucketMinConfiguration timerBucketMinConfiguration = retVal;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                timerBucketMinConfiguration = timerBucketMinConfiguration;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMinBucketConfiguration", timerBucketMinConfiguration);
            }
            return timerBucketMinConfiguration;
        }
        TimerBucketMinConfiguration timerBucketMinConfiguration = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            timerBucketMinConfiguration = timerBucketMinConfiguration;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getDefaultTimerMinBucketConfiguration", timerBucketMinConfiguration);
        }
        return timerBucketMinConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getApplicationName() {
        J2EEName name;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getApplicationName", new Object[0]);
        }
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            String string = name.getApplication();
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                string = string;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getApplicationName", string);
            }
            return string;
        }
        String string = null;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            string = string;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "getApplicationName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void removeConfiguration(String appName) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "removeConfiguration", new Object[]{appName});
        }
        if (appName == null || appName.isEmpty()) {
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "removeConfiguration");
            }
            return;
        }
        this.removeApplicationFromMap(appName, this.percentilesConfigMap);
        this.removeApplicationFromMap(appName, this.histogramBucketsConfigMap);
        this.removeApplicationFromMap(appName, this.timerBucketsConfigMap);
        this.removeApplicationFromMap(appName, this.defaultBucketConfigMap);
        this.removeApplicationFromMap(appName, this.defaultHistogramBucketMaxConfig);
        this.removeApplicationFromMap(appName, this.defaultHistogramBucketMinConfig);
        this.removeApplicationFromMap(appName, this.defaultTimerBucketMaxConfig);
        this.removeApplicationFromMap(appName, this.defaultTimerBucketMinConfig);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "removeConfiguration");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T extends PropertyConfiguration> void removeApplicationFromMap(String appName, Map<String, Collection<T>> map) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "removeApplicationFromMap", new Object[]{appName, map});
        }
        if (map != null && !map.isEmpty()) {
            map.remove(appName);
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager", "removeApplicationFromMap");
        }
    }
}

