/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MetricPercentileConfiguration
extends PropertyArrayConfiguration<Double> {
    private boolean isDisabled;
    private static final String CLASS_NAME = MetricPercentileConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -1156351104109061813L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MetricPercentileConfiguration(String metricName, Double[] percentileValues) {
        super(metricName, percentileValues);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "<init>", new Object[]{metricName, percentileValues});
        }
        this.isDisabled = false;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MetricPercentileConfiguration(String metricName, boolean isDisabled) {
        super(metricName, null);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "<init>", new Object[]{metricName, isDisabled});
        }
        this.isDisabled = false;
        this.isDisabled = isDisabled;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDisabled() {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "isDisabled", new Object[0]);
        }
        boolean bl = this.isDisabled;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            bl = bl;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "isDisabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<MetricPercentileConfiguration> parseMetricPercentiles(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "parseMetricPercentiles", new Object[]{input});
        }
        ArrayDeque<MetricPercentileConfiguration> metricPercentileConfigCollection = new ArrayDeque<MetricPercentileConfiguration>();
        if (input == null || input.length() == 0) {
            input = "*=";
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            MetricPercentileConfiguration metricPercentileConfiguration;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            if (keyValueSplit.length == 1) {
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, true);
            } else {
                Object[] percentileValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                    if (s.matches("[0][.][0-9]+")) {
                        return Double.parseDouble(s);
                    }
                    LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only values 0.0-1.0 inclusively are accepted.", new Object[]{s, "mp.metrics.distribution.percentiles"});
                    return null;
                }).filter(d -> d != null && d >= 0.0 && d <= 1.0).toArray(Double[]::new);
                Arrays.sort(percentileValues);
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, (Double[])percentileValues);
            }
            metricPercentileConfigCollection.addFirst(metricPercentileConfiguration);
        }
        ArrayDeque<MetricPercentileConfiguration> arrayDeque = metricPercentileConfigCollection;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration", "parseMetricPercentiles", arrayDeque);
        }
        return arrayDeque;
    }
}

