/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class HistogramBucketMinConfiguration
extends PropertySingleValueConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketMinConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -2324196063140991408L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HistogramBucketMinConfiguration(String metricName, Double value) {
        super(metricName, value);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration", "<init>", new Object[]{metricName, value});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<HistogramBucketMinConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<HistogramBucketMinConfiguration> metricBucketMinMax = new ArrayDeque<HistogramBucketMinConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<HistogramBucketMinConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketMinConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length != 2) continue;
            if (keyValueSplit[1].matches("[0-9]+[.]*[0-9]*")) {
                Double value = Double.parseDouble(keyValueSplit[1].trim());
                metricBucketConfiguration = new HistogramBucketMinConfiguration(metricName, value);
            } else {
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{keyValueSplit[1], "mp.metrics.distribution.histogram.buckets"});
            }
            if (metricBucketConfiguration == null) continue;
            metricBucketMinMax.addFirst(metricBucketConfiguration);
        }
        ArrayDeque<HistogramBucketMinConfiguration> arrayDeque = metricBucketMinMax;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

