/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class HistogramBucketMaxConfiguration
extends PropertySingleValueConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketMaxConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -8691098106822524695L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HistogramBucketMaxConfiguration(String metricName, Double value) {
        super(metricName, value);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration", "<init>", new Object[]{metricName, value});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<HistogramBucketMaxConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<HistogramBucketMaxConfiguration> metricBucketMinMax = new ArrayDeque<HistogramBucketMaxConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<HistogramBucketMaxConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketMaxConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length != 2) continue;
            if (keyValueSplit[1].matches("[0-9]+[.]*[0-9]*")) {
                Double value = Double.parseDouble(keyValueSplit[1].trim());
                metricBucketConfiguration = new HistogramBucketMaxConfiguration(metricName, value);
            } else {
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{keyValueSplit[1], "mp.metrics.distribution.histogram.buckets"});
            }
            if (metricBucketConfiguration == null) continue;
            metricBucketMinMax.addFirst(metricBucketConfiguration);
        }
        ArrayDeque<HistogramBucketMaxConfiguration> arrayDeque = metricBucketMinMax;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

