/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class HistogramBucketConfiguration
extends PropertyArrayConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = -440560434747170512L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HistogramBucketConfiguration(String metricName, Double[] values) {
        super(metricName, values);
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration", "<init>", new Object[]{metricName, values});
        }
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<HistogramBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<HistogramBucketConfiguration> metricBucketConfiCollection = new ArrayDeque<HistogramBucketConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<HistogramBucketConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            Object[] bucketValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                if (s.matches("[0-9]+[.]*[0-9]*")) {
                    return Double.parseDouble(s);
                }
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{s, "mp.metrics.distribution.histogram.buckets"});
                return null;
            }).filter(x -> x != null).toArray(Double[]::new);
            Arrays.sort(bucketValues);
            metricBucketConfiguration = new HistogramBucketConfiguration(metricName, (Double[])bucketValues);
            metricBucketConfiCollection.addFirst(metricBucketConfiguration);
        }
        ArrayDeque<HistogramBucketConfiguration> arrayDeque = metricBucketConfiCollection;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

