/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.ConcurrentGaugeImpl;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import com.ibm.ws.microprofile.metrics.impl.MeterImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.metrics30.internal.impl.Histogram30Impl;
import io.openliberty.microprofile.metrics30.internal.impl.SimpleTimer30Impl;
import io.openliberty.microprofile.metrics30.internal.impl.Timer30Impl;
import io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager;
import java.security.AccessController;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricRegistry30Impl
implements MetricRegistry {
    protected static final TraceComponent tc = Tr.register(MetricRegistry30Impl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    protected static final String APPLICATION_NAME_VARIABLE = "mp.metrics.appName";
    protected static final String APPLICATION_NAME_TAG = "_app";
    protected static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    protected static Tag[] SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = null;
    protected static Tag[] SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = null;
    protected final ConcurrentMap<MetricID, Metric> metricsMID = new ConcurrentHashMap<MetricID, Metric>();
    protected final ConcurrentMap<String, Metadata> metadataMID = new ConcurrentHashMap<String, Metadata>();
    protected final ConcurrentHashMap<String, Set<MetricID>> applicationMap = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Tag> applicationMPConfigAppNameTagCache = new ConcurrentHashMap();
    private final ConfigProviderResolver configResolver;
    private static final boolean usingJava2Security = System.getSecurityManager() != null;
    private final MetricRegistry.Type registryType;
    static final long serialVersionUID = -6269674875452740262L;

    public MetricRegistry30Impl(ConfigProviderResolver configResolver, String name) {
        this.configResolver = configResolver;
        this.registryType = this.typeOf(name);
        this.resolveMPConfigGlobalTagsByServer();
    }

    public static MetricType from(Metric in) {
        if (Gauge.class.isInstance(in)) {
            return MetricType.GAUGE;
        }
        if (Counter.class.isInstance(in)) {
            return MetricType.COUNTER;
        }
        if (Histogram.class.isInstance(in)) {
            return MetricType.HISTOGRAM;
        }
        if (Meter.class.isInstance(in)) {
            return MetricType.METERED;
        }
        if (Timer.class.isInstance(in)) {
            return MetricType.TIMER;
        }
        if (SimpleTimer.class.isInstance(in)) {
            return MetricType.SIMPLE_TIMER;
        }
        return MetricType.INVALID;
    }

    protected ConcurrentMap<String, Metric> buildMap() {
        return new ConcurrentHashMap<String, Metric>();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.register(Metadata.builder().withName(name).withType(MetricRegistry30Impl.from(metric)).build(), metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, metric, null);
    }

    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        return this.register(metadata, metric, false, tags);
    }

    private <T extends Metric> T register(Metadata metadata, T metric, boolean isResolvedMPConfigAppNameTag, Tag ... tags) throws IllegalArgumentException {
        Metadata existingMetadata;
        if (this.metadataMID.keySet().contains(metadata.getName()) && !metadata.equals(existingMetadata = (Metadata)this.metadataMID.get(metadata.getName()))) {
            throw new IllegalArgumentException("Metadata does not match for existing Metadata for " + metadata.getName());
        }
        MetadataBuilder metadataBuilder = Metadata.builder((Metadata)metadata);
        if (!isResolvedMPConfigAppNameTag) {
            tags = this.combineApplicationTagsWithMPConfigAppNameTag(tags);
        }
        MetricID MetricID2 = new MetricID(metadata.getName(), tags);
        Class<T> metricClass = this.determineMetricClass(metric);
        this.validateMetricNameToSingleType(MetricID2.getName(), metricClass);
        Metric existingMetric = this.metricsMID.putIfAbsent(MetricID2, metric);
        if (existingMetric != null) {
            throw new IllegalArgumentException("A metric named " + MetricID2.getName() + " with tags " + MetricID2.getTagsAsString() + " already exists");
        }
        this.metadataMID.putIfAbsent(metadata.getName(), metadataBuilder.build());
        this.addNameToApplicationMap(MetricID2);
        return metric;
    }

    protected void addNameToApplicationMap(MetricID metricID) {
        String appName = this.getApplicationName();
        this.addNameToApplicationMap(metricID, appName);
    }

    public void addNameToApplicationMap(MetricID metricID, String appName) {
        HashSet<MetricID> newSet;
        if (appName == null) {
            return;
        }
        HashSet<MetricID> metricIDSet = this.applicationMap.get(appName);
        if (metricIDSet == null && (metricIDSet = (HashSet<MetricID>)this.applicationMap.putIfAbsent(appName, newSet = new HashSet<MetricID>())) == null) {
            metricIDSet = newSet;
        }
        metricIDSet.add(metricID);
    }

    public void unRegisterApplicationMetrics() {
        this.unRegisterApplicationMetrics(this.getApplicationName());
    }

    public void unRegisterApplicationMetrics(String appName) {
        if (appName == null) {
            Tr.event((TraceComponent)tc, (String)"Application name is null. Cannot unregister metrics for null application.", (Object[])new Object[0]);
            return;
        }
        Set<MetricID> list = this.applicationMap.remove(appName);
        if (list != null) {
            for (MetricID metricID : list) {
                this.remove(metricID);
            }
        }
        MetricsConfigurationManager.getInstance().removeConfiguration(appName);
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    public Counter counter(String name) {
        return this.counter(name, null);
    }

    public Counter counter(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.COUNTER).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.COUNTER)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.counter(metadata, tags);
    }

    public Counter counter(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.COUNTER).build() : inputMetadata;
        return this.counter(metadata, null);
    }

    public Counter counter(MetricID metricID) {
        return this.counter(metricID.getName(), metricID.getTagsAsArray());
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.COUNTERS, tags);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, null);
    }

    public Histogram histogram(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.HISTOGRAM).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.HISTOGRAM)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.histogram(metadata, tags);
    }

    public Histogram histogram(MetricID metricID) {
        return this.histogram(metricID.getName(), metricID.getTagsAsArray());
    }

    public Histogram histogram(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.HISTOGRAM).build() : inputMetadata;
        return this.histogram(metadata, null);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.HISTOGRAMS, tags);
    }

    public Meter meter(String name) {
        return this.meter(name, null);
    }

    public Meter meter(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.METERED).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.METERED)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.meter(metadata, tags);
    }

    public Meter meter(MetricID metricID) {
        return this.meter(metricID.getName(), metricID.getTagsAsArray());
    }

    public Meter meter(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.METERED).build() : inputMetadata;
        return this.meter(metadata, null);
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.METERS, tags);
    }

    public Timer timer(String name) {
        return this.timer(name, null);
    }

    public Timer timer(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.TIMER).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.TIMER)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.timer(metadata, tags);
    }

    public Timer timer(MetricID metricID) {
        return this.timer(metricID.getName(), metricID.getTagsAsArray());
    }

    public Timer timer(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.TIMER).build() : inputMetadata;
        return this.timer(metadata, null);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.TIMERS, tags);
    }

    public boolean remove(String name) {
        Iterator iterator = this.metricsMID.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MetricID tempMID = (MetricID)entry.getKey();
            if (!tempMID.getName().equals(name)) continue;
            iterator.remove();
        }
        this.metadataMID.remove(name);
        return true;
    }

    public boolean remove(MetricID metricID) {
        Metric metric = (Metric)this.metricsMID.remove(metricID);
        String name = metricID.getName();
        if (metric != null) {
            boolean isLastOne = true;
            for (MetricID mid : this.metricsMID.keySet()) {
                if (!mid.getName().equals(name)) continue;
                isLastOne = false;
                break;
            }
            if (isLastOne) {
                this.metadataMID.remove(name);
            }
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter filter) {
        for (Map.Entry entry : this.metricsMID.entrySet()) {
            if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
            this.remove((MetricID)entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metadataMID.keySet()));
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(Gauge.class, filter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(Counter.class, filter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getMetrics(Meter.class, filter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    private synchronized Tag resolveMPConfigAppNameTag() {
        String appName = this.getApplicationName();
        Tag tag = appName == null ? this.resolveMPConfigAppNameTagByServer() : this.resolveMPConfigAppNameTagByApplication(appName);
        return tag;
    }

    private synchronized Tag[] resolveMPConfigGlobalTagsByServer() {
        if (SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null) {
            Config config = this.configResolver.getConfig();
            Optional globalTags = config.getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
            SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = globalTags.isPresent() ? this.parseGlobalTags((String)globalTags.get()) : new Tag[]{};
        }
        return SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS.length == 0 ? null : SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS;
    }

    private Tag[] parseGlobalTags(String globalTags) {
        if (globalTags == null || globalTags.length() == 0) {
            return null;
        }
        String[] kvPairs = globalTags.split("(?<!\\\\),");
        Tag[] arrayOfTags = new Tag[kvPairs.length];
        int count = 0;
        for (String kvString : kvPairs) {
            if (kvString.length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String[] keyValueSplit = kvString.split("(?<!\\\\)=");
            if (keyValueSplit.length != 2 || keyValueSplit[0].length() == 0 || keyValueSplit[1].length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String key = keyValueSplit[0];
            String value = keyValueSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            arrayOfTags[count] = new Tag(key, value);
            ++count;
        }
        return arrayOfTags;
    }

    private synchronized Tag resolveMPConfigAppNameTagByServer() {
        if (SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG == null) {
            SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG = new Tag[1];
            Config config = this.configResolver.getConfig();
            Optional applicationName = config.getOptionalValue(APPLICATION_NAME_VARIABLE, String.class);
            MetricRegistry30Impl.SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0] = applicationName.isPresent() ? new Tag(APPLICATION_NAME_TAG, (String)applicationName.get()) : null;
        }
        return SERVER_LEVEL_MPCONFIG_APPLICATION_NAME_TAG[0];
    }

    private synchronized Tag resolveMPConfigAppNameTagByApplication(String appName) {
        Tag returnTag;
        if (!this.applicationMPConfigAppNameTagCache.containsKey(appName)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Config config = this.configResolver.getConfig(classLoader);
            Optional applicationName = config.getOptionalValue(APPLICATION_NAME_VARIABLE, String.class);
            Tag appTag = applicationName.isPresent() ? new Tag(APPLICATION_NAME_TAG, (String)applicationName.get()) : new Tag("null", "null");
            this.applicationMPConfigAppNameTagCache.put(appName, appTag);
        }
        return (returnTag = this.applicationMPConfigAppNameTagCache.get(appName)).getTagName().equals("null") ? null : returnTag;
    }

    private Tag[] combineApplicationTagsWithMPConfigAppNameTag(Tag ... tags) {
        return this.combineApplicationTagsWithMPConfigAppNameTag(false, tags);
    }

    private Tag[] combineApplicationTagsWithMPConfigAppNameTag(boolean isSorted, Tag ... tags) {
        AbstractMap tagMap;
        Tag mpConfigAppTag = this.resolveMPConfigAppNameTag();
        AbstractMap abstractMap = tagMap = isSorted ? new TreeMap() : new HashMap();
        if (mpConfigAppTag != null && tags != null) {
            tagMap.put(mpConfigAppTag.getTagName(), mpConfigAppTag.getTagValue());
            for (Tag tag : tags) {
                tagMap.put(tag.getTagName(), tag.getTagValue());
            }
            Tag[] result = new Tag[tagMap.size()];
            int i = 0;
            for (Map.Entry entry : tagMap.entrySet()) {
                result[i] = new Tag((String)entry.getKey(), (String)entry.getValue());
                ++i;
            }
            tags = result;
        } else if (mpConfigAppTag != null && tags == null) {
            tags = new Tag[]{mpConfigAppTag};
        }
        return tags;
    }

    protected <T extends Metric> T getOrAdd(Metadata metadata, MetricBuilder30<T> builder, Tag ... tags) {
        block4: {
            this.validateMetricNameToSingleType(metadata.getName(), builder);
            tags = this.combineApplicationTagsWithMPConfigAppNameTag(tags);
            MetricID metricID = new MetricID(metadata.getName(), tags);
            Metric metric = (Metric)this.metricsMID.get(metricID);
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return this.register(metadata, builder.newMetric(metadata), true, tags);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl", (String)"908", (Object)this, (Object[])new Object[]{metadata, builder, tags});
                    this.validateMetricNameToSingleType(metadata.getName(), builder);
                    Metric added = (Metric)this.metricsMID.get(metricID);
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
    }

    public <T> Gauge<T> getOrAdd(Metadata metadata, Gauge<T> incomingMetric, Tag[] tags) {
        block6: {
            MetricType mt = MetricRegistry30Impl.from(incomingMetric);
            for (MetricID mid : this.metricsMID.keySet()) {
                if (!mid.getName().equals(metadata.getName()) || incomingMetric.getClass().isInstance(this.metricsMID.get(mid))) continue;
                throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
            }
            tags = this.combineApplicationTagsWithMPConfigAppNameTag(tags);
            MetricID metricID = new MetricID(metadata.getName(), tags);
            Metric metric = (Metric)this.metricsMID.get(metricID);
            if (incomingMetric.getClass().isInstance(metric)) {
                return (Gauge)metric;
            }
            if (metric == null) {
                try {
                    return this.register(metadata, (T)incomingMetric, true, tags);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl", (String)"947", (Object)this, (Object[])new Object[]{metadata, incomingMetric, tags});
                    for (MetricID mid : this.metricsMID.keySet()) {
                        if (!mid.getName().equals(metadata.getName()) || incomingMetric.getClass().isInstance(this.metricsMID.get(mid))) continue;
                        throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
                    }
                    Metric added = (Metric)this.metricsMID.get(metricID);
                    if (!incomingMetric.getClass().isInstance(added)) break block6;
                    return (Gauge)added;
                }
            }
        }
        throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
    }

    private <T extends Metric> void validateMetricNameToSingleType(String name, MetricBuilder30<T> builder) {
        for (MetricID mid : this.metricsMID.keySet()) {
            if (!mid.getName().equals(name) || builder.isInstance((Metric)this.metricsMID.get(mid))) continue;
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
    }

    private <T extends Metric> void validateMetricNameToSingleType(String name, Class<T> metricClass) {
        for (Map.Entry entrySet : this.metricsMID.entrySet()) {
            if (!((MetricID)entrySet.getKey()).getName().equals(name) || metricClass.isAssignableFrom(((Metric)entrySet.getValue()).getClass())) continue;
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
    }

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.getMetrics((metricID, metric) -> filter.matches(metricID, metric) && ofType.isAssignableFrom(metric.getClass()));
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricID, Metric> sortedMetricsMap = new TreeMap<MetricID, Metric>();
        for (Map.Entry entry : this.metricsMID.entrySet()) {
            if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
            sortedMetricsMap.put((MetricID)entry.getKey(), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(sortedMetricsMap);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsMID);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadataMID);
    }

    public Metadata getMetadata(String name) {
        return (Metadata)this.metadataMID.get(name);
    }

    protected <T extends Metric> Class<T> determineMetricClass(T metric) {
        if (Counter.class.isInstance(metric)) {
            return Counter.class;
        }
        if (ConcurrentGauge.class.isInstance(metric)) {
            return ConcurrentGauge.class;
        }
        if (Histogram.class.isInstance(metric)) {
            return Histogram.class;
        }
        if (Meter.class.isInstance(metric)) {
            return Meter.class;
        }
        if (Timer.class.isInstance(metric)) {
            return Timer.class;
        }
        if (Gauge.class.isInstance(metric)) {
            return Gauge.class;
        }
        if (SimpleTimer.class.isInstance(metric)) {
            return SimpleTimer.class;
        }
        return null;
    }

    public SortedSet<MetricID> getMetricIDs() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metricsMID.keySet()));
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, null);
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.CONCURRENT_GAUGE).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.CONCURRENT_GAUGE)) {
            throw new IllegalArgumentException(name + " is CONCURRENT_GAUGE used for a different type of metric");
        }
        return this.concurrentGauge(metadata, tags);
    }

    public ConcurrentGauge concurrentGauge(MetricID metricID) {
        return this.concurrentGauge(metricID.getName(), metricID.getTagsAsArray());
    }

    public ConcurrentGauge concurrentGauge(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.CONCURRENT_GAUGE).build() : inputMetadata;
        return this.concurrentGauge(metadata, null);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.CONCURRENT_GAUGE, tags);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getMetrics(ConcurrentGauge.class, filter);
    }

    private ClassLoader getThreadContextClassLoader() {
        if (usingJava2Security) {
            return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public SimpleTimer simpleTimer(String name) {
        return this.simpleTimer(name, null);
    }

    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.SIMPLE_TIMER).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.SIMPLE_TIMER)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.simpleTimer(metadata, tags);
    }

    public SimpleTimer simpleTimer(MetricID metricID) {
        return this.simpleTimer(metricID.getName(), metricID.getTagsAsArray());
    }

    public SimpleTimer simpleTimer(Metadata inputMetadata) {
        Metadata metadata = null;
        metadata = inputMetadata.getTypeRaw() == MetricType.INVALID ? Metadata.builder((Metadata)inputMetadata).withType(MetricType.SIMPLE_TIMER).build() : inputMetadata;
        return this.simpleTimer(metadata, null);
    }

    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder30.SIMPLE_TIMER, tags);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter filter) {
        return this.getMetrics(SimpleTimer.class, filter);
    }

    public Metric getMetric(MetricID metricID) {
        Tag[] combinedTags = this.combineApplicationTagsWithMPConfigAppNameTag(metricID.getTagsAsArray());
        MetricID metricIDWithMPConfigAppTags = new MetricID(metricID.getName(), combinedTags);
        return (Metric)this.metricsMID.get(metricIDWithMPConfigAppTags);
    }

    public MetricRegistry.Type getType() {
        return this.registryType;
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        try {
            return (T)((Metric)asType.cast(this.getMetric(metricID)));
        }
        catch (ClassCastException classCastException) {
            void e;
            FFDCFilter.processException((Throwable)classCastException, (String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl", (String)"1293", (Object)this, (Object[])new Object[]{metricID, asType});
            throw new IllegalArgumentException(metricID + " was not of expected type " + asType, (Throwable)e);
        }
    }

    public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return this.getMetric(metricID, ConcurrentGauge.class);
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    public Meter getMeter(MetricID metricID) {
        return this.getMetric(metricID, Meter.class);
    }

    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    public SimpleTimer getSimpleTimer(MetricID metricID) {
        return this.getMetric(metricID, SimpleTimer.class);
    }

    protected MetricRegistry.Type typeOf(String name) {
        if (name.equals("base")) {
            return MetricRegistry.Type.BASE;
        }
        if (name.equals("vendor")) {
            return MetricRegistry.Type.VENDOR;
        }
        if (name.equals("application")) {
            return MetricRegistry.Type.APPLICATION;
        }
        throw new IllegalArgumentException("Name of registry must be base vendor or application");
    }

    public static Tag[] getCachedGlobalTags() {
        return SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS.length == 0 ? null : SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS;
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.gauge(new MetricID(name, tags), object, func);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T object, Function<T, R> func) {
        Metadata metadata = Metadata.builder().withName(metricID.getName()).withType(MetricType.GAUGE).build();
        return this.gauge(metadata, object, func, metricID.getTagsAsList().toArray(new Tag[0]));
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        return this.gauge(new MetricID(name, tags), supplier);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        Metadata metadata = Metadata.builder().withName(metricID.getName()).withType(MetricType.GAUGE).build();
        return this.gauge(metadata, supplier, metricID.getTagsAsList().toArray(new Tag[0]));
    }

    public <T extends Number> Gauge<T> gauge(Metadata inputMetadata, Supplier<T> supplier, Tag ... tags) {
        Metadata metadata = null;
        if (inputMetadata.getTypeRaw() == MetricType.INVALID) {
            metadata = Metadata.builder((Metadata)inputMetadata).withType(MetricType.GAUGE).build();
        } else {
            if (inputMetadata.getTypeRaw() != MetricType.GAUGE) {
                throw new IllegalArgumentException("The Metadata does not contain the appropriate Metric Type for a Gauge. The value retrieved is " + inputMetadata.getType());
            }
            metadata = inputMetadata;
        }
        String name = metadata.getName();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.GAUGE)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        GaugeSupplier<T> gauge = new GaugeSupplier<T>(supplier);
        return this.getOrAdd(metadata, gauge, tags);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata inputMetadata, T object, Function<T, R> func, Tag ... tags) {
        Metadata metadata = null;
        if (inputMetadata.getTypeRaw() == MetricType.INVALID) {
            metadata = Metadata.builder((Metadata)inputMetadata).withType(MetricType.GAUGE).build();
        } else {
            if (inputMetadata.getTypeRaw() != MetricType.GAUGE) {
                throw new IllegalArgumentException("The Metadata does not contain the appropriate Metric Type for a Gauge. The value retrieved is " + inputMetadata.getType());
            }
            metadata = inputMetadata;
        }
        String name = metadata.getName();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.GAUGE)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        GaugeToDoubleFunction<T, R> gauge = new GaugeToDoubleFunction<T, R>(object, func);
        return this.getOrAdd(metadata, gauge, tags);
    }

    public static interface MetricBuilder30<T extends Metric> {
        public static final MetricBuilder30<Counter> COUNTERS = new MetricBuilder30<Counter>(){
            static final long serialVersionUID = -3299929665559303562L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Counter newMetric() {
                return new CounterImpl();
            }

            @Override
            public Counter newMetric(Metadata metadata) {
                return new CounterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Counter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$1", 1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder30<ConcurrentGauge> CONCURRENT_GAUGE = new MetricBuilder30<ConcurrentGauge>(){
            static final long serialVersionUID = 9024716636070935574L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public ConcurrentGauge newMetric() {
                return new ConcurrentGaugeImpl();
            }

            @Override
            public ConcurrentGauge newMetric(Metadata metadata) {
                return new ConcurrentGaugeImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ConcurrentGauge.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$2", 2.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder30<Histogram> HISTOGRAMS = new MetricBuilder30<Histogram>(){
            static final long serialVersionUID = -1996450963990251149L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Histogram newMetric(Metadata metadata) {
                return new Histogram30Impl(new ExponentiallyDecayingReservoir(), metadata);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Histogram.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$3", 3.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder30<Meter> METERS = new MetricBuilder30<Meter>(){
            static final long serialVersionUID = -5689562874361072142L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Meter newMetric() {
                return new MeterImpl();
            }

            @Override
            public Meter newMetric(Metadata metadata) {
                return new MeterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$4", 4.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder30<Timer> TIMERS = new MetricBuilder30<Timer>(){
            static final long serialVersionUID = 2210725066071577208L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Timer newMetric(Metadata metadata) {
                return new Timer30Impl(metadata);
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Timer.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$5", 5.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder30<SimpleTimer> SIMPLE_TIMER = new MetricBuilder30<SimpleTimer>(){
            static final long serialVersionUID = 8896011782946352617L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public SimpleTimer newMetric() {
                return new SimpleTimer30Impl();
            }

            @Override
            public SimpleTimer newMetric(Metadata metadata) {
                return new SimpleTimer30Impl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return SimpleTimer.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$MetricBuilder30$6", 6.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };

        public T newMetric(Metadata var1);

        public boolean isInstance(Metric var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GaugeSupplier<T extends Number>
    implements Gauge<T> {
        final Supplier<T> supplier;
        static final long serialVersionUID = 8037584226386908325L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        GaugeSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T getValue() {
            return (T)((Number)this.supplier.get());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$GaugeSupplier", GaugeSupplier.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GaugeToDoubleFunction<T, R extends Number>
    implements Gauge<R> {
        final Function<T, R> func;
        final T object;
        static final long serialVersionUID = 8095121270023874196L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        GaugeToDoubleFunction(T object, Function<T, R> func) {
            this.func = func;
            this.object = object;
        }

        public R getValue() {
            return (R)((Number)this.func.apply(this.object));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl$GaugeToDoubleFunction", GaugeToDoubleFunction.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }
}

